package com.wxpn.tutorial.ec.servlet;

import java.io.IOException;
import java.util.Collection;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.wxpn.tutorial.ec.bean.ECOrder;
import com.wxpn.tutorial.ec.bean.ECOrderItemMgr;
import com.wxpn.tutorial.ec.bean.ECOrderMgr;

/**
 * Servlet implementation class for Servlet: UserListServlet
 */
public class OrderServlet extends javax.servlet.http.HttpServlet implements
		javax.servlet.Servlet {
	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public OrderServlet() {
		super();
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		response.setHeader("Pragma", "No-cache");
		response.setHeader("Cache-Control", "no-cache");
		response.setDateHeader("Expires", 0);

		if (request.getSession().getAttribute("username") == null) {
			response.sendRedirect("/ECommerce/member/login.jsp");
		} else {
			String id = request.getParameter("id");

			ECOrderItemMgr mgr = new ECOrderItemMgr();
			Collection c = mgr.getAll("where orderid='"+id+"'");
			request.setAttribute("c", c);

			try {
				request.getRequestDispatcher("/book_store/order.jsp").forward(
						request, response);
			} catch (Throwable t) {
				getServletContext().log(t.getMessage());
			}
		}
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		if (request.getSession().getAttribute("username") == null) {
			response.sendRedirect("/member/login.jsp");
		} else {
			ECOrderMgr mgr = new ECOrderMgr();
			String address = request.getParameter("address");
			String userphone = request.getParameter("tel");
			String usercid = request.getParameter("usercid");
			String[] itemid = request.getParameterValues("itemid");

			ECOrder order = new ECOrder();
			order.setUsername(request.getSession().getAttribute("username")
					.toString());
			order.setUseraddress(address);
			order.setUserphone(userphone);
			order.setUsercid(usercid);
			mgr.add(order, itemid);

			String clause = "where username='"
					+ request.getSession().getAttribute("username").toString()
					+ "'";
			int pagesize = 10;
			int count = mgr.getCount(clause);// ¼
			int totalPageNum = count / pagesize;// ߼ҳ
			// ¼ÿҳʾ,0,ô
			// ߼ҳӦΪ+1
			if ((count % pagesize) > 0) {
				totalPageNum += 1;
			}

			request.setAttribute("totalPageNum", new Integer(totalPageNum));
			Collection c = mgr.getAll(pagesize, 1, clause);
			request.setAttribute("c", c);
			try {
				request.getRequestDispatcher("/book_store/orderlist.jsp")
						.forward(request, response);
			} catch (Throwable t) {
				getServletContext().log(t.getMessage());
			}
		}
	}
}