package com.wxpn.tutorial.ec.servlet;

import java.io.IOException;
import java.util.Collection;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.wxpn.tutorial.ec.bean.ECBookMgr;

/**
 * Servlet implementation class for Servlet: UserListServlet
 */
public class SearchBookServlet extends javax.servlet.http.HttpServlet implements
		javax.servlet.Servlet {
	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public SearchBookServlet() {
		super();
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		response.setHeader("Pragma","No-cache");
		response.setHeader("Cache-Control","no-cache");
		response.setDateHeader("Expires", 0);
		
		String type = request.getParameter("type");
		String clause = "";
		String keyword = request.getParameter("keyword");
		String way = request.getParameter("way");
		if ((type == null)||(type.equals("null"))) {
			if (way.trim().equals("1")) {
				clause = "where name like '%" + keyword + "%'";
			} else if (way.trim().equals("2")) {
				clause = "where author like '%" + keyword + "%'";
			} else if (way.trim().equals("3")) {
				clause = "where publish_name like '%" + keyword + "%'";
			}
		} else if (type.equals("discount")) {
			clause = "where discount='1'";
		} else if (type.equals("short")) {
			clause = "where stock<=0";
		}

		int pagesize = 10;
		String page = request.getParameter("page");
		ECBookMgr mgr = new ECBookMgr();
		int count = mgr.getCount(clause);// ¼
		int totalPageNum = count / pagesize;// ߼ҳ
		// ¼ÿҳʾ,0,ô
		// ߼ҳӦΪ+1
		if ((count % pagesize) > 0) {
			totalPageNum += 1;
		}
		if (page == null) {
			page = "1";
		}
		request.setAttribute("totalPageNum", new Integer(totalPageNum));
		Collection c = mgr.getAll(pagesize, Integer.parseInt(page), clause);
		request.setAttribute("c", c);
		try {
			request.getRequestDispatcher(
					"/search/result.jsp?type=" + type + "&keyword=" + keyword
							+ "&way=" + way).forward(request, response);
		} catch (Throwable t) {
			getServletContext().log(t.getMessage());
		}
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		response.setHeader("Pragma","No-cache");
		response.setHeader("Cache-Control","no-cache");
		response.setDateHeader("Expires", 0);
		
		String clause = "";
		String keyword = request.getParameter("keyword");
		String way = request.getParameter("way");

		if (way.trim().equals("1")) {
			clause = "where name like '%" + keyword + "%'";
		} else if (way.trim().equals("2")) {
			clause = "where author like '%" + keyword + "%'";
		} else if (way.trim().equals("3")) {
			clause = "where publish_name like '%" + keyword + "%'";
		}

		int pagesize = 10;
		String page = request.getParameter("page");
		ECBookMgr mgr = new ECBookMgr();
		int count = mgr.getCount(clause);// ¼
		int totalPageNum = count / pagesize;// ߼ҳ
		// ¼ÿҳʾ,0,ô
		// ߼ҳӦΪ+1
		if ((count % pagesize) > 0) {
			totalPageNum += 1;
		}
		if (page == null) {
			page = "1";
		}
		request.setAttribute("totalPageNum", new Integer(totalPageNum));
		Collection c = mgr.getAll(pagesize, Integer.parseInt(page), clause);
		request.setAttribute("c", c);
		try {
			request.getRequestDispatcher("/search/result.jsp").forward(request,
					response);
		} catch (Throwable t) {
			getServletContext().log(t.getMessage());
		}
	}
}