package com.wxpn.tutorial.ec.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.wxpn.tutorial.ec.bean.ECBook;
import com.wxpn.tutorial.ec.bean.ECBookMgr;

/**
 * Servlet implementation class for Servlet: ShowBookServlet
 */
public class ShowBookServlet extends javax.servlet.http.HttpServlet implements
		javax.servlet.Servlet {
	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public ShowBookServlet() {
		super();
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		response.setHeader("Pragma","No-cache");
		response.setHeader("Cache-Control","no-cache");
		response.setDateHeader("Expires", 0);
		
		String id = request.getParameter("id");
		String url=request.getParameter("url");
		if (id == null) {
			request.setAttribute("error", "<h1>ʧ!</h1>");
		} else {
			ECBookMgr mgr = new ECBookMgr();

			ECBook book = mgr.get(Integer.parseInt(id));
			request.setAttribute("book", book);
		}
		try {
			request.getRequestDispatcher("/book_store/book.jsp")
					.forward(request, response);
		} catch (Throwable t) {
			getServletContext().log(t.getMessage());
		}
	}	
}