package com.wxpn.tutorial.ec.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public class ProvinceHandler {
	private static String resourcePath;

	private static Properties configProperties = System.getProperties();

	/**
	 *λļconfig.propertiesλ
	 */

	static {
		int pos = 0;
		URL url = ProvinceHandler.class.getResource("ProvinceHandler.class");

		String pkgName = ProvinceHandler.class.getPackage().getName();

		do {
			pos = pkgName.indexOf(".");
			if (pos > 0) {
				pkgName = pkgName.substring(0, pos) + "/"
						+ pkgName.substring(pos + 1);
			}
		} while (pos > 0);

		String filePath = url.getFile();
		String appPath = filePath.substring(0, filePath.indexOf("/classes/"
				+ pkgName));
		resourcePath = appPath + "/resources";

		try {
			configProperties.load(new FileInputStream(ProvinceHandler
					.getResourcePath()
					+ "/province.properties"));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * @return
	 */
	public static String getResourcePath() {
		return resourcePath;
	}

	/**
	 * @return
	 */
	public static Properties getConfigProperties() {
		return configProperties;
	}

	public static String getProperty(String name) {
		return getConfigProperties().getProperty(name);
	}

	public static String getNames() {
		StringBuffer out = new StringBuffer();
		String serverName = null;

		out.append("<select name=\"Province\" size=\"1\">\n");
		int serverCount = Integer
				.parseInt(ProvinceHandler.getProperty("count"));
		for (int i = 1; i <= serverCount; i++) {
			serverName = ProvinceHandler.getProperty("city" + i);
			out.append("<option value=\"").append(serverName).append("\">")
					.append(serverName).append("</option>\n");
		}
		out.append("</select>\n");
		return out.toString();
	}

	public static void main(String[] args) {
		Properties p = getConfigProperties();
		p.elements();
		String s = getProperty("city");
		System.out.println(getNames());
	}

}
