/**
 *  Title  Źϵͳ
 *  @author: Ϧ
 *  @version 1.0
 *  news_categoryһЩɾģѯ
 */
package com.wxpn.tutorial.control.news;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;

import com.wxpn.tutorial.bean.news.Category;
import com.wxpn.tutorial.db.DBConnect;

public class CategoryMgr {

	public CategoryMgr() {
	}

	/*
	 * ޸Ŀ
	 */
	public void modify(Category category) {
		DBConnect dbc = null;
		try {
			dbc = new DBConnect();
			dbc
					.prepareStatement("UPDATE news_category SET name=? and master=? WHERE id=?");
			dbc.setString(1, new String(category.getName().getBytes("ISO8859_1"),"UTF-8"));
			dbc.setString(2, new String(category.getMaster().getBytes("ISO8859_1"),"UTF-8"));
			dbc.setInt(3, category.getId());
			dbc.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				dbc.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	/*
	 * ɾĿ
	 */
	public void delete(int id) {
		DBConnect dbc = null;
		try {
			dbc = new DBConnect();
			dbc.prepareStatement("delete from news_category WHERE id=?");
			dbc.setInt(1, id);
			dbc.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				dbc.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	/*
	 * µĿ
	 */
	public void add(Category category) {
		DBConnect dbc = null;
		try {
			dbc = new DBConnect();
			dbc
					.prepareStatement("INSERT INTO news_category(name,master) VALUES (?,?)");
			dbc.setString(1, new String(category.getName().getBytes("ISO8859_1"),"UTF-8"));
			dbc.setString(2, new String(category.getMaster().getBytes("ISO8859_1"),"UTF-8"));
			dbc.executeUpdate();
		} catch (Exception e) {
			System.err.println(e);
		} finally {
			try {
				dbc.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	/*
	 * õĿ
	 */
	public Collection getAll() {
		DBConnect dbc = null;
		Collection c = new ArrayList();
		ResultSet rs = null;
		try {
			dbc = new DBConnect();
			dbc.prepareStatement("SELECT * FROM news_category order by id asc");
			rs = dbc.executeQuery();
			Category category = null;
			while (rs.next()) {
				category = new Category();
				category.setId(rs.getInt("id"));
				category.setName(rs.getString("name"));
				category.setMaster(rs.getString("master"));
				c.add(category);
				category = null;
			}
		} catch (Exception e) {
			System.err.println(e);
		} finally {
			try {
				if (rs != null) {
					rs.close();
				}
				dbc.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return c;
	}

	/*
	 * IDõĿ
	 */
	public Category getById(int id) {
		DBConnect dbc = null;
		Category iclass = new Category();
		ResultSet rs = null;
		try {
			dbc = new DBConnect();
			dbc.prepareStatement("SELECT * FROM news_category WHERE id = ?");
			dbc.setInt(1, id);
			rs = dbc.executeQuery();
			if (rs.next()) {
				iclass.setId(rs.getInt("id"));
				iclass.setName(rs.getString("name"));
				iclass.setMaster(rs.getString("master"));
			}
		} catch (Exception e) {
			System.err.println(e);
		} finally {
			try {
				if (rs != null) {
					rs.close();
				}
				dbc.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return iclass;
	}

	/*
	 * Ŀ
	 */
	public int getTotal() {
		DBConnect dbc = null;
		int count = 0;
		ResultSet rs = null;
		try {
			dbc = new DBConnect();
			dbc.prepareStatement("SELECT count(*) FROM news_category");
			rs = dbc.executeQuery();
			if (rs.next())
				count = rs.getInt(1);
		} catch (Exception e) {
			System.err.println(e);
		} finally {
			try {
				if (rs != null) {
					rs.close();
				}
				dbc.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return count;
	}

}