package com.wxpn.tutorial.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBConnect {
	private Connection conn = null;

	private Statement stmt = null;

	private PreparedStatement prepstmt = null;

	private ConnectionPool connPool = null;

	void init() {
		connPool = DB.getConnPool();

		conn = connPool.getConnection();
	}

	/**
	 * ݿӺͷ
	 */
	public DBConnect() throws Exception {
		init();
		stmt = conn.createStatement();
	}

	/**
	 * PreparedStatement
	 * 
	 * @return sql ԤSQL
	 */
	public void prepareStatement(String sql) throws SQLException {
		prepstmt = conn.prepareStatement(sql);
	}

	/**
	 * öӦֵ
	 * 
	 * @param index
	 *            
	 * @param value
	 *            Ӧֵ
	 */
	public void setString(int index, String value) throws SQLException {
		prepstmt.setString(index, value);
	}

	public void setInt(int index, int value) throws SQLException {
		prepstmt.setInt(index, value);
	}

	public void setBoolean(int index, boolean value) throws SQLException {
		prepstmt.setBoolean(index, value);
	}

	public void setDate(int index, Date value) throws SQLException {
		prepstmt.setDate(index, value);
	}

	public void setLong(int index, long value) throws SQLException {
		prepstmt.setLong(index, value);
	}

	public void setFloat(int index, float value) throws SQLException {
		prepstmt.setFloat(index, value);
	}

	public void setBytes(int index, byte[] value) throws SQLException {
		prepstmt.setBytes(index, value);
	}

	/**
	 * ִSQL䷵ֶμ
	 * 
	 * @param sql
	 *            SQL
	 * @return ResultSet ֶμ
	 */
	public ResultSet executeQuery(String sql) throws SQLException {
		if (stmt != null) {
			return stmt.executeQuery(sql);
		} else
			return null;
	}

	public ResultSet executeQuery() throws SQLException {
		if (prepstmt != null) {
			return prepstmt.executeQuery();
		} else
			return null;
	}

	/**
	 * ִSQL
	 * 
	 * @param sql
	 *            SQL
	 */
	public void executeUpdate(String sql) throws SQLException {
		if (stmt != null)
			stmt.executeUpdate(sql);
	}

	public void executeUpdate() throws SQLException {
		if (prepstmt != null)
			prepstmt.executeUpdate();
	}

	/**
	 * ر
	 */
	public void close() throws Exception {
		if (stmt != null) {
			stmt.close();
			stmt = null;
		}
		if (prepstmt != null) {
			prepstmt.close();
			prepstmt = null;
		}
		if (conn != null) {

			connPool.freeConnection(conn);

		}

	}
}