package com.wxpn.tutorial.servlet;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.wxpn.tutorial.db.ConnectionPool;
import com.wxpn.tutorial.db.DB;

/**
 * Servlet implementation class for Servlet: ComposeServlet
 */
public class ComposeServlet extends javax.servlet.http.HttpServlet implements
		javax.servlet.Servlet {
	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public ComposeServlet() {
		super();
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		String mb_title = request.getParameter("MB_TITLE");
		String mb_content = request.getParameter("MB_CONTENT");

		News msg = new News();
		msg.setTitle(mb_title);
		msg.setContent(mb_content);
		msg.setAuthor(request.getSession().getAttribute("userName").toString());
		msg.setCompose_date(new Date());
		NewsMgr mgr = new NewsMgr();

		int i = mgr.addMessage(msg);
		if (i == 1) {
			// ׫дԳɹ
			Collection c = mgr.getAllMessages(5, 1);
			request.setAttribute("c", c);
			try {
				request.getRequestDispatcher("/admin_browse.jsp").forward(request,
						response);
			} catch (Throwable t) {
				getServletContext().log(t.getMessage());
			}
		} else {
			// 򣬱׫дʧܣ
			request.setAttribute("error", "<h1>׫дʧ!</h1>");
			try {
				request.getRequestDispatcher("/compose.jsp").forward(request,
						response);
			} catch (Throwable t) {
				getServletContext().log(t.getMessage());
			}
		}
	}
}