/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.project;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.MModel;
import com.justinmind.server.model.project.EventType;
import com.justinmind.server.model.project.MProject;
import com.justinmind.server.model.prototype.MPrototype;
import com.justinmind.server.model.user.MUser;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="event")
public class MEvent
extends MModel
implements Serializable {
    private static final long serialVersionUID = 6677311440277821885L;
    private String text;
    private EventType type;
    private MProject project;
    private MPrototype prototype;
    private MUser user;

    public MEvent() {
    }

    public MEvent(MProject project, MUser user, EventType type) {
        this.project = project;
        this.user = user;
        this.type = type;
    }

    public MEvent(MProject project, MPrototype publishPrototype, MUser currentUser, EventType type) {
        this(project, currentUser, type);
        this.prototype = publishPrototype;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="project_fk")
    public MProject getProject() {
        return this.project;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_fk")
    public MUser getUser() {
        return this.user;
    }

    public void setProject(MProject project) {
        this.project = project;
    }

    public void setUser(MUser user) {
        this.user = user;
    }

    @Basic
    @Column(name="text", length=100, nullable=true)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false)
    public EventType getType() {
        return this.type;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="prototype_fk")
    public MPrototype getPrototype() {
        return this.prototype;
    }

    public void setPrototype(MPrototype prototype) {
        this.prototype = prototype;
    }

    @Override
    public void deletePersistent() {
        super.deletePersistent();
        if (this.project != null) {
            this.project.getEvents().remove(this);
        }
        if (this.prototype != null) {
            this.prototype.getEvents().remove(this);
        }
        if (this.user != null) {
            this.user.getEventsAuthored().remove(this);
        }
        HibernateDAOFactory.getMEventDAO().makeTransient((Object)this);
    }
}

