/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.project;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.project.MEvent;
import com.justinmind.server.model.prototype.MPrototype;
import com.justinmind.server.model.teamwork.AbstractMProject;
import com.justinmind.server.model.user.MAccount;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;

@Entity
@Table(name="project")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class MProject
extends AbstractMProject
implements Serializable {
    private static final long serialVersionUID = 4569107587201356223L;
    public static final String PROJECT_PREFIX = "project";
    private MAccount account;
    private Set<MPrototype> prototypes = new HashSet<MPrototype>();
    private Set<MEvent> events = new HashSet<MEvent>();
    private Date archived;

    public void setAccount(MAccount account) {
        this.account = account;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="account_fk")
    public MAccount getAccount() {
        return this.account;
    }

    public MProject() {
    }

    public MProject(MAccount account) {
        this.setAccount(account);
    }

    @OneToMany(mappedBy="project")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    public Set<MPrototype> getPrototypes() {
        return this.prototypes;
    }

    public void setPrototypes(Set<MPrototype> prototypes) {
        this.prototypes = prototypes;
    }

    @OneToMany(mappedBy="project")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @OptimisticLock(excluded=true)
    public Set<MEvent> getEvents() {
        return this.events;
    }

    public void setEvents(Set<MEvent> events) {
        this.events = events;
    }

    @Transient
    public String getPath() {
        return String.valueOf(this.getAccount().getPath()) + this.getFolder() + "/";
    }

    @Transient
    public String getFolder() {
        return PROJECT_PREFIX + this.id;
    }

    @Transient
    public String getTestFolder() {
        return this.getAccount().getId() + "/" + this.id;
    }

    @Transient
    public static Long getIdFromFolder(String folder) {
        if (!folder.startsWith(PROJECT_PREFIX)) {
            return null;
        }
        try {
            return Long.parseLong(folder.substring(PROJECT_PREFIX.length()));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @Override
    public void deletePersistent() {
        super.deletePersistent();
        ArrayList<MPrototype> protosToRemove = new ArrayList<MPrototype>();
        protosToRemove.addAll(this.prototypes);
        for (MPrototype p : protosToRemove) {
            if (p.getReviewPublication() != null && p.getReviewPublication().getStatus().isBrowseable()) {
                this.account.decreaseDiskUsed(p.getDiskSize());
            }
            p.deletePersistent();
        }
        HibernateDAOFactory.getMPermissionDAO().deleteAllProjectPermissions((AbstractMProject)this);
        ArrayList<MEvent> toRemove = new ArrayList<MEvent>();
        toRemove.addAll(this.events);
        for (MEvent e : toRemove) {
            if (e.getPrototype() != null) continue;
            e.deletePersistent();
        }
        this.account.removeProject(this);
        HibernateDAOFactory.getMProjectDAO().makeTransient((Object)this);
    }

    public void setArchived(Date archived) {
        this.archived = archived;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="archived", nullable=true)
    public Date getArchived() {
        return this.archived;
    }

    @Transient
    public boolean isProjectArchived() {
        return this.isEntityDeleted() && this.archived != null;
    }

    @Transient
    public void markProjectArchived() {
        this.delete();
        this.setArchived(new Date());
    }

    @Transient
    public void unmarProjectArchived() {
        this.deleted = null;
        this.setArchived(null);
    }
}

