/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.prototype;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.MModel;
import com.justinmind.server.model.prototype.MPrototype;
import com.justinmind.server.model.user.MUser;
import com.justinmind.util.tree.adjacencytree.IAdjacencyTreeNode;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Type;

@Entity
@Table(name="commenttable")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class MComment
extends MModel
implements IAdjacencyTreeNode,
Serializable {
    private static final long serialVersionUID = -3865145148401790715L;
    private Set<MUser> users = new HashSet<MUser>();
    private MPrototype prototype;
    private MUser user;
    private MComment parent;
    private MComment rootParent;
    private Boolean isRead;
    private String canvasURL;
    private String author;
    private String canvasID;
    private Long code;
    private String content;
    private String elementID;
    private String fileName;
    private byte[] fileData;
    private String legend;
    private String scenario;
    private Long parentCode;

    public MComment() {
    }

    public MComment(MPrototype prototype, MUser user, String author, MComment parent, MComment rootParent, Boolean isRead, String screenName, String canvasID, Long code, String content, String elementID, String fileName, byte[] fileData, String legend, Long parentCode, String scenario) {
        this.prototype = prototype;
        this.user = user;
        this.parent = parent;
        this.rootParent = rootParent != null ? rootParent : this;
        this.isRead = isRead != null ? isRead : false;
        this.canvasURL = screenName != null ? screenName : "";
        this.author = author;
        this.canvasID = canvasID;
        this.code = code;
        this.content = content;
        this.elementID = elementID;
        this.fileName = fileName;
        this.fileData = fileData;
        this.legend = legend;
        this.scenario = scenario;
        this.parentCode = parentCode;
    }

    @ManyToMany(targetEntity=MUser.class, fetch=FetchType.LAZY)
    @JoinTable(name="readcomment_user", joinColumns={@JoinColumn(name="comment_id")}, inverseJoinColumns={@JoinColumn(name="user_id")})
    @OptimisticLock(excluded=true)
    public Set<MUser> getUsers() {
        return this.users;
    }

    public void setUsers(Set<MUser> users) {
        this.users = users;
    }

    @Transient
    public Set<MUser> addUser(MUser newUser) {
        this.users.add(newUser);
        return this.users;
    }

    @Transient
    public Set<MUser> removeUser(MUser userToRemove) {
        this.users.remove(userToRemove);
        return this.users;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="prototype_fk")
    public MPrototype getPrototype() {
        return this.prototype;
    }

    public void setPrototype(MPrototype prototype) {
        this.prototype = prototype;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_fk")
    public MUser getUser() {
        return this.user;
    }

    public void setUser(MUser user) {
        this.user = user;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_fk")
    public MComment getParent() {
        return this.parent;
    }

    public void setParent(MComment parent) {
        this.parent = parent;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="rootparent_fk")
    public MComment getRootParent() {
        return this.rootParent;
    }

    public void setRootParent(MComment rootParent) {
        this.rootParent = rootParent;
    }

    @Transient
    public Boolean getIsRead() {
        return this.isRead;
    }

    public void setIsRead(Boolean isRead) {
        this.isRead = isRead;
    }

    @Basic
    @Column(name="screenName", length=100)
    public String getCanvasURL() {
        return this.canvasURL;
    }

    public void setCanvasURL(String canvasURL) {
        this.canvasURL = canvasURL;
    }

    @Basic
    @Column(name="author", length=100)
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Basic
    @Column(name="canvasid", length=100)
    public String getCanvasID() {
        return this.canvasID;
    }

    public void setCanvasID(String canvasID) {
        this.canvasID = canvasID;
    }

    @Basic
    @Column(name="code")
    public Long getCode() {
        return this.code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    @Basic
    @Column(name="content")
    @Type(type="text")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Basic
    @Column(name="elementid", length=100)
    public String getElementID() {
        return this.elementID;
    }

    public void setElementID(String elementID) {
        this.elementID = elementID;
    }

    @Basic
    @Column(name="filename", length=256)
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Basic(fetch=FetchType.LAZY)
    @Column(name="filedata", nullable=true)
    public byte[] getFileData() {
        return this.fileData;
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }

    @Basic
    @Column(name="legend")
    public String getLegend() {
        return this.legend;
    }

    public void setLegend(String legend) {
        this.legend = legend;
    }

    @Basic
    @Column(name="scenario")
    public String getScenario() {
        return this.scenario;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    @Basic
    @Column(name="parentcode")
    public Long getParentCode() {
        return this.parentCode;
    }

    public void setParentCode(Long parentCode) {
        this.parentCode = parentCode;
    }

    @Override
    public void deletePersistent() {
        super.deletePersistent();
        HibernateDAOFactory.getMCommentDAO().makeTransient((Object)this);
    }

    public MComment clone() throws CloneNotSupportedException {
        return new MComment(this.prototype, this.user, this.author, null, null, true, this.canvasURL, this.canvasID, this.code, this.content, this.elementID, this.fileName, null, this.legend, this.parentCode, null);
    }
}

