/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.prototype;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.Utils;
import com.justinmind.server.model.project.MEvent;
import com.justinmind.server.model.project.MProject;
import com.justinmind.server.model.prototype.MComment;
import com.justinmind.server.model.prototype.MReview;
import com.justinmind.server.model.prototype.MTest;
import com.justinmind.server.model.server.MFileServer;
import com.justinmind.server.model.teamwork.AbstractMPrototype;
import com.justinmind.server.model.user.MAccount;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;

@Entity
@Table(name="prototype")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class MPrototype
extends AbstractMPrototype {
    private static final long serialVersionUID = 4215301394566670518L;
    public static final String NAME_PREFIX = "prototype_";
    public static final String VP_ZIP_ROOT = "prototype";
    public static final String VP_EXTENSION = ".vp";
    public static final String VP_COMMENTS_DIR = "comments/";
    public static final String VP_ATTACHMENTS_DIR = "comments/attachments/";
    public static final String VP_COMMENTS_EXTENSION = ".vpc";
    public static final String XML_COMMENTS_FILENAME = "annotations.xml";
    public static final String VP_IMAGE_DIR = "images/";
    public static final String VP_EXTERNAL_DIR = "external/";
    public static final byte[] keyBytes = new byte[]{72, -128, 108, -108, 35, -92, 32, -67, 117, -18, 100, -48, 45, 59, 92, 34};
    public static final byte[] ivBytes = new byte[]{52, -125, -81, -1, -11, 124, 1, 80, 98, -60, -73, 22, -18, -93, -119, 51};
    private static final byte[] salt;
    private MAccount account;
    private MProject project;
    private Set<MEvent> events = new HashSet<MEvent>();
    private MReview reviewPublication;
    private MTest testPublication;
    private List<MComment> comments = new ArrayList<MComment>();
    private MFileServer fileserver;
    private String password;

    static {
        byte[] byArray = new byte[20];
        byArray[0] = 50;
        byArray[1] = -123;
        byArray[2] = -65;
        byArray[3] = -31;
        byArray[4] = 103;
        byArray[5] = -40;
        byArray[6] = 47;
        byArray[7] = 60;
        byArray[8] = -63;
        byArray[9] = -77;
        byArray[10] = 27;
        byArray[11] = -22;
        byArray[12] = -93;
        byArray[13] = -119;
        byArray[14] = 51;
        byArray[16] = 52;
        byArray[17] = -120;
        byArray[18] = -61;
        byArray[19] = -31;
        salt = byArray;
    }

    public MPrototype() {
    }

    public MPrototype(MProject project) {
        this.project = project;
        project.getPrototypes().add(this);
    }

    @Override
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="project_fk")
    public MProject getProject() {
        return this.project;
    }

    public void setProject(MProject project) {
        this.project = project;
    }

    @OneToMany(mappedBy="prototype", fetch=FetchType.LAZY)
    @OptimisticLock(excluded=true)
    public Set<MEvent> getEvents() {
        return this.events;
    }

    public void setEvents(Set<MEvent> events) {
        this.events = events;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="review_id")
    public MReview getReviewPublication() {
        return this.reviewPublication;
    }

    public void setReviewPublication(MReview publication) {
        this.reviewPublication = publication;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="test_id")
    public MTest getTestPublication() {
        return this.testPublication;
    }

    public void setTestPublication(MTest testPublication) {
        this.testPublication = testPublication;
    }

    @OneToMany(mappedBy="prototype")
    @OptimisticLock(excluded=true)
    public List<MComment> getComments() {
        return this.comments;
    }

    public void setComments(List<MComment> comments) {
        this.comments = comments;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="account_fk")
    public MAccount getAccount() {
        return this.account;
    }

    public void setAccount(MAccount account) {
        this.account = account;
    }

    @Transient
    public String getVersionName() {
        return NAME_PREFIX + this.getId();
    }

    @Transient
    public static Long getIdFromVersionName(String versionName) {
        if (!versionName.startsWith(NAME_PREFIX)) {
            return null;
        }
        try {
            return Long.parseLong(versionName.substring(NAME_PREFIX.length()));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public void setFileserver(MFileServer fileserver) {
        this.fileserver = fileserver;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fileserver_fk")
    public MFileServer getFileserver() {
        return this.fileserver;
    }

    @Override
    public void deletePersistent() {
        super.deletePersistent();
        this.getProject().getPrototypes().remove(this);
        if (this.reviewPublication != null) {
            this.reviewPublication.deletePersistent();
            this.reviewPublication = null;
        }
        if (this.testPublication != null) {
            this.testPublication.deletePersistent();
            this.testPublication = null;
        }
        HibernateDAOFactory.getMPermissionDAO().deleteAllPrototypePermissions((AbstractMPrototype)this);
        for (MComment c : this.comments) {
            c.deletePersistent();
        }
        ArrayList<MEvent> toRemove = new ArrayList<MEvent>();
        toRemove.addAll(this.events);
        for (MEvent e : toRemove) {
            e.deletePersistent();
        }
        HibernateDAOFactory.getMPrototypeDAO().makeTransient((Object)this);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Basic
    @Column(name="password", length=256)
    public String getPassword() {
        return this.password;
    }

    public void changePassword(String textclearPassword) {
        if (textclearPassword == null || textclearPassword.trim().isEmpty()) {
            this.setPassword(null);
        }
        this.setPassword(MPrototype.encrypt(textclearPassword));
    }

    public boolean checkPassword(String textclearPassword) {
        return MPrototype.encrypt(textclearPassword).equals(this.getPassword());
    }

    public static String encrypt(String textclearPassword) {
        try {
            byte[] input = textclearPassword.getBytes();
            SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)key, ivSpec);
            byte[] encrypted = new byte[cipher.getOutputSize(input.length)];
            int enc_len = cipher.update(input, 0, input.length, encrypted, 0);
            enc_len += cipher.doFinal(encrypted, enc_len);
            return Utils.encode64(encrypted);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Transient
    public boolean isPasswordProtected() {
        return this.getPassword() != null && !this.getPassword().isEmpty();
    }

    public boolean checkPasswordSHA1Base64Encoded(String value) {
        return value.equals(MPrototype.getPasswordSHA1Base64Encoded(this.getPassword()));
    }

    @Transient
    public static String getPasswordSHA1Base64Encoded(String passwordParam) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec keyspec = new PBEKeySpec(passwordParam.toCharArray(), salt, 5, 160);
            SecretKey key = factory.generateSecret(keyspec);
            return Utils.encode64(key.getEncoded());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Transient
    public String getDecodedPassword() {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] encryptedBytes = Utils.decode64(this.getPassword());
            cipher.init(2, (Key)key, ivSpec);
            byte[] decrypted = new byte[cipher.getOutputSize(encryptedBytes.length)];
            int dec_len = cipher.update(encryptedBytes, 0, encryptedBytes.length, decrypted, 0);
            dec_len += cipher.doFinal(decrypted, dec_len);
            return new String(decrypted, 0, dec_len);
        }
        catch (Exception e) {
            return null;
        }
    }
}

