/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.prototype;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.MModel;
import com.justinmind.server.model.prototype.MPrototype;
import com.justinmind.server.model.prototype.PublicationStatus;
import com.justinmind.server.model.server.MApplicationServer;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="reviewpublication")
public class MReview
extends MModel
implements Serializable {
    private static final long serialVersionUID = -5418063180486477988L;
    protected static final String NAME_PREFIX = "prototype_";
    protected MApplicationServer applicationServer;
    protected MPrototype prototype;
    protected Long diskSize;
    protected PublicationStatus status;

    public MReview() {
    }

    public MReview(MApplicationServer applicationServer, MPrototype prototype) {
        this.prototype = prototype;
        this.applicationServer = applicationServer;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="applicationserver_fk")
    public MApplicationServer getApplicationServer() {
        return this.applicationServer;
    }

    public void setApplicationServer(MApplicationServer applicationServer) {
        this.applicationServer = applicationServer;
    }

    @Transient
    public String getVersionName() {
        return NAME_PREFIX + this.getId();
    }

    @OneToOne(mappedBy="reviewPublication")
    public MPrototype getPrototype() {
        return this.prototype;
    }

    public void setPrototype(MPrototype prototype) {
        this.prototype = prototype;
    }

    @Basic
    @Column(name="disksize")
    public Long getDiskSize() {
        return this.diskSize;
    }

    public void setDiskSize(Long diskSize) {
        this.diskSize = diskSize;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="status", nullable=false)
    public PublicationStatus getStatus() {
        return this.status;
    }

    public void setStatus(PublicationStatus status) {
        this.status = status;
    }

    @Override
    public void deletePersistent() {
        super.deletePersistent();
        HibernateDAOFactory.getMReviewDAO().makeTransient((Object)this);
    }
}

