/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.prototype;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.MModel;
import com.justinmind.server.model.prototype.MPrototype;
import com.justinmind.server.model.prototype.PublicationStatus;
import com.justinmind.server.model.prototype.TestToolType;
import com.justinmind.server.model.server.MApplicationServer;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="testpublication")
public class MTest
extends MModel
implements Serializable {
    private static final long serialVersionUID = -3919932112247112955L;
    private static final String NAME_PREFIX = "test_";
    private TestToolType type;
    private String userTestingTestType;
    protected MPrototype prototype;
    protected Long diskSize;
    protected PublicationStatus status;
    protected String script;
    protected String script2;
    protected MApplicationServer applicationServer;

    public MTest() {
    }

    public MTest(MApplicationServer applicationServer, MPrototype prototype) {
        this.prototype = prototype;
        this.applicationServer = applicationServer;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="applicationserver_fk")
    public MApplicationServer getApplicationServer() {
        return this.applicationServer;
    }

    public void setApplicationServer(MApplicationServer applicationServer) {
        this.applicationServer = applicationServer;
    }

    @Transient
    public String getVersionName() {
        return NAME_PREFIX + this.getId();
    }

    public void setType(TestToolType type) {
        this.type = type;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false)
    public TestToolType getType() {
        return this.type;
    }

    @OneToOne(mappedBy="testPublication")
    public MPrototype getPrototype() {
        return this.prototype;
    }

    public void setPrototype(MPrototype prototype) {
        this.prototype = prototype;
    }

    @Basic
    @Column(name="disksize")
    public Long getDiskSize() {
        return this.diskSize;
    }

    public void setDiskSize(Long diskSize) {
        this.diskSize = diskSize;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="status", nullable=false)
    public PublicationStatus getStatus() {
        return this.status;
    }

    public void setStatus(PublicationStatus status) {
        this.status = status;
    }

    @Override
    public void deletePersistent() {
        super.deletePersistent();
        HibernateDAOFactory.getMTestDAO().makeTransient((Object)this);
    }

    @Basic
    @Column(name="script", length=4000)
    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Basic
    @Column(name="script2", length=4000)
    public String getScript2() {
        return this.script2;
    }

    public void setScript2(String script2) {
        this.script2 = script2;
    }

    @Basic
    @Column(name="usertesting_test_type", length=20)
    public String getUserTestingTestType() {
        return this.userTestingTestType;
    }

    public void setUserTestingTestType(String userTestingTestType) {
        this.userTestingTestType = userTestingTestType;
    }
}

