/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.server;

import com.justinmind.server.model.prototype.MPublication;
import com.justinmind.server.model.prototype.MReview;
import com.justinmind.server.model.prototype.MTest;
import com.justinmind.server.model.server.MServer;
import com.justinmind.server.util.SimpleAuthenticator;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.OptimisticLock;

@Entity
@Table(name="applicationserver")
public class MApplicationServer
extends MServer
implements Serializable {
    private static final long serialVersionUID = -6531190230073099979L;
    private Set<MReview> publishedToReview = new HashSet<MReview>();
    private Set<MTest> publishedToTest = new HashSet<MTest>();

    public MApplicationServer(String uriString) throws URISyntaxException {
        super(uriString);
    }

    public MApplicationServer(String uriString, String user, String password) throws URISyntaxException {
        super(uriString, user, password);
    }

    @OneToMany(mappedBy="applicationServer")
    @OptimisticLock(excluded=true)
    public Set<MReview> getPublishedToReview() {
        return this.publishedToReview;
    }

    public void setPublishedToReview(Set<MReview> publishedToReview) {
        this.publishedToReview = publishedToReview;
    }

    @OneToMany(mappedBy="applicationServer")
    @OptimisticLock(excluded=true)
    public Set<MTest> getPublishedToTest() {
        return this.publishedToTest;
    }

    public void setPublishedToTest(Set<MTest> publishedToTest) {
        this.publishedToTest = publishedToTest;
    }

    @Transient
    public int getLoad() {
        return this.publishedToReview.size() + this.publishedToTest.size();
    }

    @Override
    public boolean canDelete() {
        for (MReview mReview : this.publishedToReview) {
            if (mReview.isEntityDeleted()) continue;
            return false;
        }
        for (MTest mTest : this.publishedToTest) {
            if (mTest.isEntityDeleted()) continue;
            return false;
        }
        return true;
    }

    public void addPublication(MReview publication) {
        this.publishedToReview.add(publication);
    }

    public void removePublication(MPublication publication) {
        this.publishedToReview.remove(publication);
    }

    public void addTest(MTest test) {
        this.publishedToTest.add(test);
    }

    public void removeTest(MTest test) {
        this.publishedToTest.remove(test);
    }

    public boolean isHere(MPublication publication) {
        return this.publishedToReview.contains(publication);
    }

    public boolean isHere(MTest test) {
        return this.publishedToTest.contains(test);
    }

    @Transient
    public String getURLOfPublication(MPublication publication) {
        return this.serverURI + publication.getVersionName();
    }

    @Transient
    public String getURLOfTest(MTest test) {
        return this.serverURI + test.getVersionName();
    }

    @Override
    @Transient
    public boolean isReady() {
        HttpURLConnection con;
        block8: {
            block7: {
                try {
                    con = (HttpURLConnection)this.serverURI.toURL().openConnection();
                    con.connect();
                    if (con.getResponseCode() == 200) break block7;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            con.disconnect();
            URL url = new URI(String.valueOf(this.serverURI.toString()) + "/manager/html").toURL();
            Authenticator.setDefault((Authenticator)new SimpleAuthenticator(this.username, this.decryptPassword()));
            con = (HttpURLConnection)url.openConnection();
            con.connect();
            try {
                con.getInputStream();
                byte[] bytes = new byte[5000];
                con.getInputStream().read(bytes);
            }
            catch (ProtocolException e) {
                return false;
            }
            if (con.getResponseCode() == 200) break block8;
            return false;
        }
        con.disconnect();
        return true;
    }

    public MApplicationServer() {
    }
}

