/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.server;

import com.justinmind.fileserveraccess.FileServerAccessInterface;
import com.justinmind.server.model.server.MServer;
import com.justinmind.server.model.user.MAccount;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.OptimisticLock;

@Entity
@Table(name="fileserver")
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class MFileServer
extends MServer
implements Serializable {
    private static final long serialVersionUID = -8689506753675233623L;
    private Set<MAccount> accounts = new HashSet<MAccount>();

    public MFileServer() {
    }

    public MFileServer(String uriString) throws URISyntaxException {
        super(uriString);
    }

    public MFileServer(String uristring, String username, String password) throws URISyntaxException {
        super(uristring, username, password);
    }

    @OneToMany(mappedBy="fileserver")
    @OptimisticLock(excluded=true)
    public Set<MAccount> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(Set<MAccount> accounts) {
        this.accounts = accounts;
    }

    public abstract FileServerAccessInterface giveFileServerAccessInterface();

    @Override
    public boolean canDelete() {
        for (MAccount account : this.accounts) {
            if (account.isEntityDeleted()) continue;
            return false;
        }
        return true;
    }
}

