/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.server;

import com.justinmind.server.model.MModel;
import com.justinmind.util.crypto.tripledes.DoEncrypt;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="server")
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class MServer
extends MModel
implements Serializable {
    private static final long serialVersionUID = 8961298572104707444L;
    protected URI serverURI;
    protected String username;
    protected String password;

    public MServer() {
    }

    public MServer(String uriString) throws URISyntaxException {
        this.init(new URI(uriString), null, null);
    }

    public MServer(URI uri) throws URISyntaxException {
        this.init(uri, null, null);
    }

    public MServer(URI uri, String username, String password) throws URISyntaxException {
        this.init(uri, username, password);
    }

    public MServer(String uriString, String username, String password) throws URISyntaxException {
        this.init(new URI(uriString), username, password);
    }

    protected void init(URI uri, String usernamePar, String passwordPar) throws URISyntaxException {
        this.serverURI = uri;
        this.username = usernamePar;
        DoEncrypt des = new DoEncrypt();
        if (passwordPar != null) {
            this.password = des.encrypt(passwordPar);
        }
    }

    @Transient
    public URI getServerURIObject() {
        return this.serverURI;
    }

    @Basic
    @Column(name="serverURI", length=255, nullable=true)
    public String getServerURI() {
        return this.serverURI.toString();
    }

    public void setServerURI(URI serverURI) {
        this.serverURI = serverURI;
    }

    public void setServerURI(String serverURIstring) throws URISyntaxException {
        this.serverURI = new URI(serverURIstring);
    }

    @Basic
    @Column(name="username", length=100, nullable=true)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Basic
    @Column(name="password", length=255, nullable=true)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String decryptPassword() {
        DoEncrypt encrypter = new DoEncrypt();
        return encrypter.decrypt(this.password.toString());
    }

    @Transient
    public boolean isReady() {
        return true;
    }
}

