/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.teamwork;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.teamwork.AbstractMProject;
import com.justinmind.server.model.teamwork.MTWPrototype;
import com.justinmind.server.model.user.MAccount;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;

@Entity
@Table(name="twproject")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class MTWProject
extends AbstractMProject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private MAccount account;
    private Set<MTWPrototype> twPrototypes = new HashSet<MTWPrototype>();

    public MTWProject() {
    }

    public MTWProject(MAccount account) {
        this.setAccount(account);
    }

    public void setAccount(MAccount account) {
        this.account = account;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="account_fk")
    public MAccount getAccount() {
        return this.account;
    }

    public void setTwPrototypes(Set<MTWPrototype> twPrototypes) {
        this.twPrototypes = twPrototypes;
    }

    @OneToMany(mappedBy="twProject")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    public Set<MTWPrototype> getTwPrototypes() {
        return this.twPrototypes;
    }

    @Override
    @Transient
    public boolean isTWProject() {
        return true;
    }

    @Transient
    public String getPath() {
        return String.valueOf(this.getAccount().getPath()) + this.getTeamworkFolder() + "/" + this.getId() + "/";
    }

    @Transient
    public String getTeamworkFolder() {
        return "teamwork";
    }

    @Override
    public void deletePersistent() {
        super.deletePersistent();
        ArrayList<MTWPrototype> protosToRemove = new ArrayList<MTWPrototype>();
        protosToRemove.addAll(this.twPrototypes);
        for (MTWPrototype p : protosToRemove) {
            this.account.decreaseDiskUsed(p.getDiskSize());
            p.deletePersistent();
        }
        HibernateDAOFactory.getMPermissionDAO().deleteAllProjectPermissions((AbstractMProject)this);
        this.account.removeTwProject(this);
        HibernateDAOFactory.getMTWProjectDAO().makeTransient((Object)this);
    }
}

