/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.teamwork;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.teamwork.AbstractMProject;
import com.justinmind.server.model.teamwork.AbstractMPrototype;
import com.justinmind.server.model.teamwork.MTWBlockUnit;
import com.justinmind.server.model.teamwork.MTWProject;
import com.justinmind.server.model.teamwork.MTWRevisionUpdate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;

@Entity
@Table(name="twprototype")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class MTWPrototype
extends AbstractMPrototype {
    private static final long serialVersionUID = 1L;
    private String sharedPrototypeID;
    private int currentRevision;
    private MTWProject twProject;
    private String JPVersion;
    private String lastJPVersion;
    private List<MTWRevisionUpdate> revisionUpdates = new ArrayList<MTWRevisionUpdate>();

    public MTWPrototype() {
    }

    public MTWPrototype(MTWProject project) {
        this.twProject = project;
        project.getTwPrototypes().add(this);
    }

    public void setSharedPrototypeID(String sharedPrototypeID) {
        this.sharedPrototypeID = sharedPrototypeID;
    }

    @Basic
    @Column(name="sharedprototypeid", length=256)
    public String getSharedPrototypeID() {
        return this.sharedPrototypeID;
    }

    public void setCurrentRevision(int currentRevision) {
        this.currentRevision = currentRevision;
    }

    @Basic
    @Column(name="currentrevision")
    public int getCurrentRevision() {
        return this.currentRevision;
    }

    public void setTwProject(MTWProject twProject) {
        this.twProject = twProject;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="twproject_fk")
    public MTWProject getTwProject() {
        return this.twProject;
    }

    @Override
    @Transient
    public boolean isTWPrototype() {
        return true;
    }

    @Transient
    public String getPath() {
        return String.valueOf(this.getTwProject().getPath()) + this.getId() + "/";
    }

    @Transient
    public String getRevisionsPath() {
        return String.valueOf(this.getPath()) + "/" + "revisions" + "/";
    }

    @Override
    @Transient
    public AbstractMProject getProject() {
        return this.twProject;
    }

    @OneToMany(mappedBy="twPrototype")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    public List<MTWRevisionUpdate> getRevisionUpdates() {
        return this.revisionUpdates;
    }

    public void setRevisionUpdates(List<MTWRevisionUpdate> revisionUpdates) {
        this.revisionUpdates = revisionUpdates;
    }

    @Override
    public void deletePersistent() {
        super.deletePersistent();
        this.twProject.getTwPrototypes().remove(this);
        HibernateDAOFactory.getMPermissionDAO().deleteAllPrototypePermissions((AbstractMPrototype)this);
        for (MTWRevisionUpdate update : this.revisionUpdates) {
            update.deletePersistent();
        }
        ArrayList blocks = new ArrayList();
        blocks.addAll(HibernateDAOFactory.getMTWBlockUnitDAO().getPrototypeBlocks(this));
        for (MTWBlockUnit twBlock : blocks) {
            twBlock.deletePersistent();
        }
        HibernateDAOFactory.getMTWPrototypeDAO().makeTransient((Object)this);
    }

    @Basic
    @Column(name="JPVersion")
    public String getJPVersion() {
        return this.JPVersion;
    }

    public void setJPVersion(String jPVersion) {
        this.JPVersion = jPVersion;
    }

    @Basic
    @Column(name="lastJPVersion")
    public String getLastJPVersion() {
        return this.lastJPVersion;
    }

    public void setLastJPVersion(String jPVersion) {
        this.lastJPVersion = jPVersion;
    }
}

