/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.teamwork;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.MModel;
import com.justinmind.server.model.teamwork.MTWFileChange;
import com.justinmind.server.model.teamwork.MTWPrototype;
import com.justinmind.server.model.user.MUser;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Type;

@Entity
@Table(name="twrevisionupdate")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class MTWRevisionUpdate
extends MModel {
    private static final long serialVersionUID = 1L;
    private int revision;
    private String comments;
    private MUser committer;
    private List<MTWFileChange> fileChanges = new ArrayList<MTWFileChange>();
    private MTWPrototype twPrototype;
    private String JPVersion;

    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Basic
    @Column(name="revision")
    public int getRevision() {
        return this.revision;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Basic
    @Column(name="comments")
    @Type(type="text")
    public String getComments() {
        return this.comments;
    }

    public void setCommitter(MUser commiter) {
        this.committer = commiter;
    }

    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    @JoinColumn(name="committer")
    public MUser getCommitter() {
        return this.committer;
    }

    public void setFileChanges(List<MTWFileChange> fileChanges) {
        this.fileChanges = fileChanges;
    }

    @OneToMany(mappedBy="revisionUpdate")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    public List<MTWFileChange> getFileChanges() {
        return this.fileChanges;
    }

    public void setTwPrototype(MTWPrototype twPrototype) {
        this.twPrototype = twPrototype;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="twproject_fk")
    public MTWPrototype getTwPrototype() {
        return this.twPrototype;
    }

    @Override
    public void deletePersistent() {
        super.deletePersistent();
        for (MTWFileChange fc : this.getFileChanges()) {
            fc.deletePersistent();
        }
        HibernateDAOFactory.getMTWRevisionUpdateDAO().makeTransient((Object)this);
    }

    @Basic
    @Column(name="JPVersion")
    public String getJPVersion() {
        return this.JPVersion;
    }

    public void setJPVersion(String jPVersion) {
        this.JPVersion = jPVersion;
    }
}

