/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.user;

import com.justinmind.server.model.MModel;
import com.justinmind.server.model.payment.MPlan;
import com.justinmind.server.model.payment.PaymentService;
import com.justinmind.server.model.payment.PaymentStatus;
import com.justinmind.server.model.payment.PlanType;
import com.justinmind.server.model.project.MProject;
import com.justinmind.server.model.server.MFileServer;
import com.justinmind.server.model.teamwork.MTWProject;
import com.justinmind.server.model.user.AccountType;
import com.justinmind.server.model.user.MGroup;
import com.justinmind.server.model.user.MPeriod;
import com.justinmind.server.model.user.MPermission;
import com.justinmind.server.model.user.MUser;
import com.justinmind.server.model.widgets.MWidgetLibrary;
import com.justinmind.server.web.action.util.SessionUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;

@Entity
@Table(name="account")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class MAccount
extends MModel
implements Serializable {
    private static Logger log = Logger.getLogger(MAccount.class);
    private static final long serialVersionUID = -8967859264493504032L;
    private static final String mainFSOnDemandFolder = "FSRepositories";
    private static final String repoPrefix = "repo";
    private String name;
    private Set<MProject> projects = new HashSet<MProject>();
    private Set<MTWProject> twProjects = new HashSet<MTWProject>();
    private MPeriod period;
    private MFileServer fileserver;
    private MUser owner;
    private Set<MGroup> groups;
    private Set<MWidgetLibrary> libraries;
    private Long diskUsed;
    private Long maxDiskUsed;
    private AccountType type;
    private String prototyperKey;
    private Long prototyperCopies;
    private Long prototyperCopiesActive;
    private Date endOfSupport;
    private String plimusAccountId;
    private String cancellationReason;
    private String plimusSubscriptionId;
    private Date nextChargeDate;
    private BigDecimal nextChargeAmount;
    private String creditCardLastFourDigits;
    private String creditCardExpDate;
    private Long lastWarningEmailSent;
    private PaymentStatus paymentStatus;
    private byte[] customLogo;
    private String customColor;
    private String creationResultCode;
    private String creationActivationURL;
    private PaymentService paymentService;
    private String oldPlimusAccountId;
    private String oldPlimusSubscriptionId;

    public MAccount() {
    }

    public MAccount(MFileServer fileserver) {
        this.fileserver = fileserver;
        this.diskUsed = 0L;
        this.lastWarningEmailSent = 0L;
    }

    @OneToMany(mappedBy="account")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    public Set<MProject> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<MProject> projects) {
        this.projects = projects;
    }

    public void addProject(MProject project) {
        this.projects.add(project);
    }

    public void removeProject(MProject project) {
        this.projects.remove(project);
    }

    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="period_id")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public MPeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(MPeriod period) {
        this.period = period;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fileserver_fk")
    public MFileServer getFileserver() {
        return this.fileserver;
    }

    public void setFileserver(MFileServer fileserver) {
        this.fileserver = fileserver;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_fk")
    public MUser getOwner() {
        return this.owner;
    }

    public void setOwner(MUser user) {
        this.owner = user;
    }

    @Transient
    public boolean isAdmin(MUser user) {
        return MPermission.isAdmin(user, this);
    }

    @Transient
    public void makeAdmin(MUser user) {
        MPermission.makeAdmin(user, this);
    }

    @OneToMany(mappedBy="account")
    @OptimisticLock(excluded=true)
    public Set<MGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<MGroup> groups) {
        this.groups = groups;
    }

    public void addGroup(MGroup group) {
        this.groups.add(group);
    }

    public void removeGroup(MGroup group) {
        this.groups.remove(group);
    }

    @OneToMany(mappedBy="account")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    public Set<MWidgetLibrary> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(Set<MWidgetLibrary> libraries) {
        this.libraries = libraries;
    }

    public void addLibrary(MWidgetLibrary library) {
        this.libraries.add(library);
    }

    public void removeLibrary(MWidgetLibrary library) {
        this.libraries.remove(library);
    }

    @Transient
    public String getPath() {
        return String.valueOf(this.getPathWithoutSeparator()) + "/";
    }

    @Transient
    public String getPathWithoutSeparator() {
        return "/FSRepositories/" + this.getFolder();
    }

    @Transient
    private String getFolder() {
        return repoPrefix + this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Basic
    @Column(name="name", length=100, nullable=true)
    public String getName() {
        return this.name;
    }

    @Transient
    public String getVisibleName() {
        if (this.hasBranding() && this.getName() != null && !this.getName().equals("")) {
            return this.name;
        }
        return String.valueOf(this.owner.getCompleteName()) + "'s account";
    }

    @Basic
    @Column(name="diskused")
    public Long getDiskUsed() {
        return this.diskUsed == null ? 0L : this.diskUsed;
    }

    public void setDiskUsed(Long diskUsed) {
        this.diskUsed = diskUsed;
    }

    public void setPlimusAccountId(String plimusAccountId) {
        this.plimusAccountId = plimusAccountId;
    }

    @Basic
    @Column(name="plimusaccountid")
    public String getPlimusAccountId() {
        return this.plimusAccountId;
    }

    @Transient
    public boolean wouldExceedSpaceLimit(Long spaceToAdd) {
        return this.getDiskUsed() + spaceToAdd > this.getMaxDiskUsed();
    }

    @Transient
    public int cannotBeDowngraded(MPlan desiredPlan) {
        int result = 0;
        if (desiredPlan.getMaxSize() < this.getDiskUsed()) {
            result += 2;
        }
        return result;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    @Basic
    @Column(name="cancellationreason", length=4000)
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    @Basic
    @Column(name="plimussubscriptionid")
    public String getPlimusSubscriptionId() {
        return this.plimusSubscriptionId;
    }

    public void setPlimusSubscriptionId(String plimusSubscriptionId) {
        this.plimusSubscriptionId = plimusSubscriptionId;
    }

    @Transient
    public Boolean isCancelledOrVeryExpired() {
        if (!this.isCancelled().booleanValue() && !SessionUtil.isAccountPastEraseEverythingExpiration((MAccount)this)) {
            return false;
        }
        return true;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="nextchargedate")
    public Date getNextChargeDate() {
        return this.nextChargeDate;
    }

    public void setNextChargeDate(Date nextChargeDate) {
        this.nextChargeDate = nextChargeDate;
    }

    @Basic
    @Column(name="nextchargeamount")
    public BigDecimal getNextChargeAmount() {
        return this.nextChargeAmount;
    }

    public void setNextChargeAmount(BigDecimal nextChargeAmount) {
        this.nextChargeAmount = nextChargeAmount;
    }

    @Basic
    @Column(name="creditcardlastfourdigits")
    public String getCreditCardLastFourDigits() {
        return this.creditCardLastFourDigits;
    }

    public void setCreditCardLastFourDigits(String creditCardLastFourDigits) {
        this.creditCardLastFourDigits = creditCardLastFourDigits;
    }

    public void setCreditCardExpDate(String creditCardExpDate) {
        this.creditCardExpDate = creditCardExpDate;
    }

    @Basic
    @Column(name="creditcardexpdate")
    public String getCreditCardExpDate() {
        return this.creditCardExpDate;
    }

    @Transient
    public void decreaseDiskUsed(long i) {
        this.setDiskUsed(this.getDiskUsed() - i);
        if (this.getDiskUsed() < 0L) {
            this.setDiskUsed(0L);
            log.error((Object)"# of disk used is negative!!! This should not happen.");
        }
    }

    @Transient
    public void increaseDiskUsed(long i) {
        this.setDiskUsed(this.getDiskUsed() + i);
    }

    @Basic
    @Column(name="maxdiskused")
    public Long getMaxDiskUsed() {
        return this.maxDiskUsed == null ? Long.MAX_VALUE : this.maxDiskUsed;
    }

    public void setMaxDiskUsed(Long maxDiskUsed) {
        this.maxDiskUsed = maxDiskUsed;
    }

    public void setLastWarningEmailSent(Long lastWarningEmailSent) {
        this.lastWarningEmailSent = lastWarningEmailSent;
    }

    @Basic
    @Column(name="lastwarningemailsent")
    public Long getLastWarningEmailSent() {
        return this.lastWarningEmailSent == null ? 0L : this.lastWarningEmailSent;
    }

    @Transient
    public void applyNewPlan(MPlan plan) {
        this.applyNewPlan(plan, 1);
    }

    @Transient
    public void applyNewPlan(MPlan plan, int prototyperCopiesParam) {
        this.getPeriod().setPlan(plan);
        if (plan.getType().equals((Object)PlanType.LICENSES)) {
            this.setMaxDiskUsed(plan.getMaxSize() * (long)prototyperCopiesParam);
            this.setPrototyperCopies(Long.valueOf(prototyperCopiesParam));
        } else {
            this.setMaxDiskUsed(plan.getMaxSize());
            this.setPrototyperCopies(plan.getNumberOfCopies());
        }
    }

    public void setPaymentStatus(PaymentStatus paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    @Basic
    @Column(name="paymentstatus")
    public PaymentStatus getPaymentStatus() {
        return this.paymentStatus;
    }

    @Basic(fetch=FetchType.LAZY)
    @Column(name="customlogo", nullable=true)
    public byte[] getCustomLogo() {
        return this.customLogo;
    }

    public void setCustomLogo(byte[] customLogo) {
        this.customLogo = customLogo;
    }

    @Transient
    public boolean hasBranding() {
        try {
            return this.getPeriod().getPlan() != null ? this.getPeriod().getPlan().getType().hasBranding() : false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Transient
    public boolean hasCustomLogo() {
        return this.hasBranding() && this.getCustomLogo() != null;
    }

    public void setCustomColor(String customColor) {
        this.customColor = customColor;
    }

    @Basic
    @Column(name="customcolor", nullable=true)
    public String getCustomColor() {
        return this.customColor;
    }

    @Transient
    public String getBackgroundColor() {
        if (this.hasBranding() && this.getCustomColor() != null) {
            return this.getCustomColor();
        }
        return "#21C0C0";
    }

    @Transient
    public String getTextColor() {
        int blue;
        int green;
        String customBackground = this.getBackgroundColor();
        int red = Integer.valueOf(customBackground.substring(1, 3), 16);
        int luminance = (int)((double)red * 0.299 + (double)(green = Integer.valueOf(customBackground.substring(3, 5), 16).intValue()) * 0.587 + (double)(blue = Integer.valueOf(customBackground.substring(5, 7), 16).intValue()) * 0.114);
        return luminance < 186 ? "#ffffff" : "#000000";
    }

    public void setType(AccountType type) {
        this.type = type;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="type")
    public AccountType getType() {
        if (this.type == null) {
            this.type = AccountType.UNLIMITED;
        }
        return this.type;
    }

    @Basic
    @Column(name="prototyperkey")
    public String getPrototyperKey() {
        return this.prototyperKey;
    }

    public void setPrototyperKey(String prototyperKey) {
        this.prototyperKey = prototyperKey;
    }

    @Basic
    @Column(name="prototypercopies")
    public Long getPrototyperCopies() {
        return this.prototyperCopies;
    }

    public void setPrototyperCopies(Long prototyperCopies) {
        this.prototyperCopies = prototyperCopies;
    }

    @Basic
    @Column(name="prototypercopiesactive")
    public Long getPrototyperCopiesActive() {
        return this.prototyperCopiesActive;
    }

    public void setPrototyperCopiesActive(Long prototyperCopiesActive) {
        this.prototyperCopiesActive = prototyperCopiesActive;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="endofsupport", nullable=true)
    public Date getEndOfSupport() {
        return this.endOfSupport;
    }

    public void setEndOfSupport(Date endOfSupport) {
        this.endOfSupport = endOfSupport;
    }

    @Transient
    public Boolean isFree() {
        if (this.getType() != null && !this.getType().equals((Object)AccountType.FREE)) {
            return false;
        }
        return true;
    }

    @Transient
    public Boolean isGift() {
        if (this.getType() != null && this.getType().equals((Object)AccountType.GIFT)) {
            return true;
        }
        return false;
    }

    @Transient
    public Boolean isCancelled() {
        if (this.getType() != null && this.getType().equals((Object)AccountType.CANCELLED)) {
            return true;
        }
        return false;
    }

    @Transient
    public Boolean isSubscription() {
        if (!(this.getType() != null && this.getType().equals((Object)AccountType.SUBSCRIPTION) || this.getPeriod().getPlan() != null && this.getPeriod().getPlan().getType().isSubscription())) {
            return false;
        }
        return true;
    }

    public void setTwProjects(Set<MTWProject> twProjects) {
        this.twProjects = twProjects;
    }

    @OneToMany(mappedBy="account")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    public Set<MTWProject> getTwProjects() {
        return this.twProjects;
    }

    public void addTwProject(MTWProject twProject) {
        this.twProjects.add(twProject);
    }

    public void removeTwProject(MTWProject twProject) {
        this.twProjects.remove(twProject);
    }

    @Basic
    @Column(name="creationresultcode")
    public String getCreationResultCode() {
        return this.creationResultCode;
    }

    public void setCreationResultCode(String creationResultCode) {
        this.creationResultCode = creationResultCode;
    }

    @Basic
    @Column(name="creationactivationurl")
    public String getCreationActivationURL() {
        return this.creationActivationURL;
    }

    public void setCreationActivationURL(String creationActivationURL) {
        this.creationActivationURL = creationActivationURL;
    }

    @Override
    public String toString() {
        return "MAccount [name=" + this.name + ", id=" + this.id + "]";
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="paymentservice")
    public PaymentService getPaymentService() {
        return this.paymentService;
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public String getOldPlimusAccountId() {
        return this.oldPlimusAccountId;
    }

    public void setOldPlimusAccountId(String oldPlimusAccountId) {
        this.oldPlimusAccountId = oldPlimusAccountId;
    }

    public String getOldPlimusSubscriptionId() {
        return this.oldPlimusSubscriptionId;
    }

    public void setOldPlimusSubscriptionId(String oldPlimusSubscriptionId) {
        this.oldPlimusSubscriptionId = oldPlimusSubscriptionId;
    }
}

