/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.user;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.MModel;
import com.justinmind.server.model.teamwork.AbstractMProject;
import com.justinmind.server.model.teamwork.AbstractMPrototype;
import com.justinmind.server.model.user.MAccount;
import com.justinmind.server.model.user.MUserBase;
import java.io.Serializable;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@Table(name="permission")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class MPermission
extends MModel
implements Serializable {
    private static final long serialVersionUID = -3497058415150544623L;
    private MAccount account;
    private AbstractMProject project;
    private AbstractMPrototype prototype;
    private MUserBase userbase;
    private Boolean superuser;
    private Boolean admin;

    public MPermission() {
    }

    public MPermission(MUserBase userbase, MAccount account) {
        this.account = account;
        this.userbase = userbase;
    }

    public MPermission(MUserBase userbase, AbstractMProject project) {
        this.project = project;
        this.account = project.getAccount();
        this.userbase = userbase;
    }

    public MPermission(MUserBase userbase, AbstractMPrototype prototype) {
        this.prototype = prototype;
        this.project = prototype.getProject();
        this.account = this.project.getAccount();
        this.userbase = userbase;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="account_fk")
    public MAccount getAccount() {
        return this.account;
    }

    public void setAccount(MAccount account) {
        this.account = account;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="project_fk")
    public AbstractMProject getProject() {
        return this.project;
    }

    public void setProject(AbstractMProject project) {
        this.project = project;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="prototype_fk")
    public AbstractMPrototype getPrototype() {
        return this.prototype;
    }

    public void setPrototype(AbstractMPrototype prototype) {
        this.prototype = prototype;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="userbase_fk")
    public MUserBase getUserbase() {
        return this.userbase;
    }

    public void setUserbase(MUserBase userbase) {
        this.userbase = userbase;
    }

    public static void makeAdmin(MUserBase user2, MAccount mAccount) {
        Set<MPermission> perms = user2.getPermissions();
        for (MPermission perm : perms) {
            if (perm.getAccount().getId() != mAccount.getId() || perm.getProject() != null || perm.getPrototype() != null) continue;
            return;
        }
        perms.add(new MPermission(user2, mAccount));
    }

    public static boolean isAdmin(MUserBase user2, MAccount mAccount) {
        Set<MPermission> perms = user2.getPermissions();
        for (MPermission perm : perms) {
            if (perm.getAccount().getId() != mAccount.getId() || perm.getProject() != null || perm.getPrototype() != null) continue;
            return true;
        }
        return false;
    }

    @Basic
    @Column(name="superuser")
    @Type(type="boolean")
    protected Boolean isSuperuser() {
        return this.superuser == null ? false : this.superuser;
    }

    protected void setSuperuser(Boolean superuser) {
        this.superuser = superuser;
    }

    @Override
    public void deletePersistent() {
        super.deletePersistent();
        HibernateDAOFactory.getMPermissionDAO().makeTransient((Object)this);
    }

    public void setAdmin(Boolean admin) {
        this.admin = admin;
    }

    @Basic
    @Column(name="admin")
    @Type(type="boolean")
    public Boolean isAdmin() {
        return this.admin == null ? false : this.admin;
    }

    @Transient
    public boolean isEditorPermission() {
        return this.project != null && this.prototype == null && this.account != null;
    }

    @Transient
    public boolean isReviewerPermission() {
        return this.project != null && this.prototype != null && this.account != null;
    }
}

