/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.user;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.MModel;
import com.justinmind.server.model.user.MAccount;
import com.justinmind.server.model.user.MUser;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="token")
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
public class MToken
extends MModel
implements Serializable {
    private static final long serialVersionUID = -2692541308302593651L;
    private String token;
    private String action;
    private MUser user;
    private Date expireDate;
    private Long issuerAccount;
    private Long issuerUser;

    public MToken() {
    }

    public MToken(MUser user, String action, Date expireDate, MAccount issuerAccount, MUser issuerUser) {
        this.init(user, action, expireDate, issuerAccount, issuerUser);
    }

    public MToken(MUser user, String action, int expireDays, MAccount issuerAccount, MUser issuerUser) {
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, expireDays);
        this.init(user, action, currentDate.getTime(), issuerAccount, issuerUser);
    }

    private void init(MUser userPar, String actionPar, Date expireDatePar, MAccount iAccount, MUser iUser) {
        this.user = userPar;
        this.action = actionPar;
        this.expireDate = expireDatePar;
        this.issuerAccount = iAccount != null ? iAccount.getId() : null;
        this.issuerUser = iUser != null ? iUser.getId() : null;
        this.token = MToken.userFriendlyToken(6);
    }

    public static String userFriendlyToken(int length) {
        Random r = new Random();
        String characters = "BCDFGHJKLMNPQRSTVWXZ123456789";
        StringBuilder builder = new StringBuilder(6);
        int i = 0;
        while (i < length) {
            builder.append(characters.charAt(r.nextInt(characters.length())));
            ++i;
        }
        return builder.toString();
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiredate", nullable=true)
    public Date getExpiredate() {
        return this.expireDate;
    }

    public void setExpiredate(Date expireDate) {
        this.expireDate = expireDate;
    }

    @Column(name="token")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Column(name="action", nullable=true)
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_fk")
    public MUser getUser() {
        return this.user;
    }

    public void setUser(MUser user) {
        this.user = user;
    }

    @Transient
    public boolean isExpired() {
        if (this.getExpiredate() == null) {
            return false;
        }
        return this.getExpiredate().compareTo(new Date()) < 0;
    }

    @Transient
    public void expire() {
        this.expireDate = new Date(0L);
    }

    @Override
    public void deletePersistent() {
        super.deletePersistent();
        HibernateDAOFactory.getMTokenDAO().makeTransient((Object)this);
    }

    @Column(name="issueraccount", nullable=true)
    public Long getIssuerAccount() {
        return this.issuerAccount;
    }

    public void setIssuerAccount(Long issuerAccount) {
        this.issuerAccount = issuerAccount;
    }

    @Column(name="issueruser", nullable=true)
    public Long getIssuerUser() {
        return this.issuerUser;
    }

    public void setIssuerUser(Long issuerUser) {
        this.issuerUser = issuerUser;
    }
}

