/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.user;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.dao.user.MPermissionDAO;
import com.justinmind.server.model.project.MEvent;
import com.justinmind.server.model.prototype.MComment;
import com.justinmind.server.model.user.MAccount;
import com.justinmind.server.model.user.MGroup;
import com.justinmind.server.model.user.MPermission;
import com.justinmind.server.model.user.MToken;
import com.justinmind.server.model.user.MUserBase;
import com.justinmind.server.web.Constants;
import com.justinmind.util.crypto.MD5encrypter;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Type;

@Entity
@Table(name="usertable")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class MUser
extends MUserBase
implements Serializable {
    private static Logger log = Logger.getLogger(MUser.class);
    private static final long serialVersionUID = 4511650378701780866L;
    private Set<MAccount> ownedAccounts = new HashSet<MAccount>();
    private Set<MEvent> eventsAuthored = new HashSet<MEvent>();
    private Set<MComment> readComments = new HashSet<MComment>();
    private Set<MGroup> groups = new HashSet<MGroup>();
    private String username;
    private String passwordMD5;
    private String email;
    private String surname;
    private String company;
    private String howFind;
    private String phoneNumber;
    private Locale locale;
    private TimeZone timeZone;
    private MAccount lastUsed;
    private Boolean superuser;
    private Boolean active;
    private String passwordHash;
    private String passwordSalt;

    @OneToMany(mappedBy="user")
    @OptimisticLock(excluded=true)
    public Set<MEvent> getEventsAuthored() {
        return this.eventsAuthored;
    }

    public void setEventsAuthored(Set<MEvent> eventsAuthored) {
        this.eventsAuthored = eventsAuthored;
    }

    @ManyToMany(targetEntity=MComment.class, fetch=FetchType.LAZY)
    @JoinTable(name="readcomment_user", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="comment_id")})
    @OptimisticLock(excluded=true)
    public Set<MComment> getReadComments() {
        return this.readComments;
    }

    public void setReadComments(Set<MComment> readComments) {
        this.readComments = readComments;
    }

    @Basic
    @Column(name="username", length=100, nullable=true)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Basic
    @Column(name="passwordMD5", length=1024)
    public String getPasswordMD5() {
        return this.passwordMD5;
    }

    public void setPasswordMD5(String passwordMD5) {
        this.passwordMD5 = passwordMD5;
    }

    @Basic
    @Column(name="passwordhash", length=80)
    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    @Override
    @Basic
    @Column(name="email", length=200, nullable=false)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    @Basic
    @Column(name="surname", length=500, nullable=true)
    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    @Basic
    @Column(name="company")
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    @Basic
    @Column(name="howfind", length=2048)
    public String getHowFind() {
        return this.howFind;
    }

    public void setHowFind(String howFind) {
        this.howFind = howFind;
    }

    @Override
    @Basic
    @Column(name="phonenumber", length=30)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @OneToMany(mappedBy="owner")
    @OptimisticLock(excluded=true)
    public Set<MAccount> getOwnedAccounts() {
        return this.ownedAccounts;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setOwnedAccounts(Set<MAccount> accounts) {
        this.ownedAccounts = accounts;
    }

    @Basic
    @Column(name="active")
    @Type(type="boolean")
    public Boolean isActive() {
        return this.active == null ? false : this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public boolean checkPassword(String password) {
        if (this.passwordHash != null && this.passwordSalt != null) {
            if (this.passwordHash.length() > 60) {
                try {
                    byte[] salt = MUser.hexStringToByteArray(this.passwordSalt);
                    SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                    PBEKeySpec keyspec = new PBEKeySpec(password.toCharArray(), salt, 100, 256);
                    SecretKey key = factory.generateSecret(keyspec);
                    return this.passwordHash.trim().compareToIgnoreCase(MUser.byteArrayToHexString(key.getEncoded())) == 0;
                }
                catch (NoSuchAlgorithmException e) {
                    log.fatal((Object)"#### PBKDF2 ALGORITHM IS NOT SUPPORTED IN THIS SYSTEM AND WE NEED IT FOR CREATING THE PASSWORD HASHES ####", (Throwable)e);
                }
                catch (InvalidKeySpecException e) {
                    log.fatal((Object)"#### INVALID KEY SPECIFICATION WHEN CREATING A PASSWORD HASH, THIS IS VERY BAD ####", (Throwable)e);
                }
            } else {
                try {
                    BigInteger bigintSalt = new BigInteger(this.passwordSalt, 16);
                    byte[] salt = bigintSalt.toByteArray();
                    MD5encrypter md5 = MD5encrypter.getInstance();
                    byte[] passMD5 = md5.encrypt(password);
                    BigInteger bigInt = new BigInteger(passMD5);
                    SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                    PBEKeySpec keyspec = new PBEKeySpec(bigInt.toString(16).trim().toUpperCase().toCharArray(), salt, 10000, 160);
                    SecretKey key = factory.generateSecret(keyspec);
                    BigInteger bigintPassword = new BigInteger(key.getEncoded());
                    return this.passwordHash.trim().compareToIgnoreCase(bigintPassword.toString(16).trim()) == 0;
                }
                catch (NoSuchAlgorithmException e) {
                    log.fatal((Object)"#### PBKDF2 ALGORITHM IS NOT SUPPORTED IN THIS SYSTEM AND WE NEED IT FOR CREATING THE PASSWORD HASHES ####", (Throwable)e);
                }
                catch (InvalidKeySpecException e) {
                    log.fatal((Object)"#### INVALID KEY SPECIFICATION WHEN CREATING A PASSWORD HASH, THIS IS VERY BAD ####", (Throwable)e);
                }
            }
        }
        return false;
    }

    public void changePassword(String newpass) {
        try {
            SecureRandom sr = new SecureRandom();
            byte[] salt = new byte[32];
            sr.nextBytes(salt);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec keyspec = new PBEKeySpec(newpass.toCharArray(), salt, 100, 256);
            SecretKey key = factory.generateSecret(keyspec);
            this.passwordHash = MUser.byteArrayToHexString(key.getEncoded());
            this.passwordSalt = MUser.byteArrayToHexString(salt);
        }
        catch (NoSuchAlgorithmException e) {
            log.fatal((Object)"#### PBKDF2 ALGORITHM IS NOT SUPPORTED IN THIS SYSTEM AND WE NEED IT FOR CREATING THE PASSWORD HASHES ####", (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            log.fatal((Object)"#### INVALID KEY SPECIFICATION WHEN CREATING A PASSWORD HASH, THIS IS VERY BAD ####", (Throwable)e);
        }
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public static String byteArrayToHexString(byte[] array) {
        StringBuilder result = new StringBuilder();
        byte[] byArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            result.append(String.format("%02X", b));
            ++n2;
        }
        return result.toString();
    }

    public MUser(String username, String password, String email, String name, String surname, String company, String howFind, String phoneNumber) {
        this.username = username;
        this.email = email;
        this.name = name;
        this.surname = surname;
        this.company = company;
        this.howFind = howFind;
        this.phoneNumber = phoneNumber;
        if (password != null) {
            this.changePassword(password);
        }
        this.locale = Constants.DEFAULT_LOCALE;
    }

    protected MUser(String username) {
        this.username = username;
    }

    protected MUser() {
    }

    @Override
    @Transient
    public String getCompleteName() {
        return MUser.makeCompleteName(this.name, this.surname, this.username, this.email);
    }

    public static String makeCompleteName(String name, String surname, String username, String email) {
        if (name != null) {
            if (surname != null && !surname.trim().equals("")) {
                return String.valueOf(name.trim()) + " " + surname.trim();
            }
            return name.trim();
        }
        if (surname != null) {
            return surname.trim();
        }
        if (username != null) {
            return username.trim();
        }
        return email;
    }

    @ManyToMany(targetEntity=MGroup.class, fetch=FetchType.LAZY)
    @JoinTable(name="group_user", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    @OptimisticLock(excluded=true)
    public Set<MGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<MGroup> groups) {
        this.groups = groups;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Basic
    @Column(name="locale")
    public Locale getLocale() {
        return this.locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Basic
    @Column(name="timezone")
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void deletePersistent() {
        List tokens = HibernateDAOFactory.getMTokenDAO().findByUser(this);
        for (MToken t : tokens) {
            t.deletePersistent();
        }
        Set<MEvent> events = this.getEventsAuthored();
        ArrayList<MEvent> toRemove = new ArrayList<MEvent>();
        toRemove.addAll(events);
        for (MEvent e : toRemove) {
            e.deletePersistent();
        }
        this.getEventsAuthored().clear();
        MPermissionDAO permissionDAO = HibernateDAOFactory.getMPermissionDAO();
        List perms = permissionDAO.getAllUserBasePermissions((MUserBase)this);
        for (MPermission p : perms) {
            permissionDAO.makeTransient((Object)p);
        }
        for (MComment c : this.getReadComments()) {
            c.removeUser(this);
        }
        for (MGroup g : this.getGroups()) {
            g.getUsers().remove(this);
        }
        super.deletePersistent();
    }

    @Override
    @Transient
    public boolean isUser() {
        return true;
    }

    public void setLastUsed(MAccount lastUsed) {
        this.lastUsed = lastUsed;
    }

    @OneToOne(fetch=FetchType.LAZY, optional=true)
    @JoinColumn(name="account_id")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public MAccount getLastUsed() {
        return this.lastUsed;
    }

    @Basic
    @Column(name="superuser")
    @Type(type="boolean")
    public Boolean isSuperuser() {
        if (this.superuser != null && this.superuser.equals(true)) {
            return true;
        }
        return false;
    }

    public void setSuperuser(Boolean superuser) {
        this.superuser = superuser;
    }

    public void setPasswordSalt(String passwordSalt) {
        this.passwordSalt = passwordSalt;
    }

    @Basic
    @Column(name="passwordsalt", length=80)
    public String getPasswordSalt() {
        return this.passwordSalt;
    }

    public void rehashOldPassword() {
        try {
            SecureRandom sr = new SecureRandom();
            byte[] salt = new byte[20];
            sr.nextBytes(salt);
            BigInteger bigintSalt = new BigInteger(salt);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec keyspec = new PBEKeySpec(this.passwordMD5.toCharArray(), salt, 10000, 160);
            SecretKey key = factory.generateSecret(keyspec);
            BigInteger bigintPassword = new BigInteger(key.getEncoded());
            this.passwordHash = bigintPassword.toString(16).toUpperCase().trim();
            this.passwordSalt = bigintSalt.toString(16).toUpperCase().trim();
        }
        catch (NoSuchAlgorithmException e) {
            log.fatal((Object)"#### PBKDF2 ALGORITHM IS NOT SUPPORTED IN THIS SYSTEM AND WE NEED IT FOR CREATING THE PASSWORD HASHES ####", (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            log.fatal((Object)"#### INVALID KEY SPECIFICATION WHEN CREATING A PASSWORD HASH, THIS IS VERY BAD ####", (Throwable)e);
        }
    }

    @Transient
    public boolean hasNoName() {
        if (this.getName() == null || this.getEmail() == null) {
            return false;
        }
        return this.getName().trim().equalsIgnoreCase(this.getEmail().trim());
    }

    @Transient
    public String getEmailMD5() {
        if (this.getEmail() != null) {
            MD5encrypter md5 = MD5encrypter.getInstance();
            byte[] passMD5 = md5.encrypt(this.getEmail());
            return new BigInteger(1, passMD5).toString(16);
        }
        return null;
    }
}

