/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.user;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.MModel;
import com.justinmind.server.model.user.MPermission;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;

@Entity
@Table(name="userbase")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class MUserBase
extends MModel
implements Serializable {
    private static final long serialVersionUID = -8144430038515888925L;
    protected String name;
    private Set<MPermission> permissions = new HashSet<MPermission>();
    protected Boolean hasPicture = false;
    protected Boolean doNotUseGravatar = false;

    public MUserBase(String name) {
        this.name = name;
    }

    public MUserBase() {
    }

    @Basic
    @Column(name="name", length=200, nullable=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @OneToMany(mappedBy="userbase")
    @OptimisticLock(excluded=true)
    public Set<MPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<MPermission> permissions) {
        this.permissions = permissions;
    }

    @Transient
    public String getCompleteName() {
        return this.name;
    }

    @Transient
    public String getSurname() {
        return null;
    }

    @Transient
    public String getEmail() {
        return null;
    }

    @Transient
    public String getPhoneNumber() {
        return null;
    }

    @Transient
    public boolean isUser() {
        return false;
    }

    @Transient
    public boolean isGroup() {
        return false;
    }

    @Override
    public void deletePersistent() {
        HibernateDAOFactory.getMUserBaseDAO().makeTransient((Object)this);
        super.deletePersistent();
    }

    public Boolean getHasPicture() {
        if (this.hasPicture != null && this.hasPicture.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setHasPicture(Boolean hasPicture) {
        this.hasPicture = hasPicture;
    }

    public Boolean getDoNotUseGravatar() {
        if (this.doNotUseGravatar != null && this.doNotUseGravatar.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setDoNotUseGravatar(Boolean removedGravatar) {
        this.doNotUseGravatar = removedGravatar;
    }
}

