/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.model.widgets;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.MModel;
import com.justinmind.server.model.server.MFileServer;
import com.justinmind.server.model.user.MAccount;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="widgetlibrary")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"name", "revision", "sharedUUID", "JPVersion", "relatedOwnerID", "relatedOwnerName", "relatedAccountName", "relatedAccountID"})
@XmlRootElement(name="widgetLibrary")
public class MWidgetLibrary
extends MModel
implements Serializable {
    private static final long serialVersionUID = 8036444149469779427L;
    @XmlTransient
    private MAccount account;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="revision")
    private Integer revision;
    @XmlElement(name="sharedUUID")
    private String sharedUUID;
    @XmlElement(name="JPVersion")
    private String JPVersion;
    @XmlTransient
    private Long diskSize;
    @XmlTransient
    private MFileServer fileserver;
    @XmlElement(name="relatedOwnerID")
    private Long relatedOwnerID;
    @XmlElement(name="relatedOwnerName")
    private String relatedOwnerName;
    @XmlTransient
    private String relatedAccountName;
    @XmlTransient
    private Long relatedAccountID;

    public MWidgetLibrary() {
    }

    public MWidgetLibrary(String name) {
        this.name = name;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="account_fk")
    public MAccount getAccount() {
        return this.account;
    }

    public void setAccount(MAccount account) {
        this.account = account;
    }

    @Basic
    @Column(name="name", length=256)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Basic
    @Column(name="disksize")
    public Long getDiskSize() {
        return this.diskSize;
    }

    public void setDiskSize(Long diskSize) {
        this.diskSize = diskSize;
    }

    public void setFileserver(MFileServer fileserver) {
        this.fileserver = fileserver;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fileserver_fk")
    public MFileServer getFileserver() {
        return this.fileserver;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    @Basic
    @Column(name="revision")
    public Integer getRevision() {
        return this.revision;
    }

    @Basic
    @Column(name="sharedUUID")
    public String getSharedUUID() {
        return this.sharedUUID;
    }

    public void setSharedUUID(String sharedUUID) {
        this.sharedUUID = sharedUUID;
    }

    @Basic
    @Column(name="JPVersion")
    public String getJPVersion() {
        return this.JPVersion;
    }

    public void setJPVersion(String jpVersion) {
        this.JPVersion = jpVersion;
    }

    @Transient
    public String getPath() {
        return String.valueOf(this.account.getPath()) + this.getWidgetsFolder() + "/" + this.getSharedUUID() + "/";
    }

    @Transient
    public String getWidgetsFolder() {
        return "widget_libraries";
    }

    @Basic
    @Column(name="relatedOwnerID")
    public Long getRelatedOwnerID() {
        return this.relatedOwnerID;
    }

    public void setRelatedOwnerID(Long ownerID) {
        this.relatedOwnerID = ownerID;
    }

    @Basic
    @Column(name="relatedOwnerName")
    public String getRelatedOwnerName() {
        return this.relatedOwnerName;
    }

    public void setRelatedOwnerName(String ownerName) {
        this.relatedOwnerName = ownerName;
    }

    @Transient
    @XmlElement(name="relatedAccountID")
    public Long getRelatedAccountID() {
        return this.relatedAccountID;
    }

    public void setRelatedAccountID(Long accountID) {
        this.relatedAccountID = accountID;
    }

    @Transient
    @XmlElement(name="relatedAccountName")
    public String getRelatedAccountName() {
        return this.relatedAccountName;
    }

    public void setRelatedAccountName(String accountName) {
        this.relatedAccountName = accountName;
    }

    @Override
    @Transient
    public void deletePersistent() {
        super.deletePersistent();
        this.getAccount().removeLibrary(this);
        HibernateDAOFactory.getMWidgetLibraryDAO().makeTransient((Object)this);
    }
}

