/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.web.action.util.beans;

import com.justinmind.server.model.user.MAccount;
import com.justinmind.server.web.action.util.beans.AccountStatusBean;
import com.justinmind.server.web.action.util.beans.BaseBean;
import com.justinmind.server.web.action.util.beans.PeriodBean;
import com.justinmind.server.web.action.util.beans.UserBean;
import com.justinmind.util.prettydate.PrettyDate;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="account")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AccountBean
extends BaseBean
implements Serializable {
    private static final long serialVersionUID = -281886887231317857L;
    @XmlTransient
    private PeriodBean period;
    private UserBean owner;
    @XmlTransient
    private AccountStatusBean status;
    @XmlElement
    private Date accountCreated;
    @XmlTransient
    private Date lastActionDate;
    @XmlTransient
    private Boolean cancelled;
    @XmlTransient
    private Date nextChargeDate;
    @XmlTransient
    private BigDecimal nextChargeAmount;
    @XmlTransient
    private String creditCardLastFourDigits;
    @XmlTransient
    private String creditCardExpDate;
    @XmlTransient
    private Boolean canUpgrade;
    @XmlTransient
    private Boolean canDowngrade;
    @XmlTransient
    private Boolean canCancel;
    @XmlTransient
    private Boolean isEmpty;
    @XmlTransient
    private Boolean isCurrent;
    @XmlTransient
    private Boolean hasBranding;
    @XmlTransient
    private Boolean gift;
    @XmlTransient
    private String prototyperKey;
    @XmlTransient
    private Date endOfSupport;
    private String type;
    private String plimusAccountId;
    @XmlTransient
    private Boolean thereIsPlannedDowngrade;
    @XmlTransient
    private Integer newNumberOfUsers;
    @XmlTransient
    private Integer users;
    @XmlTransient
    private boolean subscription;
    @XmlTransient
    private boolean annual;
    @XmlTransient
    private boolean plimus;

    public AccountBean(MAccount a) {
        this.accountCreated = a.getCreated();
        this.name = a.getVisibleName();
        this.setId(a.getId());
        this.owner = new UserBean(a.getOwner());
        this.period = new PeriodBean(a.getPeriod());
        this.create = new PrettyDate(a.getCreated());
        this.status = new AccountStatusBean(a);
        this.gift = a.isGift();
        this.cancelled = a.isCancelledOrVeryExpired();
        this.nextChargeDate = a.getNextChargeDate();
        this.nextChargeAmount = a.getNextChargeAmount();
        this.creditCardLastFourDigits = a.getCreditCardLastFourDigits();
        this.creditCardExpDate = a.getCreditCardExpDate();
        if (a.getPeriod().getPlan() != null) {
            this.canCancel = a.getPeriod().getPlan().canCancel();
        }
        if (a.isCancelled().booleanValue()) {
            this.canCancel = false;
        }
        this.prototyperKey = a.getPrototyperKey();
        this.endOfSupport = a.getEndOfSupport();
        this.setPlimusAccountId(a.getPlimusAccountId());
        this.type = a.getType() != null ? a.getType().name() : "";
    }

    public AccountBean() {
        this.status = new AccountStatusBean();
        this.period = new PeriodBean();
    }

    public PeriodBean getPeriod() {
        return this.period;
    }

    public void setPeriod(PeriodBean period) {
        this.period = period;
    }

    public UserBean getOwner() {
        return this.owner;
    }

    public void setOwner(UserBean owner) {
        this.owner = owner;
    }

    public void setStatus(AccountStatusBean status) {
        this.status = status;
    }

    public AccountStatusBean getStatus() {
        return this.status;
    }

    public boolean isExpired() {
        if (this.period != null) {
            return this.period.isExpired();
        }
        return true;
    }

    public void setLastActionDate(Date lastActionDate) {
        this.lastActionDate = lastActionDate;
    }

    public Date getLastActionDate() {
        return this.lastActionDate;
    }

    public void setAccountCreated(Date accountCreated) {
        this.accountCreated = accountCreated;
    }

    public Date getAccountCreated() {
        return this.accountCreated;
    }

    public Boolean getCancelled() {
        return this.cancelled;
    }

    public void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    public Date getNextChargeDate() {
        return this.nextChargeDate;
    }

    public void setNextChargeDate(Date nextChargeDate) {
        this.nextChargeDate = nextChargeDate;
    }

    public String getNextChargeDateString() {
        DateFormat df = DateFormat.getDateInstance(2, Locale.US);
        return df.format(this.nextChargeDate);
    }

    public String getNextChargeAmountText() {
        NumberFormat df = NumberFormat.getInstance(new Locale("en"));
        df.setMinimumIntegerDigits(1);
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setGroupingUsed(false);
        return "$" + df.format(this.nextChargeAmount);
    }

    public BigDecimal getNextChargeAmount() {
        return this.nextChargeAmount;
    }

    public BigDecimal getNextChargeAmountIntegerPart() {
        return this.nextChargeAmount.setScale(0);
    }

    public void setNextChargeAmount(BigDecimal nextChargeAmount) {
        this.nextChargeAmount = nextChargeAmount;
    }

    public String getCreditCardLastFourDigits() {
        return this.creditCardLastFourDigits;
    }

    public void setCreditCardLastFourDigits(String creditCardLastFourDigits) {
        this.creditCardLastFourDigits = creditCardLastFourDigits;
    }

    public String getCreditCardExpDate() {
        return this.creditCardExpDate;
    }

    public void setCreditCardExpDate(String creditCardExpDate) {
        this.creditCardExpDate = creditCardExpDate;
    }

    public void setCanUpgrade(Boolean canUpgrade) {
        this.canUpgrade = canUpgrade;
    }

    public Boolean getCanUpgrade() {
        return this.canUpgrade;
    }

    public void setCanDowngrade(Boolean canDowngrade) {
        this.canDowngrade = canDowngrade;
    }

    public Boolean getCanDowngrade() {
        return this.canDowngrade;
    }

    public void setCanCancel(Boolean canCancel) {
        this.canCancel = canCancel;
    }

    public Boolean getCanCancel() {
        return this.canCancel;
    }

    public Boolean getIsEmpty() {
        return this.isEmpty;
    }

    public void setIsEmpty(Boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    public Boolean getIsCurrent() {
        return this.isCurrent;
    }

    public void setIsCurrent(Boolean isCurrent) {
        this.isCurrent = isCurrent;
    }

    public void setHasBranding(Boolean hasBranding) {
        this.hasBranding = hasBranding;
    }

    public Boolean getHasBranding() {
        return this.hasBranding;
    }

    public void setGift(Boolean gift) {
        this.gift = gift;
    }

    public Boolean isGift() {
        return this.gift;
    }

    public String getSeparatedPrototyperKeys() {
        if (this.prototyperKey != null && this.prototyperKey.contains("#")) {
            String keys = this.prototyperKey.replace("#", "<br>");
            keys = "<br><br>" + keys;
            return keys;
        }
        return this.prototyperKey;
    }

    public String getPrototyperKey() {
        return this.prototyperKey;
    }

    public void setPrototyperKey(String prototyperKey) {
        this.prototyperKey = prototyperKey;
    }

    public Date getEndOfSupport() {
        return this.endOfSupport;
    }

    public void setEndOfSupport(Date endOfSupport) {
        this.endOfSupport = endOfSupport;
    }

    public String getPlimusAccountId() {
        return this.plimusAccountId;
    }

    public void setPlimusAccountId(String plimusAccountId) {
        this.plimusAccountId = plimusAccountId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getThereIsPlannedDowngrade() {
        return this.thereIsPlannedDowngrade;
    }

    public void setThereIsPlannedDowngrade(Boolean thereIsPlannedDowngrade) {
        this.thereIsPlannedDowngrade = thereIsPlannedDowngrade;
    }

    public Integer getNewNumberOfUsers() {
        return this.newNumberOfUsers;
    }

    public void setNewNumberOfUsers(Integer newNumberOfUsers) {
        this.newNumberOfUsers = newNumberOfUsers;
    }

    public String getNewSize() {
        return AccountBean.humanReadableInt(300L * (long)this.newNumberOfUsers.intValue());
    }

    public static String humanReadableInt(Long number) {
        Long absNumber = Math.abs(number);
        double result = number.longValue();
        String suffix = "";
        if (absNumber < 1024L) {
            result = number.longValue();
            suffix = "MB";
        } else {
            result = (double)number.longValue() / 1024.0;
            suffix = "GB";
        }
        DecimalFormat oneDecimal = new DecimalFormat("0.0", new DecimalFormatSymbols(new Locale("en")));
        return String.valueOf(oneDecimal.format(result)) + suffix;
    }

    public Integer getUsers() {
        return this.users;
    }

    public void setUsers(Integer users) {
        this.users = users;
    }

    public boolean isSubscription() {
        return this.subscription;
    }

    public void setSubscription(boolean subscription) {
        this.subscription = subscription;
    }

    public boolean isAnnual() {
        return this.annual;
    }

    public void setAnnual(boolean annual) {
        this.annual = annual;
    }

    public boolean isPlimus() {
        return this.plimus;
    }

    public void setPlimus(boolean plimus) {
        this.plimus = plimus;
    }
}

