/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.web.action.util.beans;

import com.justinmind.server.model.user.MAccount;
import com.justinmind.server.web.action.util.Utils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Locale;

public class AccountStatusBean
implements Serializable {
    private static final long serialVersionUID = 6902016855400758311L;
    private Long diskUsed = 0L;
    private Long diskUsedLimit = 0L;
    private String diskUsedLimitHuman;
    private boolean limitReached;
    private Boolean free;
    private Boolean gift;
    private Boolean subscription;
    private Date accountExpiration;
    private String accountOwnerName;
    private String accountOwnerEmail;
    private Long prototyperCopies;
    private Long prototyperCopiesActive;
    private static DecimalFormat oneDecimal = new DecimalFormat("0.0", new DecimalFormatSymbols(new Locale("en")));

    public AccountStatusBean(MAccount currentAccount) {
        this(currentAccount.getDiskUsed(), currentAccount.getMaxDiskUsed(), currentAccount.isFree(), currentAccount.isGift(), currentAccount.getPeriod().getEnd());
        this.accountOwnerName = currentAccount.getOwner().getCompleteName();
        this.accountOwnerEmail = currentAccount.getOwner().getEmail();
        this.subscription = currentAccount.isSubscription();
    }

    protected AccountStatusBean(Long diskUsed, Long diskUsedLimit, Boolean isFree, Boolean isGift, Date accountExpiration) {
        this.diskUsedLimit = Utils.nullToZero((Long)diskUsedLimit);
        this.diskUsed = this.protectValue(diskUsed, this.diskUsedLimit);
        this.limitReached = this.diskUsedLimit <= this.diskUsed;
        this.free = isFree;
        this.gift = isGift;
        this.accountExpiration = accountExpiration;
    }

    public AccountStatusBean() {
    }

    protected Long protectValue(Long value, Long limit) {
        if (value == null || value < 0L) {
            return 0L;
        }
        return value > limit ? limit : value;
    }

    public String getDiskUsed() {
        return AccountStatusBean.humanReadableInt(this.diskUsed);
    }

    public void setDiskUsed(Long diskUsed) {
        this.diskUsed = diskUsed;
    }

    public Long getDiskUsedLimitLong() {
        return this.diskUsedLimit;
    }

    public String getDiskUsedLimitHumanReadable() {
        return AccountStatusBean.humanReadableInt(this.diskUsedLimit);
    }

    public Long getDiskUsedLimit() {
        return this.diskUsedLimit;
    }

    public void setDiskUsedLimit(Long diskUsedLimit) {
        this.diskUsedLimit = diskUsedLimit;
    }

    public int getDiskUsedPercentage() {
        BigDecimal usedSpaceBD = new BigDecimal(this.diskUsed * 100L);
        BigDecimal usedSpaceLimitBD = new BigDecimal(this.diskUsedLimit);
        if (this.diskUsedLimit != null && this.diskUsedLimit != 0L) {
            return usedSpaceBD.divide(usedSpaceLimitBD, RoundingMode.HALF_UP).intValue();
        }
        return 0;
    }

    public int getPrototyperCopiesActivePercentage() {
        BigDecimal prototyperCopiesActiveBD = new BigDecimal((this.prototyperCopiesActive != null ? this.prototyperCopiesActive : 0L) * 100L);
        BigDecimal prototyperCopiesBD = new BigDecimal(this.prototyperCopies != null ? this.prototyperCopies : 0L);
        if (this.prototyperCopies != null && this.prototyperCopies != 0L) {
            return prototyperCopiesActiveBD.divide(prototyperCopiesBD, RoundingMode.HALF_UP).intValue();
        }
        return 0;
    }

    public static Long parseHumanReadableInt(String number) {
        number = number.trim().toUpperCase();
        long value = 0L;
        value = number.endsWith("MB") ? (long)(Double.parseDouble(number.substring(0, number.length() - 2).trim()) * 1024.0 * 1024.0) : (number.endsWith("GB") ? (long)(Double.parseDouble(number.substring(0, number.length() - 2).trim()) * 1024.0 * 1024.0 * 1024.0) : (long)Double.parseDouble(number.substring(0, number.length() - 2).trim()));
        return value;
    }

    public static String humanReadableInt(Long number) {
        Long absNumber = Math.abs(number);
        double result = number.longValue();
        String suffix = "";
        if (absNumber < 0x40000000L) {
            result = (double)number.longValue() / 1048576.0;
            suffix = "MB";
        } else {
            result = (double)number.longValue() / 1.073741824E9;
            suffix = "GB";
        }
        return String.valueOf(oneDecimal.format(result)) + suffix;
    }

    public void setLimitReached(boolean limitReached) {
        this.limitReached = limitReached;
    }

    public boolean isLimitReached() {
        return this.limitReached;
    }

    public void setAccountExpiration(Date accountExpiration) {
        this.accountExpiration = accountExpiration;
    }

    public Date getAccountExpiration() {
        return this.accountExpiration;
    }

    public void setFree(boolean free) {
        this.free = free;
    }

    public boolean isFree() {
        return this.free != null ? this.free : false;
    }

    public void setAccountOwnerName(String accountOwnerName) {
        this.accountOwnerName = accountOwnerName;
    }

    public String getAccountOwnerName() {
        return this.accountOwnerName;
    }

    public void setAccountOwnerEmail(String accountOwnerEmail) {
        this.accountOwnerEmail = accountOwnerEmail;
    }

    public String getAccountOwnerEmail() {
        return this.accountOwnerEmail;
    }

    public void setGift(Boolean gift) {
        this.gift = gift;
    }

    public Boolean isGift() {
        return this.gift != null ? this.gift : false;
    }

    public void setDiskUsedLimitHuman(String diskUsedLimitHuman) {
        this.diskUsedLimitHuman = diskUsedLimitHuman;
        this.diskUsedLimit = AccountStatusBean.parseHumanReadableInt(diskUsedLimitHuman);
    }

    public String getDiskUsedLimitHuman() {
        return this.diskUsedLimitHuman;
    }

    public void setPrototyperCopies(Long prototyperCopies) {
        this.prototyperCopies = prototyperCopies;
    }

    public Long getPrototyperCopies() {
        return this.prototyperCopies;
    }

    public void setPrototyperCopiesActive(Long prototyperCopiesActive) {
        this.prototyperCopiesActive = prototyperCopiesActive;
    }

    public Long getPrototyperCopiesActive() {
        return this.prototyperCopiesActive;
    }

    public void setSubscription(Boolean subscription) {
        this.subscription = subscription;
    }

    public Boolean isSubscription() {
        return this.subscription;
    }
}

