/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.web.action.util.beans;

import com.justinmind.server.model.user.MUser;
import com.justinmind.util.prettydate.PrettyDate;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeMap;

public class CommentBean
implements Comparable<CommentBean> {
    protected String author;
    protected Long authorID;
    protected Long code;
    protected PrettyDate date;
    protected String content;
    protected String fileName;
    protected Long parentCode;
    protected PrettyDate prettyDate;
    protected boolean isRead;
    protected TreeMap<Integer, CommentBean> replies = new TreeMap(new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            return o2.compareTo(o1);
        }
    });

    public CommentBean(String author, Long authorID, Long code, Date date, String content, String fileName, Long parentCode, boolean isRead, MUser user) {
        this.author = author;
        this.code = code;
        this.date = new PrettyDate(date, user.getLocale(), user.getTimeZone());
        this.content = content;
        this.fileName = fileName;
        this.parentCode = parentCode;
        this.prettyDate = this.date;
        this.isRead = isRead;
        this.authorID = authorID;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Long getAuthorID() {
        return this.authorID;
    }

    public void setAuthorID(Long authorID) {
        this.authorID = authorID;
    }

    public Long getCode() {
        return this.code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public PrettyDate getDate() {
        return this.date;
    }

    public void setDate(Date date, MUser user) {
        this.date = new PrettyDate(date, user.getLocale(), user.getTimeZone());
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getParentCode() {
        return this.parentCode;
    }

    public void setParentCode(Long parentCode) {
        this.parentCode = parentCode;
    }

    public PrettyDate getPrettyDate() {
        return this.prettyDate;
    }

    public void setPrettyDate(Date date, MUser user) {
        this.prettyDate = new PrettyDate(date, user.getLocale(), user.getTimeZone());
    }

    public boolean getIsRead() {
        return this.isRead;
    }

    public void setIsRead(boolean isRead) {
        this.isRead = isRead;
    }

    public void setReplies(TreeMap<Integer, CommentBean> replies) {
        this.replies = replies;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommentBean other = (CommentBean)obj;
        return !(this.code == null ? other.code != null : !this.code.equals(other.code));
    }

    @Override
    public int compareTo(CommentBean o) {
        return this.code.compareTo(o.getCode());
    }
}

