/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.web.action.util.beans;

import com.justinmind.server.model.payment.MPlan;
import com.justinmind.server.model.payment.PlanType;
import com.justinmind.server.web.action.util.beans.BaseBean;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.io.FileUtils;

public class PlanBean
extends BaseBean
implements Serializable {
    private static final long serialVersionUID = -6946754796052727813L;
    protected PlanType type;
    protected String maxPrototypes;
    protected String maxSize;
    protected long maxSizeBytes;
    protected String price;
    protected boolean current;
    protected String storeLink;
    protected boolean gift;
    protected boolean monthly;
    private Long numberOfCopies;

    public PlanBean() {
    }

    public PlanBean(MPlan plan) {
        this.init(plan, null);
        this.gift = false;
    }

    private void init(MPlan plan, String storeLinkArg) {
        this.type = plan.getType();
        this.maxSizeBytes = plan.getMaxSize();
        this.maxSize = FileUtils.byteCountToDisplaySize((long)plan.getMaxSize());
        NumberFormat nf = NumberFormat.getInstance(new Locale("en"));
        this.price = nf.format(plan.getPrice());
        this.storeLink = storeLinkArg;
        if (plan != null && plan.getNumberOfCopies() != null) {
            this.setNumberOfCopies(plan.getNumberOfCopies());
        } else {
            this.setNumberOfCopies(0L);
        }
        this.monthly = plan.getType().isMonthly();
    }

    public PlanBean(MPlan plan, String storeLink) {
        this.init(plan, storeLink);
    }

    @Override
    public int compareTo(BaseBean o) {
        if (o instanceof PlanBean) {
            return new Long(this.maxSizeBytes).compareTo(new Long(((PlanBean)o).maxSizeBytes));
        }
        return super.compareTo(o);
    }

    public PlanType getType() {
        return this.type;
    }

    public void setType(PlanType type) {
        this.type = type;
    }

    public String getMaxPrototypes() {
        return this.maxPrototypes;
    }

    public void setMaxPrototypes(String maxPrototypes) {
        this.maxPrototypes = maxPrototypes;
    }

    public String getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(String maxSize) {
        this.maxSize = maxSize;
    }

    public String getPrice() {
        return this.price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        this.current = current;
    }

    public boolean isBetter(PlanBean plan) {
        BigDecimal thisPrice = new BigDecimal(this.price);
        BigDecimal secondPrice = new BigDecimal(plan.getPrice());
        return thisPrice.compareTo(secondPrice) == 1;
    }

    public String getStoreLink() {
        return this.storeLink;
    }

    public void setStoreLink(String storeLink) {
        this.storeLink = storeLink;
    }

    public boolean isFree() {
        return this.type != null && this.type.isFree();
    }

    public boolean isGift() {
        return this.gift;
    }

    public boolean isMonthly() {
        return this.monthly;
    }

    public void setGift(boolean gift) {
        this.gift = gift;
    }

    public Long getNumberOfCopies() {
        return this.numberOfCopies;
    }

    public void setNumberOfCopies(Long numberOfCopies) {
        this.numberOfCopies = numberOfCopies;
    }
}

