/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.web.action.util.beans;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.payment.MPlan;
import com.justinmind.server.model.payment.MPlimusIPN;
import com.justinmind.server.payment.PlimusManager;
import java.util.Date;

public class PlimusInvoiceBean
implements Comparable<PlimusInvoiceBean> {
    private String invoiceURL;
    private String invoiceChargeAmount;
    private String invoiceChargeCurrency;
    private String transactionDateString;
    private Date transactionDate;
    private String planName;
    private Long id;

    public PlimusInvoiceBean(MPlimusIPN ipn) {
        this.invoiceChargeAmount = ipn.getInvoiceChargeAmount();
        this.invoiceChargeCurrency = ipn.getInvoiceChargeCurrency();
        this.transactionDateString = ipn.getTransactionDate();
        this.invoiceURL = this.obtainInvoiceURL(ipn);
        this.transactionDate = PlimusManager.convertPlimusDate((String)this.transactionDateString);
        MPlan plan = HibernateDAOFactory.getMPlanDAO().findByContractId(ipn.getContractId());
        if (plan != null) {
            this.planName = plan.getType().name();
        } else if (ipn.getContractId() != null && (ipn.getContractId().equals("2894832") || ipn.getContractId().equals("3149190"))) {
            this.planName = "LICENSES";
        } else if (ipn.getContractId() != null && ipn.getContractId().equals("3092484")) {
            this.planName = "LICENSES RENEWAL";
        }
        if (ipn != null && (ipn.getContractId().equals("3092484") || ipn.getContractId().equals("2131910"))) {
            this.planName = "RENEWAL";
        }
        if (this.planName == null || this.planName.trim().isEmpty()) {
            this.planName = plan != null ? plan.getType().name() : "INVOICE";
        }
        this.id = ipn.getId();
    }

    private String obtainInvoiceURL(MPlimusIPN ipn) {
        String orderURL = ipn.getInvoiceInfoURL();
        if (orderURL.contains("order_locator_info")) {
            int jspIndex = orderURL.indexOf("/jsp/");
            int refIdIndex = orderURL.indexOf("refId=");
            if (jspIndex == -1 && refIdIndex == -1) {
                return orderURL;
            }
            try {
                String newURL = String.valueOf(orderURL.substring(0, jspIndex + 5)) + "show_invoice.jsp?ref=" + orderURL.substring(refIdIndex + 6, orderURL.length());
                return newURL;
            }
            catch (Exception e) {
                return null;
            }
        }
        return orderURL;
    }

    public void setInvoiceURL(String invoiceURL) {
        this.invoiceURL = invoiceURL;
    }

    public String getInvoiceURL() {
        return this.invoiceURL;
    }

    public void setInvoiceChargeAmount(String invoiceChargeAmount) {
        this.invoiceChargeAmount = invoiceChargeAmount;
    }

    public String getInvoiceChargeAmount() {
        return this.invoiceChargeAmount;
    }

    public void setInvoiceChargeCurrency(String invoiceChargeCurrency) {
        this.invoiceChargeCurrency = invoiceChargeCurrency;
    }

    public String getInvoiceChargeCurrency() {
        return this.invoiceChargeCurrency;
    }

    public void setTransactionDateString(String transactionDateString) {
        this.transactionDateString = transactionDateString;
    }

    public String getTransactionDateString() {
        return this.transactionDateString;
    }

    public void setTransactionDate(Date transactionDate) {
        this.transactionDate = transactionDate;
    }

    public Date getTransactionDate() {
        return this.transactionDate;
    }

    @Override
    public int compareTo(PlimusInvoiceBean arg0) {
        int dateComparison = arg0.getTransactionDate().compareTo(this.transactionDate);
        if (dateComparison != 0) {
            return dateComparison;
        }
        return arg0.getId().compareTo(this.id);
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public String getPlanName() {
        return this.planName;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

