/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.web.action.util.beans;

import com.justinmind.server.model.user.MUser;
import com.justinmind.server.web.action.util.beans.UserBaseBean;
import com.justinmind.util.crypto.MD5encrypter;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UserBean
extends UserBaseBean
implements Serializable {
    private static final long serialVersionUID = -741912048335531944L;
    protected boolean group = false;
    @XmlTransient
    private String username;
    @XmlElement
    private String password;
    @XmlTransient
    private String passwordConfirm;
    @XmlElement
    private String surname;
    @XmlTransient
    private Boolean active;
    @XmlElement
    private String email;
    @XmlElement
    private String company;
    @XmlTransient
    private String country;
    @XmlTransient
    private String howfind;
    @XmlTransient
    private String phonenumber;
    @XmlTransient
    private Integer projects;
    @XmlTransient
    private Integer versions;
    @XmlTransient
    private Integer blocked;
    @XmlTransient
    private boolean me;
    @XmlTransient
    private boolean admin;
    @XmlTransient
    private boolean accountOwner;
    private boolean superuser;
    @XmlTransient
    private boolean editor;
    @XmlTransient
    private boolean zombie;
    @XmlTransient
    private Locale locale;
    @XmlTransient
    private TimeZone timeZone;
    @XmlElement
    private boolean hasPicture;
    @XmlTransient
    private boolean doNotUseGravatar;
    @XmlElement
    private String imageBase64;

    public UserBean() {
    }

    private UserBean(long id, Date create, String username, String name, String surname, String email, String phonenumber) {
        super(id, create);
        this.username = username;
        this.name = name;
        this.surname = surname;
        this.email = email;
        this.phonenumber = phonenumber;
    }

    public UserBean(MUser u) {
        this(u.getId(), u.getCreated(), u.getUsername(), u.getCompleteName(), u.getSurname(), u.getEmail(), u.getPhoneNumber());
        this.locale = u.getLocale();
        this.timeZone = u.getTimeZone() == null ? TimeZone.getDefault() : u.getTimeZone();
        this.company = u.getCompany();
        this.active = u.isActive();
        this.superuser = u.isSuperuser();
        this.hasPicture = u.getHasPicture();
        this.doNotUseGravatar = u.getDoNotUseGravatar();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public Integer getProjects() {
        return this.projects;
    }

    @Override
    public void setProjects(Integer projects) {
        this.projects = projects;
    }

    @Override
    public Integer getVersions() {
        return this.versions;
    }

    @Override
    public void setVersions(Integer versions) {
        this.versions = versions;
    }

    @Override
    public Integer getBlocked() {
        return this.blocked;
    }

    @Override
    public void setBlocked(Integer blocked) {
        this.blocked = blocked;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isEmpty() {
        return this.username == null && this.name == null && this.surname == null && this.email == null;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getHowfind() {
        return this.howfind;
    }

    public void setHowfind(String howfind) {
        this.howfind = howfind;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public boolean getMe() {
        return this.me;
    }

    public void setMe(boolean me) {
        this.me = me;
    }

    @Override
    public boolean isAdmin() {
        return this.admin;
    }

    @Override
    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public String getPasswordConfirm() {
        return this.passwordConfirm;
    }

    public void setPasswordConfirm(String passwordConfirm) {
        this.passwordConfirm = passwordConfirm;
    }

    public String getPhonenumber() {
        return this.phonenumber;
    }

    public void setPhonenumber(String phonenumber) {
        this.phonenumber = phonenumber;
    }

    public void setAccountOwner(boolean accountOwner) {
        this.accountOwner = accountOwner;
    }

    public boolean getAccountOwner() {
        return this.accountOwner;
    }

    public void setSuperuser(boolean superuser) {
        this.superuser = superuser;
    }

    public boolean isSuperuser() {
        return this.superuser;
    }

    public void setLocale(String stringLocale) {
        this.locale = new Locale(stringLocale);
    }

    public Locale getLocale() {
        return this.locale == null ? new Locale("en") : this.locale;
    }

    public void setTimeZone(String stringTimeZone) {
        this.timeZone = TimeZone.getTimeZone(stringTimeZone);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Boolean isActive() {
        return this.active;
    }

    @Override
    public void setEditor(boolean editor) {
        this.editor = editor;
    }

    @Override
    public boolean isEditor() {
        return this.editor;
    }

    @Override
    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public void setZombie(boolean zombie) {
        this.zombie = zombie;
    }

    public boolean isZombie() {
        return this.zombie;
    }

    public String getCompleteName() {
        if (this.name != null) {
            if (this.surname != null && !this.surname.trim().equals("")) {
                return String.valueOf(this.name.trim()) + " " + this.surname.trim();
            }
            return this.name.trim();
        }
        if (this.surname != null) {
            return this.surname.trim();
        }
        if (this.username != null) {
            return this.username.trim();
        }
        return this.email;
    }

    public boolean isHasPicture() {
        return this.hasPicture;
    }

    public void setHasPicture(boolean hasPicture) {
        this.hasPicture = hasPicture;
    }

    public String getImageBase64() {
        return this.imageBase64;
    }

    public void setImageBase64(String imageBase64) {
        this.imageBase64 = imageBase64;
    }

    public String getEmailMD5() {
        if (this.getEmail() != null) {
            MD5encrypter md5 = MD5encrypter.getInstance();
            byte[] passMD5 = md5.encrypt(this.getEmail());
            return new BigInteger(1, passMD5).toString(16);
        }
        return null;
    }

    public boolean isDoNotUseGravatar() {
        return this.doNotUseGravatar;
    }

    public void setDoNotUseGravatar(boolean doNotUseGravatar) {
        this.doNotUseGravatar = doNotUseGravatar;
    }
}

