/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.server.web.action.util.beans;

import com.justinmind.server.dao.HibernateDAOFactory;
import com.justinmind.server.model.user.MAccount;
import com.justinmind.server.model.user.MUser;
import com.justinmind.server.model.user.MUserBase;
import com.justinmind.server.persistence.HibernateUtilNew;
import com.justinmind.server.web.action.util.beans.GroupBean;
import com.justinmind.server.web.action.util.beans.UserBaseBean;
import com.justinmind.server.web.action.util.beans.UserBean;

public class UsernoteBeanFactory {
    public static UserBaseBean buildUserOrGroupBean(MUserBase userbase) {
        UserBaseBean result = null;
        if (userbase.isGroup()) {
            result = new GroupBean();
        } else {
            MUser user = (MUser)HibernateUtilNew.initializeAndUnproxy((Object)userbase);
            result = new UserBean(user);
        }
        result.setCreate(userbase.getCreated());
        result.setDelete(userbase.getDeleted());
        result.setId(userbase.getId());
        result.setModify(userbase.getModified());
        result.setName(userbase.getName());
        return result;
    }

    public static UserBean buildUserBean(MUser user) {
        UserBean result = null;
        result = new UserBean(user);
        result.setCreate(user.getCreated());
        result.setDelete(user.getDeleted());
        result.setId(user.getId());
        result.setModify(user.getModified());
        result.setName(user.getName());
        return result;
    }

    public static UserBaseBean buildUserOrGroupBean(MUserBase u, MUser currentUser, MAccount currentAccount) {
        UserBaseBean result = UsernoteBeanFactory.buildUserOrGroupBean(u);
        if (!u.isGroup()) {
            ((UserBean)result).setMe(u.equals(currentUser));
            ((UserBean)result).setAdmin(HibernateDAOFactory.getMPermissionDAO().isAdmin(u, currentAccount));
            ((UserBean)result).setAccountOwner(currentAccount.getOwner().equals(u));
        }
        return result;
    }
}

