/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.usernoteclient;

import com.google.gson.JsonArray;
import com.justinmind.server.util.ObjectFactory;
import com.justinmind.server.web.action.util.beans.UserBean;
import com.justinmind.usernoteclient.NonSecureCookieStore;
import com.justinmind.usernoteclient.UsernoteResult;
import com.justinmind.usernoteclient.UsernoteURLS;
import com.justinmind.util.JAXB.JAXBJimHelper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.axis.encoding.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.http.util.VersionInfo;
import org.apache.log4j.Logger;

public class UsernoteClient {
    private static final Logger log = Logger.getLogger(UsernoteClient.class);
    public static final int ERROR_CONNECTION = -1;
    public static final int ERROR_BAD_SIGNIN = -2;
    public static final int ERROR_INVALID_PARAMETER = -3;
    public static final int ERROR_PROTOTYPE_TOO_BIG = -4;
    public static final int ERROR_TOO_MANY_PROTOTYPES = -5;
    public static final int ERROR_TRIAL_EXPIRED = -6;
    public static final int ERROR_COMMERCIAL_EXPIRED = -7;
    public static final int ERROR_PROJECT_NAME_EXISTS = -8;
    public static final int ERROR_PROJECT_NAME_TOO_LONG = -9;
    public static final int ERROR_PROTOTYPE_IS_NOT_VP = -10;
    public static final int ERROR_SHOW_USERNOTE_MESSAGE = -200;
    public static final int ERROR_PROXY_AUTHENTICATION = -407;
    public static final int ERROR_INTERNAL_SERVER_ERROR = -500;
    public static final int ERROR_BAD_REQUEST_ERROR = -400;
    public static final int STATUS_OK = 200;
    private static final String USERNOTE_ONDEMAND_ROOT_URL = "http://www.justinmind.com/usernote/";
    private static final Pattern pattern = Pattern.compile("\"usernoteClientErrors\":\\[((?:\"(?:[^\\\\\"]|\\\\.)*\",?)*)\\]");
    private static UsernoteClient usernoteClient;
    private HttpClientConnectionManager connManager = null;
    private HttpClientContext context;
    private RequestConfig config;
    private CloseableHttpClient client;
    private boolean signedIn = false;
    private String username;
    private String password;
    private String loginToken;
    private String usernoteRootURL;
    private String proxy_host;
    private int proxy_port;
    private String proxy_username;
    private String proxy_password;
    private SSLContext sslContext;
    private static String userAgent;
    private static final String NODE_ROOT_URL = "http://sync.justinmind.com:8000";

    protected UsernoteClient() {
        this.initHttpClient();
    }

    protected UsernoteClient(String usernoteRootURL) {
        if (usernoteRootURL != null) {
            this.setUsernoteRootURL(usernoteRootURL);
        }
        this.initHttpClient();
    }

    public static void initialize(String usernoteRootURL, String userAgentParam) {
        String string = userAgent = userAgentParam != null ? userAgentParam.trim() : "Justinmind Prototyper 4.6.1";
        if (usernoteClient != null) {
            UsernoteClient.usernoteClient.connManager.shutdown();
        }
        usernoteClient = new UsernoteClient(usernoteRootURL);
    }

    protected void initHttpClient() {
        try {
            KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmfactory.init(null, null);
            KeyManager[] keymanagers = kmfactory.getKeyManagers();
            TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmfactory.init((KeyStore)null);
            TrustManager[] trustmanagers = tmfactory.getTrustManagers();
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(keymanagers, trustmanagers, null);
            userAgent = VersionInfo.getUserAgent((String)"Apache-HttpClient", (String)"org.apache.http.client", HttpClientBuilder.class);
            PlainConnectionSocketFactory plainsf = new PlainConnectionSocketFactory();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(this.sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
            this.connManager = new BasicHttpClientConnectionManager((Lookup)registry);
            ArrayList<String> authSchemes = new ArrayList<String>();
            authSchemes.add("NTLM");
            authSchemes.add("Digest");
            authSchemes.add("Basic");
            this.config = RequestConfig.custom().setRedirectsEnabled(false).setProxyPreferredAuthSchemes(authSchemes).setSocketTimeout(0).setConnectTimeout(2000).build();
            this.buildBaseConnection();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
    }

    public static UsernoteClient getInstance() {
        if (usernoteClient == null) {
            usernoteClient = new UsernoteClient(USERNOTE_ONDEMAND_ROOT_URL);
        }
        return usernoteClient;
    }

    public UsernoteResult doSignIn(String usernameAttr, String passwordAttr) {
        if (this.signedIn && this.username != null && this.password != null && this.username.equalsIgnoreCase(usernameAttr) && this.password.equals(passwordAttr)) {
            return new UsernoteResult(200, "Signed in correctly");
        }
        return this.doForceSignIn(usernameAttr, passwordAttr);
    }

    public UsernoteResult doForceSignIn(String usernameAttr, String passwordAttr) {
        return this.doForceSignIn(UsernoteURLS.SIGNIN_URL.getCompleteURL(), usernameAttr, passwordAttr, true);
    }

    public synchronized UsernoteResult doForceSignIn(String url, String usernameAttr, String passwordAttr, boolean redirect) {
        try {
            UsernoteResult nok;
            this.username = usernameAttr;
            this.password = passwordAttr;
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            formparams.add(new BasicNameValuePair("username", usernameAttr));
            formparams.add(new BasicNameValuePair("password", passwordAttr));
            UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
            HttpPost httppost = new HttpPost(url);
            httppost.setEntity((HttpEntity)form);
            httppost.setConfig(RequestConfig.custom().setCookieSpec("netscape").build());
            CloseableHttpResponse response = this.context == null ? this.client.execute((HttpUriRequest)httppost) : this.client.execute((HttpUriRequest)httppost, (HttpContext)this.context);
            int httpStatus = response.getStatusLine().getStatusCode();
            if (httpStatus == 302) {
                response.getEntity().getContent().close();
                Header[] headerArray = response.getAllHeaders();
                int n = headerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String locationLowerCase;
                    Header h = headerArray[n2];
                    if (h.getName().equalsIgnoreCase("location") && (locationLowerCase = h.getValue().toLowerCase(Locale.ENGLISH)).startsWith("https") && locationLowerCase.contains("signin.action") && redirect) {
                        String newURL = h.getValue().substring(0, h.getValue().indexOf("?"));
                        response.close();
                        return this.doForceSignIn(newURL, usernameAttr, passwordAttr, false);
                    }
                    ++n2;
                }
            } else if (httpStatus == 200) {
                UsernoteResult ok = new UsernoteResult(200, "Signed in correctly");
                UsernoteResult result = this.getUsernoteResult((HttpResponse)response);
                ClassLoader cl = ObjectFactory.class.getClassLoader();
                JAXBJimHelper.init((String)"com.justinmind.server.util", (ClassLoader)cl);
                UserBean userConnected = (UserBean)JAXBJimHelper.unmarshal((String)((String)result.getResponse()));
                ok.setBeanData(userConnected);
                response.getEntity().getContent().close();
                this.signedIn = true;
                return ok;
            }
            response.getEntity().getContent().close();
            response.close();
            this.signedIn = false;
            if (httpStatus == 500) {
                nok = new UsernoteResult(-500);
                return nok;
            }
            if (httpStatus >= 400 && httpStatus < 500) {
                nok = new UsernoteResult(-2, "Bad username or password");
                return nok;
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Error in Usernote client: invalid parameter", (Throwable)e);
        }
        catch (ClientProtocolException e) {
            System.out.println(((Object)((Object)e)).getClass().toString());
            log.error((Object)"Error connecting to Usernote.", (Throwable)e);
        }
        catch (IOException e) {
            System.out.println(e.getClass().toString());
            log.error((Object)"Error connecting to Usernote.", (Throwable)e);
            e.printStackTrace();
        }
        return this.returnConnectionErrorResult();
    }

    protected HttpResponse doRequest(HttpRequestBase request, boolean reSignIn) {
        CloseableHttpResponse response = null;
        try {
            CloseableHttpResponse closeableHttpResponse = response = this.context != null ? this.client.execute((HttpUriRequest)request, (HttpContext)this.context) : this.client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 302) {
                Header[] headerArray = response.getAllHeaders();
                int n = headerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Header h = headerArray[n2];
                    if (h.getName().equalsIgnoreCase("location")) {
                        String value = h.getValue();
                        if (value.toLowerCase(Locale.ENGLISH).contains("login.action") || value.toLowerCase(Locale.ENGLISH).contains("signinagain")) {
                            response.getEntity().getContent().close();
                            if (!reSignIn) {
                                this.doForceSignIn(this.username, this.password);
                                return this.doRequest(request, true);
                            }
                        } else {
                            if (value.toLowerCase(Locale.ENGLISH).contains("accountexpired.action") || value.toLowerCase(Locale.ENGLISH).contains("trialexpired.action")) {
                                return response;
                            }
                            response.getEntity().getContent().close();
                            request.setURI(new URI(value));
                            return this.doRequest(request, false);
                        }
                    }
                    ++n2;
                }
            }
            if (response.getStatusLine().getStatusCode() >= 400) {
                log.debug((Object)response.toString());
            }
            return response;
        }
        catch (ClientProtocolException e) {
            log.error((Object)"Error connecting to Usernote.", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error connecting to Usernote.", (Throwable)e);
        }
        catch (URISyntaxException e) {
            log.error((Object)"Error in connection URL", (Throwable)e);
        }
        return null;
    }

    public void postMetrics(JsonArray json) throws IOException {
        HttpPost httppost = new HttpPost(NODE_ROOT_URL);
        StringEntity stringEntity = new StringEntity(json.toString());
        httppost.setEntity((HttpEntity)stringEntity);
        httppost.setHeader("Content-type", "application/json");
        String metricsUsername = "jim";
        String metricsPassword = "50wombats";
        String credentials = String.valueOf(metricsUsername) + ":" + metricsPassword;
        String encoded = Base64.encode((byte[])credentials.getBytes());
        httppost.setHeader("Authorization", "Basic " + encoded);
        CloseableHttpResponse response = this.context == null ? this.client.execute((HttpUriRequest)httppost) : this.client.execute((HttpUriRequest)httppost, (HttpContext)this.context);
        response.close();
    }

    public int sendReport(URL listenerUrl, String messageText) throws IOException {
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("ERROR", messageText));
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        HttpPost httppost = new HttpPost(listenerUrl.toString());
        httppost.setEntity((HttpEntity)form);
        CloseableHttpResponse response = this.context == null ? this.client.execute((HttpUriRequest)httppost) : this.client.execute((HttpUriRequest)httppost, (HttpContext)this.context);
        try {
            int n = response.getStatusLine().getStatusCode();
            return n;
        }
        catch (Exception e) {
            return -1;
        }
        finally {
            response.close();
        }
    }

    public byte[] postPrototyperKey(String absoluteURLString, String key) throws IOException {
        HttpEntity entity;
        CloseableHttpResponse response;
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("number", key));
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        HttpPost httppost = new HttpPost(absoluteURLString);
        httppost.setEntity((HttpEntity)form);
        CloseableHttpResponse closeableHttpResponse = response = this.context == null ? this.client.execute((HttpUriRequest)httppost) : this.client.execute((HttpUriRequest)httppost, (HttpContext)this.context);
        if (response.getStatusLine().getStatusCode() == 200 && (entity = response.getEntity()) != null) {
            int nRead;
            InputStream instream = entity.getContent();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = instream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            instream.close();
            return buffer.toByteArray();
        }
        response.close();
        return null;
    }

    public HttpResponse doRequest(HttpRequestBase request) {
        return this.doRequest(request, false);
    }

    public UsernoteResult getProjectList() {
        try {
            HttpGet httpget = new HttpGet(UsernoteURLS.DOGETPROJECTS_URL.getCompleteURL());
            httpget.setConfig(RequestConfig.custom().setCookieSpec("netscape").build());
            HttpResponse response = this.doRequest((HttpRequestBase)httpget);
            if (response == null) {
                return this.returnConnectionErrorResult();
            }
            UsernoteResult result = new UsernoteResult();
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                int l;
                InputStream instream = entity.getContent();
                byte[] tmp = new byte[2048];
                StringBuffer xmlFile = new StringBuffer();
                while ((l = instream.read(tmp)) != -1) {
                    xmlFile.append(new String(tmp, 0, l, "UTF-8"));
                }
                instream.close();
                result.setResponse(xmlFile.toString());
            }
            if (response.getStatusLine().getStatusCode() == 500) {
                result.setStatus(-500);
            } else if (response.getStatusLine().getStatusCode() == 302) {
                Header[] headerArray = response.getAllHeaders();
                int n = headerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Header h = headerArray[n2];
                    if (h.getName().equalsIgnoreCase("location")) {
                        if (h.getValue().contains("accountExpired.action")) {
                            UsernoteResult nok = new UsernoteResult(-7);
                            return nok;
                        }
                        if (h.getValue().contains("trialExpired.action")) {
                            UsernoteResult nok = new UsernoteResult(-6);
                            return nok;
                        }
                        UsernoteResult nok = new UsernoteResult(-500);
                        return nok;
                    }
                    ++n2;
                }
            } else {
                result.setStatus(200);
            }
            return result;
        }
        catch (ClientProtocolException e) {
            log.error((Object)"Error connecting to Usernote.", (Throwable)e);
            return this.returnConnectionErrorResult();
        }
        catch (IOException e) {
            log.error((Object)"Error connecting to Usernote.", (Throwable)e);
            return this.returnConnectionErrorResult();
        }
    }

    public UsernoteResult doPublishPrototype(File prototypeFile, String description, String accountId, String projectId, String projectName, String installId) {
        int l;
        Object[] tmp;
        HttpPost httppost = new HttpPost(UsernoteURLS.DOPUBLISHPROTOTYPE_URL.getCompleteURL());
        httppost.setConfig(RequestConfig.custom().setCookieSpec("netscape").build());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        try {
            ContentType utf8 = ContentType.create((String)"text/plain", (String)"UTF-8");
            builder.addPart("accountId", (ContentBody)new StringBody(accountId, utf8));
            if (projectId == null && projectName != null) {
                builder.addPart("newProjectName", (ContentBody)new StringBody(projectName, utf8));
            } else {
                builder.addPart("projectId", (ContentBody)new StringBody(projectId, utf8));
            }
            builder.addPart("installId", (ContentBody)new StringBody(installId, utf8));
            builder.addPart("bean.description", (ContentBody)new StringBody(description, utf8));
        }
        catch (Exception e) {
            log.error((Object)"Error in Usernote client: invalid parameter", (Throwable)e);
            UsernoteResult result = new UsernoteResult(-3, "Error in Usernote client: invalid parameter");
            return result;
        }
        FileBody bin = new FileBody(prototypeFile);
        builder.addPart("file", (ContentBody)bin);
        httppost.setEntity(builder.build());
        HttpResponse response = this.doRequest((HttpRequestBase)httppost);
        if (response == null) {
            return this.returnConnectionErrorResult();
        }
        String responseString = "";
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream instream = entity.getContent();
                tmp = new byte[2048];
                StringBuffer buffer = new StringBuffer();
                while ((l = instream.read((byte[])tmp)) != -1) {
                    buffer.append(new String((byte[])tmp, 0, l, "UTF-8"));
                }
                instream.close();
                responseString = buffer.toString();
            }
        }
        catch (IllegalStateException e) {
            log.error((Object)"Error in Usernote client: illegal state, probably response not consumed.", (Throwable)e);
            return this.returnConnectionErrorResult();
        }
        catch (IOException e) {
            log.error((Object)"Error connecting to Usernote.", (Throwable)e);
            return this.returnConnectionErrorResult();
        }
        if (response.getStatusLine().getStatusCode() == 500) {
            UsernoteResult result = new UsernoteResult(-500);
            return result;
        }
        if (response.getStatusLine().getStatusCode() == 302) {
            Header[] headerArray = response.getAllHeaders();
            tmp = headerArray;
            l = headerArray.length;
            int instream = 0;
            while (instream < l) {
                byte h = tmp[instream];
                if (h.getName().equalsIgnoreCase("location")) {
                    UsernoteResult nok;
                    if (h.getValue().contains("accountExpired.action")) {
                        nok = new UsernoteResult(-7);
                        return nok;
                    }
                    if (h.getValue().contains("trialExpired.action")) {
                        nok = new UsernoteResult(-6);
                        return nok;
                    }
                }
                ++instream;
            }
            UsernoteResult nok = new UsernoteResult(-500);
            return nok;
        }
        String[] errorCodes = this.parseUsernoteClientErrors(responseString);
        if (errorCodes.length == 0) {
            UsernoteResult result = new UsernoteResult(200, "Prototype successfully uploaded.");
            String newProjectId = this.parseResponse(responseString, "projectId");
            String listPrototypesURL = newProjectId != null && !newProjectId.equals("") ? String.valueOf(UsernoteURLS.LISTPROTOTYPES_URL.getCompleteURL()) + "?token=" + this.getLoginToken() + "&projectId=" + newProjectId : String.valueOf(UsernoteURLS.LISTPROJECTS_URL.getCompleteURL()) + "?token=" + this.getLoginToken();
            result.setResponse(responseString);
            result.setBeanData(listPrototypesURL);
            return result;
        }
        return this.buildResultFromUsernoteErrorCode(errorCodes[0]);
    }

    public String getParameter(String response, String parameter) {
        if (response.contains(parameter)) {
            String first_section = response.substring(response.indexOf(parameter) + parameter.length() + 2, response.length());
            return first_section.substring(0, first_section.indexOf(","));
        }
        return "";
    }

    public UsernoteResult doPublishForTest(String accountId, String prototypeId, String installId) {
        int l;
        HttpPost httppost = new HttpPost(UsernoteURLS.PUBLISHFORTEST_URL.getCompleteURL());
        httppost.setConfig(RequestConfig.custom().setCookieSpec("netscape").build());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        try {
            ContentType utf8 = ContentType.create((String)"text/plain", (String)"UTF-8");
            builder.addPart("accountId", (ContentBody)new StringBody(accountId, utf8));
            builder.addPart("prototypeId", (ContentBody)new StringBody(prototypeId, utf8));
            builder.addPart("tool", (ContentBody)new StringBody("0", utf8));
            builder.addPart("installId", (ContentBody)new StringBody(installId, utf8));
        }
        catch (Exception e) {
            log.error((Object)"Error in Usernote client: invalid parameter", (Throwable)e);
            UsernoteResult result = new UsernoteResult(-3, "Error in Usernote client: invalid parameter");
            return result;
        }
        httppost.setEntity(builder.build());
        HttpResponse response = this.doRequest((HttpRequestBase)httppost);
        if (response == null) {
            return this.returnConnectionErrorResult();
        }
        String responseString = "";
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream instream = entity.getContent();
                byte[] tmp = new byte[2048];
                StringBuffer buffer = new StringBuffer();
                while ((l = instream.read(tmp)) != -1) {
                    buffer.append(new String(tmp, 0, l, "UTF-8"));
                }
                instream.close();
                responseString = buffer.toString();
            }
        }
        catch (IllegalStateException e) {
            log.error((Object)"Error in Usernote client: illegal state, probably response not consumed.", (Throwable)e);
            return this.returnConnectionErrorResult();
        }
        catch (IOException e) {
            log.error((Object)"Error connecting to Usernote.", (Throwable)e);
            return this.returnConnectionErrorResult();
        }
        if (response.getStatusLine().getStatusCode() == 500) {
            UsernoteResult result = new UsernoteResult(-500);
            return result;
        }
        if (response.getStatusLine().getStatusCode() == 302) {
            Header[] headerArray = response.getAllHeaders();
            l = headerArray.length;
            int instream = 0;
            while (instream < l) {
                Header h = headerArray[instream];
                if (h.getName().equalsIgnoreCase("location")) {
                    UsernoteResult nok;
                    if (h.getValue().contains("accountExpired.action")) {
                        nok = new UsernoteResult(-7);
                        return nok;
                    }
                    if (h.getValue().contains("trialExpired.action")) {
                        nok = new UsernoteResult(-6);
                        return nok;
                    }
                }
                ++instream;
            }
            UsernoteResult nok = new UsernoteResult(-500);
            return nok;
        }
        String[] errorCodes = this.parseUsernoteClientErrors(responseString);
        if (errorCodes.length == 0) {
            UsernoteResult result = new UsernoteResult(200, "Prototype successfully uploaded.");
            String test_url = this.parseResponse(responseString, "test_url");
            result.setResponse(test_url);
            return result;
        }
        return this.buildResultFromUsernoteErrorCode(errorCodes[0]);
    }

    private String parseResponse(String response, String param) {
        if (param.equals("test_url")) {
            if (response.contains("test_url")) {
                String first_section = response.substring(response.indexOf("test_url") + 11, response.length());
                return first_section.substring(0, first_section.indexOf("\"")).replace("\\", "");
            }
            return "";
        }
        if (param.equals("projectId")) {
            if (response.contains("projectId")) {
                String first_section = response.substring(response.indexOf("projectId") + 11, response.length());
                return first_section.substring(0, first_section.indexOf(","));
            }
            return "";
        }
        return "";
    }

    public UsernoteResult doNewPrototypeVersion(File prototypeFile, String description, String accountId, String projectId, String prototypeId, String installId) {
        return this.doNewPrototypeVersion(prototypeFile, description, false, accountId, projectId, prototypeId, installId);
    }

    public UsernoteResult doNewPrototypeVersion(File prototypeFile, String description, boolean notifyReviewers, String accountId, String projectId, String prototypeId, String installId) {
        int l;
        HttpPost httppost = new HttpPost(UsernoteURLS.DONEWPROTOTYPEVERSION_URL.getCompleteURL());
        httppost.setConfig(RequestConfig.custom().setCookieSpec("netscape").build());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        try {
            ContentType utf8 = ContentType.create((String)"text/plain", (String)"UTF-8");
            builder.addPart("accountId", (ContentBody)new StringBody(accountId, utf8));
            builder.addPart("id", (ContentBody)new StringBody(prototypeId, utf8));
            builder.addPart("description", (ContentBody)new StringBody(description, utf8));
            builder.addPart("installId", (ContentBody)new StringBody(installId, utf8));
            builder.addPart("notifyReviewers", (ContentBody)new StringBody(Boolean.toString(notifyReviewers), utf8));
        }
        catch (Exception e) {
            log.error((Object)"Error in Usernote client: invalid parameter", (Throwable)e);
            UsernoteResult result = new UsernoteResult(-3, "Error in Usernote client: invalid parameter");
            return result;
        }
        FileBody bin = new FileBody(prototypeFile);
        builder.addPart("file", (ContentBody)bin);
        httppost.setEntity(builder.build());
        HttpResponse response = this.doRequest((HttpRequestBase)httppost);
        if (response == null) {
            return this.returnConnectionErrorResult();
        }
        String responseString = "";
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream instream = entity.getContent();
                byte[] tmp = new byte[2048];
                StringBuffer buffer = new StringBuffer();
                while ((l = instream.read(tmp)) != -1) {
                    buffer.append(new String(tmp, 0, l, "UTF-8"));
                }
                instream.close();
                responseString = buffer.toString();
            }
        }
        catch (IllegalStateException e) {
            log.error((Object)"Error in Usernote client: illegal state, probably response not consumed.", (Throwable)e);
            return this.returnConnectionErrorResult();
        }
        catch (IOException e) {
            log.error((Object)"Error connecting to Usernote.", (Throwable)e);
            return this.returnConnectionErrorResult();
        }
        if (response.getStatusLine().getStatusCode() == 500) {
            UsernoteResult result = new UsernoteResult(-500);
            return result;
        }
        if (response.getStatusLine().getStatusCode() == 302) {
            Header[] headerArray = response.getAllHeaders();
            l = headerArray.length;
            int instream = 0;
            while (instream < l) {
                Header h = headerArray[instream];
                if (h.getName().equalsIgnoreCase("location")) {
                    UsernoteResult nok;
                    if (h.getValue().contains("accountExpired.action")) {
                        nok = new UsernoteResult(-7);
                        return nok;
                    }
                    if (h.getValue().contains("trialExpired.action")) {
                        nok = new UsernoteResult(-6);
                        return nok;
                    }
                }
                ++instream;
            }
            UsernoteResult nok = new UsernoteResult(-500);
            return nok;
        }
        String[] errorCodes = this.parseUsernoteClientErrors(responseString);
        if (errorCodes.length == 0) {
            UsernoteResult result = new UsernoteResult(200, "Prototype successfully uploaded.");
            String listPrototypesURL = String.valueOf(UsernoteURLS.LISTPROTOTYPES_URL.getCompleteURL()) + "?token=" + this.getLoginToken() + "&projectId=" + projectId;
            result.setBeanData(listPrototypesURL);
            result.setResponse(responseString);
            return result;
        }
        return this.buildResultFromUsernoteErrorCode(errorCodes[0]);
    }

    private UsernoteResult returnConnectionErrorResult() {
        UsernoteResult result = new UsernoteResult(-1, "Error connecting to Usernote");
        return result;
    }

    private void buildBaseConnection() {
        this.client = HttpClients.custom().setDefaultRequestConfig(this.config).setConnectionManager(this.connManager).setUserAgent(userAgent).setDefaultCookieStore((CookieStore)new NonSecureCookieStore()).build();
    }

    private UsernoteResult buildResultFromUsernoteErrorCode(String errorCodeString) {
        UsernoteResult result = new UsernoteResult();
        if (errorCodeString.startsWith(String.valueOf(Integer.toString(-200)) + ":")) {
            result.setStatus(-200);
            result.setResponse(errorCodeString.substring(5));
        } else {
            result.setStatus(Integer.parseInt(errorCodeString));
        }
        return result;
    }

    private String[] parseUsernoteClientErrors(String responseString) {
        Matcher matcher = pattern.matcher(responseString);
        String valueString = "";
        if (matcher.find()) {
            valueString = matcher.group(1);
            String[] quotedValues = valueString.split("(?<=\"),(?=\")");
            String[] values = new String[quotedValues.length];
            int i = 0;
            while (i < quotedValues.length) {
                values[i] = quotedValues[i].length() >= 2 ? quotedValues[i].substring(1, quotedValues[i].length() - 1) : quotedValues[i];
                ++i;
            }
            return values;
        }
        return new String[0];
    }

    public String getListProjectsURL() {
        return String.valueOf(UsernoteURLS.LISTPROJECTS_URL.getCompleteURL()) + "?token=" + this.getLoginToken();
    }

    public String getAccountSettingsURL() {
        return String.valueOf(UsernoteURLS.ACCOUNTSETTINGS_URL.getCompleteURL()) + "?token=" + this.getLoginToken();
    }

    private String getLoginToken() {
        if (this.signedIn) {
            if (this.loginToken != null) {
                return this.loginToken;
            }
            return this.getNewLoginToken();
        }
        return "";
    }

    private String getNewLoginToken() {
        HttpResponse response;
        block7: {
            HttpGet httpget = new HttpGet(UsernoteURLS.DOGETLOGINTOKEN_URL.getCompleteURL());
            httpget.setConfig(RequestConfig.custom().setCookieSpec("netscape").build());
            response = this.doRequest((HttpRequestBase)httpget);
            if (response != null) break block7;
            return "";
        }
        try {
            UsernoteResult result = new UsernoteResult();
            result.setStatus(response.getStatusLine().getStatusCode());
            result.setMessage(response.getStatusLine().getReasonPhrase());
            String jsonResponse = "";
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                int l;
                InputStream instream = entity.getContent();
                byte[] tmp = new byte[2048];
                StringBuffer buffer = new StringBuffer();
                while ((l = instream.read(tmp)) != -1) {
                    buffer.append(new String(tmp, 0, l, "UTF-8"));
                }
                instream.close();
                jsonResponse = buffer.toString();
            }
            if (jsonResponse.startsWith("{\"token\":\"")) {
                return jsonResponse.substring(10, jsonResponse.length() - 2);
            }
        }
        catch (ClientProtocolException e) {
            log.error((Object)"Error connecting to Usernote.", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error connecting to Usernote.", (Throwable)e);
        }
        return "";
    }

    public void initProxySettings(boolean socks) {
        if (this.proxy_host != null) {
            if (this.proxy_username != null && this.proxy_password != null) {
                NTCredentials creds = new NTCredentials(this.proxy_username, this.proxy_password, "", "");
                int domainIndex = this.proxy_username.indexOf("\\");
                if (domainIndex > 0) {
                    String domain = this.proxy_username.substring(0, domainIndex);
                    if (this.proxy_username.length() > domainIndex + 1) {
                        String user = this.proxy_username.substring(domainIndex + 1);
                        creds = new NTCredentials(user, this.proxy_password, "", domain);
                    }
                }
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(this.proxy_host, this.proxy_port), (Credentials)creds);
                this.context = HttpClientContext.create();
                this.context.setCredentialsProvider((CredentialsProvider)credsProvider);
                this.context.setAttribute("socks.address", (Object)new InetSocketAddress(this.proxy_host, this.proxy_port));
            } else {
                this.context = HttpClientContext.create();
                this.context.setAttribute("socks.address", (Object)new InetSocketAddress(this.proxy_host, this.proxy_port));
            }
            HttpHost proxy = new HttpHost(this.proxy_host, this.proxy_port);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            if (socks) {
                if (this.proxy_username != null && this.proxy_password != null) {
                    Authenticator.setDefault(new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(UsernoteClient.this.proxy_username, UsernoteClient.this.proxy_password.toCharArray());
                        }
                    });
                }
                MyConnectionSocketFactory plainsf = new MyConnectionSocketFactory();
                MySSLConnectionSocketFactory sslsf = new MySSLConnectionSocketFactory(this.sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
                BasicHttpClientConnectionManager socksConnManager = new BasicHttpClientConnectionManager((Lookup)registry);
                this.client = HttpClients.custom().setDefaultRequestConfig(this.config).setConnectionManager((HttpClientConnectionManager)socksConnManager).setDefaultCookieStore((CookieStore)new NonSecureCookieStore()).setUserAgent(userAgent).build();
            } else {
                Authenticator.setDefault(null);
                this.client = HttpClients.custom().setDefaultRequestConfig(this.config).setConnectionManager(this.connManager).setDefaultCookieStore((CookieStore)new NonSecureCookieStore()).setRoutePlanner((HttpRoutePlanner)routePlanner).setUserAgent(userAgent).build();
            }
        } else {
            this.buildBaseConnection();
        }
    }

    public String getProxy_host() {
        return this.proxy_host;
    }

    public void setProxy_host(String proxy_host) {
        this.proxy_host = proxy_host;
    }

    public int getProxy_port() {
        return this.proxy_port;
    }

    public void setProxy_port(int proxy_port) {
        this.proxy_port = proxy_port;
    }

    public String getProxy_username() {
        return this.proxy_username;
    }

    public void setProxy_username(String proxy_username) {
        this.proxy_username = proxy_username;
    }

    public String getProxy_password() {
        return this.proxy_password;
    }

    public void setProxy_password(String proxy_password) {
        this.proxy_password = proxy_password;
    }

    public UsernoteResult sendGetRequest(String URL2) throws FileNotFoundException, IOException {
        HttpGet httpget = new HttpGet(URL2);
        httpget.setConfig(RequestConfig.custom().setCookieSpec("netscape").build());
        HttpResponse response = this.doRequest((HttpRequestBase)httpget);
        if (response == null) {
            return this.returnConnectionErrorResult();
        }
        return this.getUsernoteResult(response);
    }

    public UsernoteResult sendPostRequest(String URL2, String xml, File attachment) throws FileNotFoundException, IOException {
        HttpPost httppost = new HttpPost(URL2);
        httppost.setConfig(RequestConfig.custom().setCookieSpec("netscape").build());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        try {
            builder.addPart("requestXML", (ContentBody)new StringBody(xml, ContentType.create((String)"text/plain", (String)"UTF-8")));
            if (attachment != null) {
                FileBody bin = new FileBody(attachment);
                builder.addPart("file", (ContentBody)bin);
            }
            httppost.setEntity(builder.build());
        }
        catch (Exception e) {
            log.error((Object)"Error in Usernote client: invalid parameter", (Throwable)e);
            UsernoteResult result = new UsernoteResult(-3, "Error in Usernote client: invalid parameter");
            return result;
        }
        httppost.setEntity(builder.build());
        HttpResponse response = this.doRequest((HttpRequestBase)httppost);
        if (response == null) {
            return this.returnConnectionErrorResult();
        }
        return this.getUsernoteResult(response);
    }

    private UsernoteResult getUsernoteResult(HttpResponse response) {
        UsernoteResult result = new UsernoteResult();
        result.setStatus(response.getStatusLine().getStatusCode());
        Object responseValue = "";
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                if (entity.getContentType() != null) {
                    if (entity.getContentType().getValue().equals("application/zip;charset=UTF-8")) {
                        responseValue = this.getZipFile(entity);
                    } else if (entity.getContentType().getValue().contains("text/xml")) {
                        responseValue = this.getStringResult(entity);
                    }
                } else {
                    responseValue = this.getStringResult(entity);
                }
                result.setResponse(responseValue);
            }
        }
        catch (IllegalStateException e) {
            log.error((Object)"Error in Usernote client: illegal state, probably response not consumed.", (Throwable)e);
            return this.returnConnectionErrorResult();
        }
        catch (IOException e) {
            log.error((Object)"Error connecting to Usernote.", (Throwable)e);
            return this.returnConnectionErrorResult();
        }
        this.setResponse(response, result, responseValue);
        try {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public UsernoteResult sendDeleteRequest(String URL2, String xml) throws FileNotFoundException, IOException {
        return this.sendPostRequest(URL2, xml, null);
    }

    private void setResponse(HttpResponse response, UsernoteResult result, Object responseValue) {
        if (response.getStatusLine().getStatusCode() == 500) {
            result.setStatus(-500);
            return;
        }
        if (response.getStatusLine().getStatusCode() == 302) {
            Header[] headerArray = response.getAllHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header h = headerArray[n2];
                if (h.getName().equalsIgnoreCase("location")) {
                    if (h.getValue().contains("accountExpired.action")) {
                        result.setStatus(-7);
                        return;
                    }
                    if (h.getValue().contains("trialExpired.action")) {
                        result.setStatus(-6);
                        return;
                    }
                }
                ++n2;
            }
            result.setStatus(-500);
            return;
        }
        if (response.getStatusLine().getStatusCode() == 400 || response.getStatusLine().getStatusCode() == 404) {
            result.setStatus(-400);
            return;
        }
        if (response.getStatusLine().getStatusCode() == 407) {
            result.setStatus(-407);
        } else {
            String[] errorCodes = new String[]{};
            if (responseValue instanceof String) {
                errorCodes = this.parseUsernoteClientErrors((String)responseValue);
            }
            if (errorCodes.length == 0) {
                result.setStatus(200);
                return;
            }
            UsernoteResult res = this.buildResultFromUsernoteErrorCode(errorCodes[0]);
            result.setResponse(res.getResponse());
            result.setStatus(res.getStatus());
        }
    }

    private String getStringResult(HttpEntity entity) throws IllegalStateException, IOException {
        int l;
        InputStream instream = entity.getContent();
        byte[] tmp = new byte[2048];
        StringBuffer buffer = new StringBuffer();
        while ((l = instream.read(tmp)) != -1) {
            buffer.append(new String(tmp, 0, l, "UTF-8"));
        }
        instream.close();
        return buffer.toString();
    }

    private File getZipFile(HttpEntity entity) throws IllegalStateException, IOException {
        int bytesRead;
        FileOutputStream outStream = new FileOutputStream(String.valueOf(UsernoteClient.getTempDir()) + File.separator + "response.zip");
        InputStream instream = entity.getContent();
        BufferedOutputStream bos = new BufferedOutputStream(outStream);
        byte[] buff = new byte[2048];
        while ((bytesRead = instream.read(buff, 0, buff.length)) > 0) {
            bos.write(buff, 0, bytesRead);
        }
        bos.flush();
        bos.close();
        instream.close();
        return new File(String.valueOf(UsernoteClient.getTempDir()) + File.separator + "response.zip");
    }

    private static final String getTempDir() {
        File tempDirFile;
        String tempdir = System.getProperty("java.io.tmpdir");
        if (!tempdir.endsWith(File.separator)) {
            tempdir = String.valueOf(tempdir) + File.separator;
        }
        if (!(tempDirFile = new File(tempdir = String.valueOf(tempdir) + "Justinmind Prototyper")).exists()) {
            tempDirFile.mkdirs();
        }
        return tempdir;
    }

    public String getUsernoteRootURL() {
        return this.usernoteRootURL;
    }

    public void setUsernoteRootURL(String url) {
        this.usernoteRootURL = url.endsWith("/") ? url : String.valueOf(url) + "/";
    }

    public void reset() {
        this.username = null;
        this.password = null;
        this.signedIn = false;
    }

    public static class MyConnectionSocketFactory
    implements ConnectionSocketFactory {
        public Socket createSocket(HttpContext context) throws IOException {
            InetSocketAddress socksaddr = (InetSocketAddress)context.getAttribute("socks.address");
            Proxy proxy = new Proxy(Proxy.Type.SOCKS, socksaddr);
            return new Socket(proxy);
        }

        public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            Socket sock1 = sock != null ? sock : this.createSocket(context);
            if (localAddress != null) {
                sock1.bind(localAddress);
            }
            try {
                sock1.connect(remoteAddress, connectTimeout);
            }
            catch (SocketTimeoutException ex) {
                throw new ConnectTimeoutException((IOException)ex, host, new InetAddress[]{remoteAddress.getAddress()});
            }
            return sock1;
        }
    }

    public static class MySSLConnectionSocketFactory
    extends SSLConnectionSocketFactory {
        public MySSLConnectionSocketFactory(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
            super(sslContext, hostnameVerifier);
        }

        public MySSLConnectionSocketFactory(SSLContext sslContext) {
            super(sslContext);
        }

        public Socket createSocket(HttpContext context) throws IOException {
            InetSocketAddress socksaddr = (InetSocketAddress)context.getAttribute("socks.address");
            Proxy proxy = new Proxy(Proxy.Type.SOCKS, socksaddr);
            return new Socket(proxy);
        }
    }
}

