/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.osutils.fonts;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public abstract class EVCFontData {
    protected FontData fontData;
    protected String styleName;

    public EVCFontData(FontData fontData, String styleName) {
        this.fontData = fontData;
        this.styleName = styleName;
    }

    public abstract int getWeight();

    public abstract long getTraits();

    public abstract boolean isItalic();

    public abstract boolean isBold();

    public abstract boolean isValidCharset();

    public abstract boolean haveSameStyle(String var1, int var2, byte var3, Font var4);

    public abstract boolean isRegular();

    public FontData getFontData() {
        return this.fontData;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public String getFontFileName() {
        if (this.getFontData() == null) {
            return "";
        }
        return String.valueOf(this.getFontData().getName()) + "-" + this.getStyleName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EVCFontData)) {
            return false;
        }
        EVCFontData evcFontData = (EVCFontData)obj;
        return evcFontData.getFontData().getName().equals(this.getFontData().getName()) && evcFontData.getStyleName().equals(this.getStyleName()) && evcFontData.getWeight() == this.getWeight() && evcFontData.getTraits() == this.getTraits();
    }
}

