/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.osutils.fonts;

import com.justinmind.osutils.fonts.EVCFontData;
import com.justinmind.osutils.fonts.LogFontData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class FontOSUtils {
    public static List<EVCFontData> getFontList() {
        ArrayList<EVCFontData> evcFontDataList = new ArrayList<EVCFontData>();
        List<FontData> displayFontDataList = Arrays.asList(Display.getDefault().getFontList(null, true));
        for (FontData fontData : displayFontDataList) {
            LogFontData evcFontData = new LogFontData(fontData, LogFontData.getFontStyleName(fontData.data.lfWeight, fontData.data.lfItalic != 0));
            evcFontDataList.add(evcFontData);
        }
        return evcFontDataList;
    }

    public static FontData copyFontData(FontData source) {
        FontData clone = new FontData();
        clone.data.lfCharSet = source.data.lfCharSet;
        clone.data.lfClipPrecision = source.data.lfClipPrecision;
        clone.data.lfEscapement = source.data.lfEscapement;
        clone.data.lfHeight = source.data.lfHeight;
        clone.data.lfItalic = source.data.lfItalic;
        clone.data.lfOrientation = source.data.lfOrientation;
        clone.data.lfOutPrecision = source.data.lfOutPrecision;
        clone.data.lfPitchAndFamily = source.data.lfPitchAndFamily;
        clone.data.lfQuality = source.data.lfQuality;
        clone.data.lfStrikeOut = source.data.lfStrikeOut;
        clone.data.lfUnderline = source.data.lfUnderline;
        clone.data.lfWeight = source.data.lfWeight;
        clone.data.lfWidth = source.data.lfWidth;
        clone.setLocale(source.getLocale());
        clone.setName(source.getName());
        return clone;
    }

    public static TreeMap<Float, EVCFontData> getMapStyles(List<EVCFontData> fontDataList, String family) {
        TreeMap<Float, EVCFontData> mapStyles = new TreeMap<Float, EVCFontData>();
        if (fontDataList != null) {
            for (EVCFontData evcFontData : fontDataList) {
                int weight = evcFontData.getWeight();
                long traits = evcFontData.getTraits();
                float key = (float)weight + (float)traits / 100.0f;
                mapStyles.put(Float.valueOf(key), evcFontData);
            }
        }
        return mapStyles;
    }

    public static int getFontWeight(FontData fontData) {
        return fontData.data.lfWeight;
    }

    public static byte getFontItalic(FontData fontData) {
        return fontData.data.lfItalic;
    }
}

