/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.osutils.fonts;

import com.justinmind.osutils.fonts.EVCFontData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class LogFontData
extends EVCFontData {
    public LogFontData(FontData fontData, String styleName) {
        super(fontData, styleName);
    }

    @Override
    public int getWeight() {
        return this.fontData.data.lfWeight;
    }

    @Override
    public long getTraits() {
        return this.isItalic() ? 1 : 0;
    }

    @Override
    public boolean isItalic() {
        return this.fontData.data.lfItalic != 0;
    }

    @Override
    public boolean isBold() {
        return this.getWeight() >= 700;
    }

    @Override
    public boolean isValidCharset() {
        return true;
    }

    @Override
    public boolean haveSameStyle(String fontFamily, int weight, byte italic, Font f) {
        return fontFamily.equals(this.fontData.getName()) && weight == this.getWeight() && italic == this.fontData.data.lfItalic;
    }

    public static int getRegularWeight() {
        return 400;
    }

    @Override
    public boolean isRegular() {
        return this.getWeight() == LogFontData.getRegularWeight();
    }

    protected static String getFontStyleName(int weight, boolean italic) {
        switch (weight) {
            case 900: {
                return "Black" + (italic ? " Italic" : "");
            }
            case 800: {
                return "ExtraBold" + (italic ? " Italic" : "");
            }
            case 700: {
                return "Bold" + (italic ? " Italic" : "");
            }
            case 600: {
                return "SemiBold" + (italic ? " Italic" : "");
            }
            case 500: {
                return "Medium" + (italic ? " Italic" : "");
            }
            case 300: {
                return "Light" + (italic ? " Italic" : "");
            }
            case 200: {
                return "UltraLight" + (italic ? " Italic" : "");
            }
            case 100: {
                return "Thin" + (italic ? " Italic" : "");
            }
        }
        return italic ? "Italic" : "Regular";
    }
}

