/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.osutils.fonts;

import com.justinmind.osutils.fonts.EVCFontData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class NSFontData
extends EVCFontData {
    private int weight;
    private long traits;
    private String nsName;

    public NSFontData(FontData fontData, String nsName, String styleName, int weight, long traits) {
        super(fontData, styleName);
        this.weight = weight;
        this.traits = traits;
        this.nsName = nsName;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public long getTraits() {
        return this.traits;
    }

    @Override
    public boolean isItalic() {
        return false;
    }

    @Override
    public boolean isBold() {
        return this.getWeight() >= 9;
    }

    @Override
    public boolean isValidCharset() {
        return true;
    }

    @Override
    public boolean haveSameStyle(String fontFamily, int weight, byte italic, Font f) {
        return false;
    }

    public static int getRegularWeight() {
        return 5;
    }

    @Override
    public boolean isRegular() {
        return this.getWeight() == NSFontData.getRegularWeight();
    }

    @Override
    public String getFontFileName() {
        if (this.nsName != null) {
            return this.nsName;
        }
        return super.getFontFileName();
    }
}

