/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.application;

import com.justinmind.generator.application.review.TestScript;
import com.justinmind.generator.engine.Paths;
import com.justinmind.prototyper.api.IPrototype;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import com.justinmind.prototyper.api.ui.simulation.SimulationDevice;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class ApplicationContext {
    private final transient IPrototype prototype;
    private final transient Boolean optimize;
    private final transient Paths paths;
    private final transient Map<PropertyType, Object> properties;
    private final transient ApplicationType type;
    private transient ICanvas initialCanvas;
    private transient TestScript testScript;
    private transient TimeZone timeZone;
    private transient Locale locale;
    private transient Long time;
    private transient Boolean mobile;
    private transient Boolean test;

    public ApplicationContext(IPrototype prototype, Boolean optimize, Paths paths, Map<PropertyType, Object> properties, ApplicationType type, boolean test) {
        this.prototype = prototype;
        this.optimize = optimize;
        this.mobile = !prototype.getApiSimulationSettings().getApiSimulationDevice().equals((Object)SimulationDevice.WEB);
        this.paths = paths;
        this.properties = properties;
        this.type = type;
        this.time = new Date().getTime();
        this.timeZone = TimeZone.getDefault();
        this.locale = Locale.getDefault();
        this.test = test;
    }

    public IPrototype getPrototype() {
        return this.prototype;
    }

    public Boolean getOptimize() {
        return this.optimize;
    }

    public Boolean isMobile() {
        return this.mobile;
    }

    public void setMobile(Boolean isMobile) {
        this.mobile = isMobile;
    }

    public void setTest(Boolean test) {
        this.test = test;
    }

    public Boolean isTest() {
        return this.test;
    }

    public Paths getPaths() {
        return this.paths;
    }

    public Map<PropertyType, Object> getProperties() {
        return this.properties;
    }

    public ApplicationType getApplicationType() {
        return this.type;
    }

    public ICanvas getInitialCanvas() {
        return this.initialCanvas;
    }

    public void setInitialCanvas(ICanvas initialCanvas) {
        this.initialCanvas = initialCanvas;
    }

    public TestScript getTestScript() {
        return this.testScript;
    }

    public void setTestScript(TestScript testScript) {
        this.testScript = testScript;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Long getTime() {
        return this.time;
    }

    public void setTime() {
        this.time = new Date().getTime();
    }

    public static enum ApplicationType {
        REVIEW,
        SIMULATION;


        public static ApplicationType getType(String value) {
            ApplicationType type;
            try {
                type = ApplicationType.valueOf(value.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                type = REVIEW;
            }
            return type;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum PropertyType {
        APPENDJS,
        COMMENTABLE,
        COMPRESSHTML,
        PRETTIFY,
        SHOWSIDEPANEL,
        SHOWTOPPANEL;

    }
}

