/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.application.review;

import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.application.review.ReviewPaths;
import com.justinmind.generator.application.review.ReviewPostProcess;
import com.justinmind.generator.application.review.TestScript;
import com.justinmind.generator.context.ContextController;
import com.justinmind.generator.context.css.CssController;
import com.justinmind.generator.context.css.CssControllerIE;
import com.justinmind.generator.context.css.CssControllerIE8;
import com.justinmind.generator.context.css.CssScaleController;
import com.justinmind.generator.context.css.FontController;
import com.justinmind.generator.context.data.DataController;
import com.justinmind.generator.context.event.EventController;
import com.justinmind.generator.context.externaltools.ExternalToolsController;
import com.justinmind.generator.context.htmlwidget.HtmlWidgetController;
import com.justinmind.generator.context.include.IncludeController;
import com.justinmind.generator.context.json.JsonController;
import com.justinmind.generator.context.lookup.LookUpController;
import com.justinmind.generator.context.mobile.MobileController;
import com.justinmind.generator.context.scale.ScaleController;
import com.justinmind.generator.context.scenarios.ScenarioController;
import com.justinmind.generator.context.view.ViewControllerReview;
import com.justinmind.generator.engine.Generator;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.Paths;
import com.justinmind.generator.engine.PostProcess;
import com.justinmind.prototyper.api.IPrototype;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class ReviewGenerator
extends Generator {
    public ReviewGenerator(IPrototype prototype, String installPath, String outputPath, Boolean optimize, TimeZone timezone, Locale locale, Boolean test) {
        super(prototype, installPath, outputPath, optimize, test);
        this.getContext().setTimeZone(timezone);
        this.getContext().setLocale(locale);
    }

    public void startGeneration(TestScript testScript) throws GeneratorException {
        this.getContext().setTestScript(testScript);
        this.startGeneration(false);
    }

    public void startGeneration(Boolean showSidePanel) throws GeneratorException {
        this.getContext().getProperties().put(ApplicationContext.PropertyType.SHOWSIDEPANEL, showSidePanel);
        super.startGeneration();
    }

    public void createCommentJSON() throws GeneratorException {
        JsonController controller = new JsonController(this.getContext());
        controller.generate();
    }

    @Override
    protected Map<ApplicationContext.PropertyType, Object> getProperties(Boolean optimize) {
        HashMap<ApplicationContext.PropertyType, Object> properties = new HashMap<ApplicationContext.PropertyType, Object>();
        properties.put(ApplicationContext.PropertyType.APPENDJS, optimize);
        properties.put(ApplicationContext.PropertyType.COMMENTABLE, true);
        properties.put(ApplicationContext.PropertyType.COMPRESSHTML, optimize);
        properties.put(ApplicationContext.PropertyType.SHOWSIDEPANEL, true);
        properties.put(ApplicationContext.PropertyType.SHOWTOPPANEL, false);
        properties.put(ApplicationContext.PropertyType.PRETTIFY, true);
        return properties;
    }

    @Override
    protected List<ContextController> getContextControllers(ApplicationContext context) {
        ArrayList<ContextController> controllers = new ArrayList<ContextController>(8);
        controllers.add(new CssController(context));
        controllers.add(new CssControllerIE(context));
        controllers.add(new CssControllerIE8(context));
        controllers.add(new CssScaleController(context));
        controllers.add(new ScaleController(context));
        controllers.add(new FontController(context));
        controllers.add(new DataController(context));
        controllers.add(new EventController(context));
        controllers.add(new HtmlWidgetController(context));
        controllers.add(new JsonController(context));
        controllers.add(new LookUpController(context));
        controllers.add(new IncludeController(context));
        controllers.add(new ViewControllerReview(context));
        controllers.add(new MobileController(context));
        controllers.add(new ExternalToolsController(context));
        controllers.add(new ScenarioController(context));
        return controllers;
    }

    @Override
    protected ApplicationContext.ApplicationType getType() {
        return ApplicationContext.ApplicationType.REVIEW;
    }

    @Override
    protected Paths getPaths(String prototoypePath, String installPath, String outputPath) {
        return new ReviewPaths(prototoypePath, installPath, outputPath);
    }

    @Override
    protected PostProcess buildPostProcess(ApplicationContext context) {
        return new ReviewPostProcess(context.getPrototype(), context.getOptimize(), context.getPaths());
    }
}

