/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context;

import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.engine.Generator;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.Paths;
import com.justinmind.generator.engine.output.OutputEngine;
import com.justinmind.generator.engine.output.OutputStrategy;
import com.justinmind.generator.engine.output.StandardStrategy;
import com.justinmind.prototyper.api.IPrototype;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.misc.STMessage;

public abstract class ContextController {
    protected final transient ApplicationContext applicationContext;
    protected final transient OutputEngine outputEngine;
    protected final transient IPrototype prototype;
    protected final transient Paths paths;
    protected final transient Boolean optimize;
    protected final transient STGroup group;
    protected transient OutputStrategy strategy;

    public ContextController(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.outputEngine = new OutputEngine();
        this.prototype = applicationContext.getPrototype();
        this.paths = applicationContext.getPaths();
        this.optimize = applicationContext.getOptimize();
        this.group = this.initGroup();
        this.strategy = this.getOutputStrategy();
    }

    protected abstract String getGroupURL();

    public abstract void generate() throws GeneratorException;

    protected OutputStrategy getOutputStrategy() {
        Object prettifyProperty = this.applicationContext.getProperties().get((Object)ApplicationContext.PropertyType.PRETTIFY);
        Boolean prettify = prettifyProperty instanceof Boolean ? (Boolean)prettifyProperty : true;
        return new StandardStrategy(prettify);
    }

    private STGroup initGroup() {
        STGroupFile stGroup = null;
        String groupURL = this.getGroupURL();
        if (groupURL.length() > 0) {
            stGroup = new STGroupFile(groupURL, '$', '$');
            stGroup.setListener((STErrorListener)new STGenerationErrorListener());
        }
        return stGroup;
    }

    private class STGenerationErrorListener
    implements STErrorListener {
        private STGenerationErrorListener() {
        }

        public void compileTimeError(STMessage msg) {
            this.log(msg);
        }

        public void runTimeError(STMessage msg) {
            Throwable cause = msg.cause;
            msg.cause = null;
            this.log(msg);
            msg.cause = cause;
        }

        public void IOError(STMessage msg) {
            this.log(msg);
        }

        public void internalError(STMessage msg) {
            this.log(msg);
        }

        private void log(STMessage msg) {
            Generator.LOG.error((Object)msg.toString());
        }
    }
}

