/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context;

import com.justinmind.generator.engine.Generator;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ContextModel {
    public static final List<String> RESERVED_KEYS = Collections.unmodifiableList(Arrays.asList("true", "false", "import", "default", "key", "group", "implements", "first", "last", "rest", "trunc", "strip", "trim", "length", "strlen", "reverse", "if", "else", "elseif", "endif", "delimiters"));

    protected ContextModel() {
        this.validate();
    }

    private Boolean validate() {
        Boolean isValid = true;
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String fieldName = field.getName();
            if (RESERVED_KEYS.contains(fieldName)) {
                Generator.LOG.info((Object)("reserved key '" + fieldName + "' is not allowed"));
                isValid = false;
                break;
            }
            ++n2;
        }
        return isValid;
    }

    protected Boolean isValid(String key) {
        Boolean isValid = true;
        if (RESERVED_KEYS.contains(key)) {
            Generator.LOG.info((Object)("reserved key '" + key + "' is not allowed"));
            isValid = false;
        }
        return isValid;
    }
}

