/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context;

import com.justinmind.generator.engine.modeladaptor.TypeAdaptor;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import com.justinmind.prototyper.api.ui.component.ICellContainer;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.component.ILayout;
import com.justinmind.prototyper.api.ui.component.IPanel;
import com.justinmind.prototyper.api.ui.component.IRootComponent;
import com.justinmind.prototyper.api.ui.event.ITarget;
import com.justinmind.siteXmlDef.Igu.model.AbstractModel;
import java.util.Locale;

public final class ControllerUtils {
    public static final String EXT_CSS = ".css";
    public static final String EXT_CSSIE = "-ie.css";
    public static final String EXT_CSSIE8 = "-ie8.css";
    public static final String EXT_JS = ".js";

    private ControllerUtils() {
    }

    public static String getName(ITarget target) {
        StringBuilder name = new StringBuilder();
        if (target != null) {
            switch (TypeAdaptor.getComponentType(target)) {
                case SCREEN: 
                case TEMPLATE: 
                case MASTER: {
                    name.append(((ICanvas)target).getApiName());
                    break;
                }
                case FLASH: 
                case WEBSITE: 
                case URL: 
                case HTML: 
                case DOCUMENT: {
                    IComponent browser = (IComponent)target;
                    name.append(ControllerUtils.getName((ITarget)browser.getApiCanvas()));
                    name.append("_");
                    name.append(ControllerUtils.getID(browser));
                    name.append(".html");
                    break;
                }
                case FIELD: {
                    String escapedName = target.getApiId();
                    if (escapedName.contains("\"")) {
                        escapedName = escapedName.replaceAll("\"", "\\\\\"");
                        escapedName = escapedName.replaceAll("'", "\\\\'");
                    }
                    name.append(escapedName);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    name.append(target.getApiId());
                }
            }
        }
        return name.toString();
    }

    public static String getID(IComponent component) {
        StringBuilder identity = new StringBuilder();
        if (component != null) {
            switch (TypeAdaptor.getComponentType((ITarget)component.getApiCanvas())) {
                case SCREEN: {
                    identity.append("s-");
                    break;
                }
                case TEMPLATE: {
                    identity.append("t-");
                    break;
                }
                case MASTER: {
                    if (TypeAdaptor.getComponentType((ITarget)component) == TypeAdaptor.ComponentType.ROOTCOMPONENT || TypeAdaptor.getComponentType((ITarget)component) == TypeAdaptor.ComponentType.MASTER) {
                        identity.append("m-");
                        break;
                    }
                    identity.append("m-" + ((AbstractModel)component.getApiCanvas()).getUuid().substring(0, 8) + "-");
                    break;
                }
            }
            if (component.getApiId() == null) {
                identity.append(((AbstractModel)component).getUuid().substring(0, 8));
            } else {
                identity.append(component.getApiId());
            }
        }
        return identity.toString();
    }

    public static String typeToString(Enum<?> type) {
        return type.toString().toLowerCase(Locale.ENGLISH).replaceFirst("on_", "").replaceAll("_", "");
    }

    public static String normalizeEffectType(Enum<?> type) {
        String sType = ControllerUtils.typeToString(type);
        if (sType.startsWith("slide")) {
            return "slide";
        }
        return sType;
    }

    public static ILayout getLayout(IComponent component) {
        ILayout layout = null;
        if (component instanceof IRootComponent) {
            layout = ((IRootComponent)component).getApiLayout();
        } else if (component instanceof IPanel) {
            layout = ((IPanel)component).getApiLayout();
        } else if (component instanceof ICellContainer) {
            layout = ((ICellContainer)component).getApiLayout();
        } else {
            IComponent parent = component.getApiParent();
            if (parent != null) {
                layout = ControllerUtils.getLayout(parent);
            }
        }
        return layout;
    }
}

