/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.css;

import com.justinmind.evc.model.EVCPoint;
import com.justinmind.evc.model.actions.AttributeForm;
import com.justinmind.evc.model.actions.Callout;
import com.justinmind.evc.model.actions.EVCImage;
import com.justinmind.evc.model.actions.navigationComponents.NavigationTree;
import com.justinmind.evc.model.customComponents.CustomComponent;
import com.justinmind.evc.model.lookAndFeel.CssStyle;
import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ContextController;
import com.justinmind.generator.context.ControllerUtils;
import com.justinmind.generator.context.css.CssControllerUtils;
import com.justinmind.generator.context.css.CssRule;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.Paths;
import com.justinmind.generator.engine.modeladaptor.TypeAdaptor;
import com.justinmind.prototyper.api.ui.IStyle;
import com.justinmind.prototyper.api.ui.StyleProperty;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import com.justinmind.prototyper.api.ui.canvas.IMaster;
import com.justinmind.prototyper.api.ui.component.ICell;
import com.justinmind.prototyper.api.ui.component.ICellContainer;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.component.IDataCell;
import com.justinmind.prototyper.api.ui.component.IDataGridCell;
import com.justinmind.prototyper.api.ui.component.IDataList;
import com.justinmind.prototyper.api.ui.component.IImage;
import com.justinmind.prototyper.api.ui.component.ILayout;
import com.justinmind.prototyper.api.ui.component.IMasterInstance;
import com.justinmind.prototyper.api.ui.component.IMenuNode;
import com.justinmind.prototyper.api.ui.component.IPanel;
import com.justinmind.prototyper.api.ui.component.IRichText;
import com.justinmind.prototyper.api.ui.component.IRootComponent;
import com.justinmind.prototyper.api.ui.component.ISelect;
import com.justinmind.prototyper.api.ui.component.IShape;
import com.justinmind.prototyper.api.ui.component.ITextCell;
import com.justinmind.prototyper.api.ui.component.ITextComponent;
import com.justinmind.prototyper.api.ui.component.ITextRange;
import com.justinmind.prototyper.api.ui.component.ITree;
import com.justinmind.prototyper.api.ui.component.ITreeNode;
import com.justinmind.prototyper.api.ui.event.ITarget;
import com.justinmind.prototyper.api.ui.simulation.SimulationDevice;
import com.justinmind.util.datamanage.Utils;
import java.util.ArrayList;
import java.util.List;
import org.stringtemplate.v4.ST;

public class CssController
extends ContextController {
    private static final String GROUP_URL = "com/justinmind/generator/context/css/CssView.stg";
    private static final String TEMPLATE = "Css";
    private static final String EXTENSION = ".css";
    protected static final String[] svgTypes = new String[]{"path", "rect", "circle", "ellipse", "line", "polyline", "polygon", "use"};
    protected static final String RULES = "rules";
    protected static final String VALIGN = " .valign";
    protected static final String TEXTCONTENT = " .content";
    protected static final String SHAPECLIP = " .shapert-clipping";
    protected static final String COL = " col";
    protected static final String LAYOUT = " .layout";
    protected static final String VERTICAL_ALIGN = " .verticalalign";
    protected static final String NODECONTENT = "-nodecontent";
    protected static final String NODEICON = "-nodeicon";
    protected static final String NODESUBICON = "-nodesubicon";
    protected static final String NODETEXT = "-nodetext";
    protected static final String OPTIONS = "-options";
    protected static final String ICON = " .icon";
    protected static final String SPAN = " span";
    protected static final String CELL = " td";
    protected static final String INPUT = " input";
    protected static final String OPTION = " .option";
    protected static final String ODDROW = " tr.odd";
    protected static final String EVENROW = " tr.even";
    protected static final String MASTERINSTANCE_SELECTOR = ".masterinstance";
    public static final String ID_SELECTOR = "#";
    public static final String CLASS_SELECTOR = ".";
    private final transient List<ICell> cellCache = new ArrayList<ICell>();
    protected final transient CssControllerUtils utils;

    public CssController(ApplicationContext applicationContext) {
        super(applicationContext);
        this.utils = this.createCssControllerUtils(applicationContext);
    }

    protected CssControllerUtils createCssControllerUtils(ApplicationContext applicationContext) {
        return new CssControllerUtils(applicationContext);
    }

    protected CssControllerUtils getControllerUtils() {
        return this.utils;
    }

    @Override
    protected String getGroupURL() {
        return GROUP_URL;
    }

    @Override
    public void generate() throws GeneratorException {
        for (ICanvas canvas : this.prototype.getApiCanvases()) {
            IRootComponent root = canvas.getApiRoot();
            List<CssRule> cssRules = this.processCssRules((IComponent)root, root.getApiStyle(), true);
            String fileName = Paths.getCanvasOutput(this.paths.output, canvas, this.applicationContext.getTime()).append(this.getExtension()).toString();
            ST context = this.group.getInstanceOf(TEMPLATE);
            if (!cssRules.isEmpty()) {
                context.add(RULES, cssRules);
            }
            if (TypeAdaptor.getComponentType((ITarget)canvas).equals((Object)TypeAdaptor.ComponentType.SCREEN)) {
                ArrayList<CssRule> pageScrollRules = new ArrayList<CssRule>();
                if (this.applicationContext.isMobile().booleanValue()) {
                    pageScrollRules.add(new CssRule("#jim-container .ui-page"));
                    pageScrollRules.add(new CssRule(".non_jim_mobile #simulation"));
                } else {
                    pageScrollRules.add(new CssRule("#simulation"));
                }
                for (CssRule pageScrollRule : pageScrollRules) {
                    if (canvas.getApiCanvasBackgroundGrowth().equals((Object)ICanvas.ApiCanvasBackgroundGrowth.NONE)) {
                        pageScrollRule.add(StyleProperty.OVERFLOW, "hidden");
                        context.add(RULES, (Object)pageScrollRule);
                        continue;
                    }
                    if (canvas.getApiCanvasBackgroundGrowth().equals((Object)ICanvas.ApiCanvasBackgroundGrowth.VERTICAL)) {
                        pageScrollRule.add(StyleProperty.OVERFLOW_X, "hidden");
                        context.add(RULES, (Object)pageScrollRule);
                        continue;
                    }
                    if (!canvas.getApiCanvasBackgroundGrowth().equals((Object)ICanvas.ApiCanvasBackgroundGrowth.HORIZONTAL)) continue;
                    pageScrollRule.add(StyleProperty.OVERFLOW_Y, "hidden");
                    context.add(RULES, (Object)pageScrollRule);
                }
            }
            CssRule markRule = new CssRule(String.valueOf(this.utils.getSelector((IComponent)root)) + " > #loadMark");
            markRule.add(StyleProperty.WIDTH, "1px");
            markRule.add(StyleProperty.VISIBILITY, "hidden");
            markRule.add(StyleProperty.DISPLAY, "none");
            context.add(RULES, (Object)markRule);
            this.outputEngine.write(fileName, context, this.strategy);
        }
        this.clearCache();
    }

    public List<CssRule> processCssRules(IComponent component, IStyle style, Boolean isNoEventRule) {
        this.utils.setIsNoEventRule(isNoEventRule);
        ArrayList<CssRule> rules = new ArrayList<CssRule>();
        String identity = ControllerUtils.getID(component);
        String selector = this.utils.getSelector(component);
        TypeAdaptor.ComponentType type = TypeAdaptor.getComponentType((ITarget)component);
        CssRule itemCon = new CssRule(selector);
        block0 : switch (type) {
            case ROOTCOMPONENT: {
                ICanvas canvas = ((IRootComponent)component).getApiCanvas();
                switch (TypeAdaptor.getComponentType((ITarget)canvas)) {
                    case SCREEN: 
                    case TEMPLATE: {
                        CssRule backgroundRule = new CssRule(String.valueOf(selector) + " > #backgroundBox");
                        this.utils.setBackground(backgroundRule, style, component);
                        this.utils.setOpacity(backgroundRule, style);
                        backgroundRule.add(StyleProperty.POSITION, "absolute");
                        this.addRule(rules, backgroundRule);
                        if (!isNoEventRule.booleanValue()) break block0;
                        CssRule alignmentRule = new CssRule(String.valueOf(selector) + " > #alignmentBox");
                        this.utils.setCanvasAlignment(alignmentRule, canvas);
                        rules.add(alignmentRule);
                        rules.addAll(this.processChildren(component, isNoEventRule));
                        break block0;
                    }
                    case MASTER: {
                        this.utils.setOpacity(itemCon, style);
                        this.addRule(rules, itemCon);
                        if (!isNoEventRule.booleanValue()) break block0;
                        rules.addAll(this.processChildren(component, isNoEventRule));
                        break block0;
                    }
                }
                break;
            }
            case IMAGE: {
                if (((IImage)component).getApiValue().endsWith(".svg") || !isNoEventRule.booleanValue()) {
                    rules.addAll(this.createSVGRule(itemCon, style, selector, isNoEventRule == false));
                }
            }
            case IMAGEMAP: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                this.addRule(rules, itemCon);
                break;
            }
            case MENU: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                this.addRule(rules, itemCon);
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case MENUNODE: {
                if (Utils.hasParent((IComponent)component, CustomComponent.class).booleanValue() && Utils.hasParent((IComponent)component, IMenuNode.class).booleanValue()) {
                    itemCon.setSelector("[masteritem=" + ControllerUtils.getID((IComponent)component.getApiCanvas().getApiRoot()) + "] " + ID_SELECTOR + identity);
                }
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                this.utils.removePositionAttributes(itemCon);
                this.utils.setVerticalAlignment(itemCon, style);
                itemCon.add(StyleProperty.TEXT_ALIGN, style.getProperty(StyleProperty.TEXT_ALIGN));
                if (isNoEventRule.booleanValue()) {
                    this.utils.removeDimensionAttributes(itemCon);
                }
                this.addRule(rules, itemCon);
                CssRule nodeText = Utils.hasParent((IComponent)component, CustomComponent.class) != false && Utils.hasParent((IComponent)component, IMenuNode.class) != false ? new CssRule("[masteritem=" + ControllerUtils.getID((IComponent)component.getApiCanvas().getApiRoot()) + "] " + ID_SELECTOR + identity + NODETEXT) : new CssRule(String.valueOf(selector) + NODETEXT);
                this.utils.setText(nodeText, style);
                this.addRule(rules, nodeText);
                if (this.applicationContext.isMobile().booleanValue() || !isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case TREE: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                this.addRule(rules, itemCon);
                if (!isNoEventRule.booleanValue()) break;
                ITree tree = (ITree)component;
                CssRule treeLine = new CssRule(String.valueOf(selector) + " li");
                CssRule lastLI = new CssRule(String.valueOf(selector) + " li.last");
                CssRule openLI = new CssRule(String.valueOf(selector) + " li.open td.treeicon");
                CssRule closedLI = new CssRule(String.valueOf(selector) + " li.closed td.treeicon");
                CssRule treeLeaf = new CssRule(String.valueOf(selector) + " li.leaf table td.treeicon");
                CssRule treeLastLeaf = new CssRule(String.valueOf(selector) + " li.last.leaf td.treeicon");
                CssRule openSubTree = new CssRule(String.valueOf(selector) + " li.open ul");
                CssRule closedSubTree = new CssRule(String.valueOf(selector) + " li.closed ul");
                String expandIconPath = tree.getApiExpandIcon();
                String collapseIconPath = tree.getApiCollapseIcon();
                Integer padLeftTreeLine = 7;
                if (tree.getApiExpandIcon() != null) {
                    padLeftTreeLine = Math.round((float)((NavigationTree)tree).getExpandableImage().getWidth() / 2.0f);
                }
                if (tree.showApiLines().booleanValue()) {
                    treeLine.add(StyleProperty.BACKGROUND_POSITION, padLeftTreeLine + "px 0px");
                    lastLI.add(StyleProperty.BACKGROUND_POSITION, padLeftTreeLine + "px 0px");
                    treeLeaf.add(StyleProperty.BACKGROUND_POSITION, padLeftTreeLine + "px center");
                    treeLeaf.add(StyleProperty.WIDTH, String.valueOf(2 * padLeftTreeLine) + "px");
                    treeLastLeaf.add(StyleProperty.WIDTH, String.valueOf(2 * padLeftTreeLine) + "px");
                }
                if (expandIconPath != null) {
                    EVCImage expandImg = ((NavigationTree)tree).getExpandableImage();
                    closedLI.add(StyleProperty.BACKGROUND, "transparent " + this.utils.getBackgroundImageRule(Paths.getImagePath(this.utils.getImagePathPrefix(), expandIconPath)) + " no-repeat top center scroll");
                    closedLI.add(StyleProperty.HEIGHT, String.valueOf(expandImg.getHeight()) + "px");
                    closedLI.add(StyleProperty.WIDTH, String.valueOf(expandImg.getWidth()) + "px");
                }
                if (collapseIconPath != null) {
                    EVCImage collapseImg = ((NavigationTree)tree).getCollapsableImage();
                    openLI.add(StyleProperty.BACKGROUND, "transparent " + this.utils.getBackgroundImageRule(Paths.getImagePath(this.utils.getImagePathPrefix(), collapseIconPath)) + " no-repeat top center scroll");
                    openLI.add(StyleProperty.HEIGHT, String.valueOf(collapseImg.getHeight()) + "px");
                    openLI.add(StyleProperty.WIDTH, String.valueOf(collapseImg.getWidth()) + "px");
                }
                openSubTree.add(StyleProperty.PADDING_LEFT, String.valueOf(2 * padLeftTreeLine) + "px");
                this.addRule(rules, treeLine);
                this.addRule(rules, lastLI);
                this.addRule(rules, openLI);
                this.addRule(rules, closedLI);
                this.addRule(rules, treeLeaf);
                this.addRule(rules, treeLastLeaf);
                this.addRule(rules, openSubTree);
                this.addRule(rules, closedSubTree);
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case TREENODE: {
                this.utils.setOpacity(itemCon, style);
                this.utils.setHidden(itemCon, component);
                this.utils.setCursor(itemCon, component);
                ITreeNode node = (ITreeNode)component;
                ITree parentTree = node.getApiTree();
                Integer expandIconHeight = 0;
                Integer collapseIconHeight = 0;
                if (parentTree.getApiExpandIcon() != null && !node.getApiChildren().isEmpty()) {
                    expandIconHeight = Math.max(expandIconHeight, ((NavigationTree)parentTree).getExpandableImage().getHeight());
                }
                if (parentTree.getApiCollapseIcon() != null && !node.getApiChildren().isEmpty()) {
                    collapseIconHeight = Math.max(collapseIconHeight, ((NavigationTree)parentTree).getCollapsableImage().getHeight());
                }
                CssRule niNodeCon = new CssRule(String.valueOf(selector) + NODECONTENT);
                this.utils.setVerticalAlignment(niNodeCon, style);
                this.utils.setPadding(niNodeCon, style, selector);
                this.utils.setDimension(niNodeCon, style, component);
                this.utils.setBackground(niNodeCon, style, component);
                this.utils.setBorder(niNodeCon, style, component);
                this.utils.setText(niNodeCon, style);
                this.utils.setTextShadow(niNodeCon, style);
                niNodeCon.remove(StyleProperty.WIDTH);
                niNodeCon.remove(StyleProperty.HEIGHT);
                niNodeCon.add(StyleProperty.WHITE_SPACE, "nowrap");
                this.addRule(rules, itemCon);
                this.addRule(rules, niNodeCon);
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case FLASH: 
            case WEBSITE: 
            case URL: 
            case HTML: 
            case DOCUMENT: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                this.addRule(rules, itemCon);
                break;
            }
            case LINE: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                this.addRule(rules, itemCon);
                String svgSel = this.utils.getSVGTextSelector(component);
                itemCon.remove(StyleProperty.DISPLAY);
                CssRule svgWrapper = new CssRule(svgSel);
                this.utils.setHidden(svgWrapper, component);
                this.addRule(rules, svgWrapper);
                break;
            }
            case DYNAMICPANEL: {
                this.utils.setPosition(itemCon, style, component);
                this.utils.setCursor(itemCon, component);
                this.utils.setHidden(itemCon, component);
                this.utils.setZIndex(itemCon, component);
                this.addRule(rules, itemCon);
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case PANEL: {
                CssRule panelLayout;
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                this.utils.removePositionAttributes(itemCon);
                this.addRule(rules, itemCon);
                IPanel panel = (IPanel)component;
                if (CssControllerUtils.hasRoundedBorder(style).booleanValue()) {
                    itemCon.add(StyleProperty.OVERFLOW, "hidden");
                    panelLayout = new CssRule(String.valueOf(selector) + LAYOUT);
                    this.utils.setOverflow(panelLayout, panel.getApiHorizontalOverflow(), panel.getApiVerticalOverflow());
                    this.addRule(rules, panelLayout);
                } else {
                    this.utils.setOverflow(itemCon, panel.getApiHorizontalOverflow(), panel.getApiVerticalOverflow());
                }
                panelLayout = new CssRule(String.valueOf(selector) + VERTICAL_ALIGN);
                panelLayout.add(StyleProperty.VERTICAL_ALIGN, panel.getApiVerticalAlignment().toString());
                this.addRule(rules, panelLayout);
                rules.addAll(this.setLayoutSpacingRules(panel.getApiLayout(), selector, panel.getApiHorizontalOverflow(), panel.getApiVerticalOverflow(), (IComponent)panel));
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case TABLE: {
                this.cellCache.clear();
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                this.addRule(rules, itemCon);
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case DATAGRID: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                itemCon.remove(StyleProperty.WIDTH);
                itemCon.remove(StyleProperty.HEIGHT);
                this.addRule(rules, itemCon);
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case GRIDCELL: {
                IDataGridCell gCell = (IDataGridCell)component;
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                this.utils.removePositionAttributes(itemCon);
                this.utils.removeDimensionAttributes(itemCon);
                this.setGridCellRules(gCell, itemCon, style, rules);
                this.addRule(rules, itemCon);
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case DATALIST: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                itemCon.remove(StyleProperty.HEIGHT);
                itemCon.removeExpression(StyleProperty.HEIGHT);
                this.addRule(rules, itemCon);
                CssRule oddRow = new CssRule(String.valueOf(selector) + ODDROW);
                this.utils.setBackground(oddRow, isNoEventRule != false ? ((IDataList)component).getApiOddItemStyle() : style.getOddPijama(), component);
                this.addRule(rules, oddRow);
                CssRule evenRow = new CssRule(String.valueOf(selector) + EVENROW);
                this.utils.setBackground(evenRow, isNoEventRule != false ? ((IDataList)component).getApiEvenItemStyle() : style.getEvenPijama(), component);
                this.addRule(rules, evenRow);
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case ROW: 
            case DATAROW: {
                this.utils.setBackground(itemCon, style, component);
                this.utils.setOpacity(itemCon, style);
                this.addRule(rules, itemCon);
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case CELLCONTAINER: {
                if (this.cellCache.contains(component)) break;
                ICellContainer cell = (ICellContainer)component;
                this.cellCache.add((ICell)cell);
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                this.utils.removePositionAttributes(itemCon);
                this.setCellRules((ICell)cell, itemCon, style, rules);
                this.addRule(rules, itemCon);
                rules.addAll(this.setLayoutSpacingRules(cell.getApiLayout(), selector, cell.getApiHorizontalOverflow(), cell.getApiVerticalOverflow(), (IComponent)cell));
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case DATACELL: {
                IDataCell datacell = (IDataCell)component;
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                this.utils.removePositionAttributes(itemCon);
                this.setCellRules((ICell)datacell, itemCon, style, rules);
                this.addRule(rules, itemCon);
                rules.addAll(this.setLayoutSpacingRules(datacell.getApiLayout(), selector, datacell.getApiHorizontalOverflow(), datacell.getApiVerticalOverflow(), (IComponent)datacell));
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case TEXTCELL: 
            case RICHTEXT: 
            case BUTTON: 
            case LABEL: 
            case RECTANGLE: 
            case ELLIPSE: 
            case TRIANGLE: 
            case CALLOUT: {
                Integer lineHeight;
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                if (type.equals((Object)TypeAdaptor.ComponentType.TEXTCELL)) {
                    this.utils.removePositionAttributes(itemCon);
                    this.setCellRules((ICell)((ITextCell)component), itemCon, style, rules);
                }
                String tempSelector = selector;
                if (type.equals((Object)TypeAdaptor.ComponentType.ELLIPSE) || type.equals((Object)TypeAdaptor.ComponentType.TRIANGLE) || type.equals((Object)TypeAdaptor.ComponentType.CALLOUT)) {
                    tempSelector = this.utils.getSVGTextSelector(component);
                    itemCon.remove(StyleProperty.DISPLAY);
                    CssRule svgCon = new CssRule(tempSelector);
                    this.utils.setHidden(svgCon, component);
                    this.addRule(rules, svgCon);
                    CssRule textContentCon = new CssRule(String.valueOf(selector) + TEXTCONTENT);
                    int x = 0;
                    int y = 0;
                    int width = component.getApiWidth();
                    int height = component.getApiHeight();
                    if (type.equals((Object)TypeAdaptor.ComponentType.CALLOUT)) {
                        x = (int)((Callout)component).getBoxStartX();
                        y = (int)((Callout)component).getBoxStartY();
                        width = (int)((Callout)component).getBoxWidthValue();
                        height = (int)((Callout)component).getBoxHeightValue();
                    }
                    if (type.equals((Object)TypeAdaptor.ComponentType.ELLIPSE) || type.equals((Object)TypeAdaptor.ComponentType.TRIANGLE) || type.equals((Object)TypeAdaptor.ComponentType.CALLOUT)) {
                        CssRule textContentClipRule = new CssRule(String.valueOf(selector) + SHAPECLIP);
                        if (type.equals((Object)TypeAdaptor.ComponentType.CALLOUT)) {
                            x = (int)((Callout)component).getBoxStartX();
                            y = (int)((Callout)component).getBoxStartY();
                            width = (int)((Callout)component).getBoxWidthValue();
                            height = (int)((Callout)component).getBoxHeightValue();
                        }
                        textContentClipRule.add(StyleProperty.LEFT, String.valueOf(x) + "px");
                        textContentClipRule.add(StyleProperty.TOP, String.valueOf(y) + "px");
                        textContentClipRule.add(StyleProperty.WIDTH, String.valueOf(width) + "px");
                        textContentClipRule.add(StyleProperty.HEIGHT, String.valueOf(height) + "px");
                        textContentClipRule.add(StyleProperty.POSITION, "absolute");
                        textContentClipRule.add(StyleProperty.OVERFLOW, "hidden");
                        this.addRule(rules, textContentClipRule);
                    } else {
                        textContentCon.add(StyleProperty.LEFT, String.valueOf(x) + "px");
                        textContentCon.add(StyleProperty.TOP, String.valueOf(y) + "px");
                        textContentCon.add(StyleProperty.POSITION, "absolute");
                    }
                    textContentCon.add(StyleProperty.WIDTH, String.valueOf(width) + "px");
                    textContentCon.add(StyleProperty.HEIGHT, String.valueOf(height) + "px");
                    this.addRule(rules, textContentCon);
                }
                itemCon.add(StyleProperty.LINE_HEIGHT, (lineHeight = style.getPropertyAsInteger(StyleProperty.LINE_HEIGHT)) == null ? style.getProperty(StyleProperty.FONT_SIZE) : style.getProperty(StyleProperty.LINE_HEIGHT));
                itemCon.add(StyleProperty.FONT_SIZE, style.getProperty(StyleProperty.FONT_SIZE));
                if (style.getProperty(StyleProperty.FONT_FAMILY) != null) {
                    itemCon.add(StyleProperty.FONT_FAMILY, String.valueOf(style.getProperty(StyleProperty.FONT_FAMILY)) + ",Arial");
                }
                this.addRule(rules, itemCon);
                CssRule alignmentCon = new CssRule(String.valueOf(tempSelector) + VALIGN);
                this.utils.setVerticalAlignment(alignmentCon, style);
                alignmentCon.add(StyleProperty.TEXT_ALIGN, style.getProperty(StyleProperty.TEXT_ALIGN));
                this.addRule(rules, alignmentCon);
                CssRule textCon = new CssRule(String.valueOf(tempSelector) + SPAN);
                this.utils.setText(textCon, style);
                this.addRule(rules, textCon);
                if (!isNoEventRule.booleanValue()) break;
                IRichText text = (IRichText)component;
                List ranges = text.getApiChildren();
                Integer rangeCounter = 0;
                for (ITextRange range : ranges) {
                    IStyle rangeStyle = range.getApiStyle();
                    String rangeSelector = String.valueOf(selector) + SPAN + ID_SELECTOR + "rtr-" + identity + "_" + rangeCounter;
                    if (text instanceof IShape) {
                        rangeSelector = String.valueOf(tempSelector) + SPAN + ID_SELECTOR + "rtr-" + identity + "_" + rangeCounter;
                    }
                    CssRule rangeCon = new CssRule(rangeSelector);
                    this.utils.setText(rangeCon, rangeStyle);
                    if (rangeStyle.getPropertyAsInteger(StyleProperty.FONT_SIZE) > style.getPropertyAsInteger(StyleProperty.FONT_SIZE)) {
                        rangeCon.add(StyleProperty.LINE_HEIGHT, rangeCon.get(StyleProperty.FONT_SIZE));
                    } else {
                        rangeCon.add(StyleProperty.LINE_HEIGHT, "0px");
                    }
                    this.addRule(rules, rangeCon);
                    rangeCounter = rangeCounter + 1;
                }
                break;
            }
            case MASTERINSTANCE: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                itemCon.add(StyleProperty.OVERFLOW, "visible");
                IMaster master = ((IMasterInstance)component).getApiSource();
                if (master.getApiRoot().getApiLayout().getApiLayoutType() == ILayout.ApiLayoutType.FREE) {
                    EVCPoint offset = Utils.calculateCCOffset((CustomComponent)((CustomComponent)master));
                    CssRule offsetCon = new CssRule(String.valueOf(selector) + " div.offset");
                    offsetCon.add(StyleProperty.POSITION, "relative");
                    offsetCon.add(StyleProperty.TOP, String.valueOf(-offset.y) + "px");
                    offsetCon.add(StyleProperty.LEFT, String.valueOf(-offset.x) + "px");
                    this.addRule(rules, offsetCon);
                }
                this.addRule(rules, itemCon);
                break;
            }
            case GROUP: {
                this.utils.setPosition(itemCon, style, component);
                this.utils.setDimension(itemCon, style, component);
                this.utils.setHidden(itemCon, component);
                this.utils.setZIndex(itemCon, component);
                this.addRule(rules, itemCon);
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case INDEX: 
            case SUMMARY: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                this.utils.setText(itemCon, style);
                boolean auto = false;
                if (component instanceof ITextComponent) {
                    auto = ((ITextComponent)component).getApiAutoFit();
                }
                if (!auto) {
                    itemCon.add(StyleProperty.LINE_HEIGHT, style.getProperty(StyleProperty.FONT_SIZE));
                }
                CssRule textValignCon = new CssRule(String.valueOf(selector) + VALIGN);
                this.utils.setVerticalAlignment(textValignCon, style);
                this.addRule(rules, itemCon);
                this.addRule(rules, textValignCon);
                break;
            }
            case DROPDOWN: 
            case NATIVEDROPDOWN: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                this.utils.setText(itemCon, style);
                this.utils.setVerticalAlignment(itemCon, style);
                if (type.equals((Object)TypeAdaptor.ComponentType.NATIVEDROPDOWN)) {
                    itemCon.remove(StyleProperty.HEIGHT);
                    itemCon.remove(StyleProperty.BACKGROUND_IMAGE);
                    itemCon.remove(StyleProperty.BACKGROUND_COLOR);
                    itemCon.removeExpression(StyleProperty.HEIGHT);
                }
                int iconWidth = 18;
                if (SimulationDevice.isIOSDevice((SimulationDevice)this.prototype.getApiSimulationSettings().getApiSimulationDevice())) {
                    iconWidth = 28;
                }
                CssRule dropdownValignCon = new CssRule(String.valueOf(selector) + VALIGN);
                if (isNoEventRule.booleanValue()) {
                    dropdownValignCon.add(StyleProperty.WIDTH, String.valueOf(Integer.parseInt(itemCon.get(StyleProperty.WIDTH).replaceFirst("px", "")) - iconWidth) + "px");
                } else if (style.getProperty(StyleProperty.WIDTH) != null) {
                    dropdownValignCon.addExpression(StyleProperty.WIDTH, "Math.max(" + style.getPropertyAsInteger(StyleProperty.WIDTH) + " - jimEvent.fn.getCurrentStyle('border-left-width', '" + selector + "') - jimEvent.fn.getCurrentStyle('border-right-width', '" + selector + "') - jimEvent.fn.getCurrentStyle('padding-left', '" + selector + "') - jimEvent.fn.getCurrentStyle('padding-right', '" + selector + "') - " + iconWidth + ")" + "+ 'px'");
                }
                this.addRule(rules, itemCon);
                this.addRule(rules, dropdownValignCon);
                break;
            }
            case DATE: 
            case TIME: 
            case DATETIME: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                CssRule dateValignCon = new CssRule(String.valueOf(selector) + VALIGN);
                this.utils.setVerticalAlignment(dateValignCon, style);
                if (style.getProperty(StyleProperty.VERTICAL_ALIGN) != null && style.getProperty(StyleProperty.VERTICAL_ALIGN).equals(ILayout.ApiAlignmentType.MIDDLE.toString())) {
                    dateValignCon.add(StyleProperty.LINE_HEIGHT, style.getProperty(StyleProperty.FONT_SIZE));
                }
                CssRule dateInputCon = new CssRule(String.valueOf(selector) + INPUT);
                this.utils.setText(dateInputCon, style);
                if (isNoEventRule.booleanValue()) {
                    dateInputCon.add(StyleProperty.MIN_HEIGHT, style.getProperty(StyleProperty.FONT_SIZE));
                }
                this.utils.setTextShadow(dateInputCon, style);
                this.addRule(rules, itemCon);
                this.addRule(rules, dateValignCon);
                this.addRule(rules, dateInputCon);
                if (SimulationDevice.isIOSDevice((SimulationDevice)this.prototype.getApiSimulationSettings().getApiSimulationDevice()) || !isNoEventRule.booleanValue()) break;
                CssRule iconCon = new CssRule(String.valueOf(selector) + ICON);
                iconCon.add(StyleProperty.TOP, String.valueOf((int)(0.5 * (double)style.getPropertyAsInteger(StyleProperty.HEIGHT).intValue() - 8.0)) + "px");
                this.addRule(rules, iconCon);
                break;
            }
            case FILE: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                CssRule fileValignCon = new CssRule(String.valueOf(selector) + VALIGN);
                this.utils.setVerticalAlignment(fileValignCon, style);
                if (style.getProperty(StyleProperty.VERTICAL_ALIGN) != null && style.getProperty(StyleProperty.VERTICAL_ALIGN).equals(ILayout.ApiAlignmentType.MIDDLE.toString())) {
                    fileValignCon.add(StyleProperty.LINE_HEIGHT, style.getProperty(StyleProperty.FONT_SIZE));
                }
                CssRule fileInputCon = new CssRule(String.valueOf(selector) + INPUT);
                this.utils.setText(fileInputCon, style);
                this.utils.setTextShadow(fileInputCon, style);
                this.addRule(rules, itemCon);
                this.addRule(rules, fileValignCon);
                this.addRule(rules, fileInputCon);
                if (!isNoEventRule.booleanValue()) break;
                CssRule browseIconCon = new CssRule(String.valueOf(selector) + ICON);
                browseIconCon.add(StyleProperty.TOP, String.valueOf((int)(0.5 * (double)(style.getPropertyAsInteger(StyleProperty.HEIGHT) - style.getPropertyAsInteger(StyleProperty.BORDER_TOP_WIDTH) - style.getPropertyAsInteger(StyleProperty.BORDER_BOTTOM_WIDTH)) - 10.0)) + "px");
                CssRule fileCon = new CssRule(browseIconCon, String.valueOf(selector) + " input.file-input");
                this.addRule(rules, browseIconCon);
                this.addRule(rules, fileCon);
                break;
            }
            case TEXT: 
            case PASSWORD: 
            case NUMBER: 
            case EMAIL: 
            case INPUTURL: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                CssRule inputValignCon = new CssRule(String.valueOf(selector) + VALIGN);
                this.utils.setVerticalAlignment(inputValignCon, style);
                if (style.getProperty(StyleProperty.VERTICAL_ALIGN) != null && style.getProperty(StyleProperty.VERTICAL_ALIGN).equals(ILayout.ApiAlignmentType.MIDDLE.toString())) {
                    inputValignCon.add(StyleProperty.LINE_HEIGHT, style.getProperty(StyleProperty.FONT_SIZE));
                }
                CssRule textInputCon = new CssRule(String.valueOf(selector) + INPUT);
                this.utils.setText(textInputCon, style);
                this.utils.setTextShadow(textInputCon, style);
                this.addRule(rules, itemCon);
                this.addRule(rules, inputValignCon);
                this.addRule(rules, textInputCon);
                break;
            }
            case SELECTIONLIST: 
            case MULTISELECTIONLIST: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                this.utils.setText(itemCon, style);
                CssRule listValignCon = new CssRule(String.valueOf(selector) + CELL);
                this.utils.setVerticalAlignment(listValignCon, style);
                ISelect selectionComponent = (ISelect)component;
                if (isNoEventRule.booleanValue() && this.utils.inDataView((IComponent)selectionComponent).booleanValue() && selectionComponent.getApiField() != null) {
                    CssRule enabledCon = new CssRule(String.valueOf(selector) + " td.enabled");
                    CssRule disabledCon = new CssRule(String.valueOf(selector) + " td.disabled");
                    if (((AttributeForm)component).isEditable()) {
                        enabledCon.add(StyleProperty.DISPLAY, "inline");
                        disabledCon.add(StyleProperty.DISPLAY, "none");
                    } else {
                        enabledCon.add(StyleProperty.DISPLAY, "none");
                        disabledCon.add(StyleProperty.DISPLAY, "inline");
                    }
                    this.addRule(rules, enabledCon);
                    this.addRule(rules, disabledCon);
                }
                this.addRule(rules, listValignCon);
                this.addRule(rules, itemCon);
                break;
            }
            case CHECKBOX: 
            case RADIOBUTTON: {
                this.utils.setPosition(itemCon, style, component);
                this.utils.setOpacity(itemCon, style);
                this.utils.setHidden(itemCon, component);
                this.utils.setZIndex(itemCon, component);
                this.utils.setCursor(itemCon, component);
                this.utils.setShadow(itemCon, style);
                this.addRule(rules, itemCon);
                break;
            }
            case CHECKBOXLIST: 
            case RADIOBUTTONLIST: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                CssRule spanCon = new CssRule(String.valueOf(selector) + SPAN);
                this.utils.setText(spanCon, style);
                if (isNoEventRule.booleanValue()) {
                    ISelect listComponent;
                    if (((ISelect)component).isApiHorizontal().booleanValue()) {
                        CssRule boolenSelectValignCon = new CssRule(String.valueOf(itemCon.getSelector()) + CELL);
                        this.utils.setVerticalAlignment(boolenSelectValignCon, style);
                        this.addRule(rules, boolenSelectValignCon);
                    }
                    if (this.utils.inDataView((IComponent)(listComponent = (ISelect)component)).booleanValue() && listComponent.getApiField() != null) {
                        this.utils.setText(itemCon, style);
                        CssRule disabledCon = new CssRule(String.valueOf(selector) + " tr.disabled");
                        if (((AttributeForm)component).isEditable()) {
                            disabledCon.add(StyleProperty.DISPLAY, "none");
                        } else {
                            disabledCon.add(StyleProperty.DISPLAY, "inline");
                            CssRule enabledCon = new CssRule(String.valueOf(selector) + " tr.enabled");
                            enabledCon.add(StyleProperty.DISPLAY, "none");
                            this.addRule(rules, enabledCon);
                        }
                        this.addRule(rules, disabledCon);
                    }
                }
                itemCon.add(StyleProperty.TEXT_ALIGN, spanCon.get(StyleProperty.TEXT_ALIGN));
                this.addRule(rules, spanCon);
                this.addRule(rules, itemCon);
                break;
            }
            case TEXTAREA: {
                this.utils.setGeneralAttributes(itemCon, style, component, selector);
                CssRule textareaCon = new CssRule(String.valueOf(selector) + " textarea");
                this.utils.setText(textareaCon, style);
                itemCon.remove(StyleProperty.TEXT_SHADOW);
                this.utils.setTextShadow(textareaCon, style);
                this.addRule(rules, itemCon);
                this.addRule(rules, textareaCon);
                break;
            }
        }
        return rules;
    }

    private List<CssRule> createSVGRule(CssRule itemCon, IStyle style, String selector, Boolean isEvent) {
        ArrayList<CssRule> rules = new ArrayList<CssRule>();
        String svgSelector = selector.concat(" > svg");
        CssRule rule = new CssRule(svgSelector);
        rule.add(StyleProperty.WIDTH, style.getProperty(StyleProperty.WIDTH));
        rule.add(StyleProperty.HEIGHT, style.getProperty(StyleProperty.HEIGHT));
        rules.add(rule);
        if (isEvent.booleanValue()) {
            Boolean svgBackground = Boolean.parseBoolean(style.getProperty(StyleProperty.SVG_BACKGROUND));
            CssRule overlay = new CssRule(selector.concat(" > svg"));
            if (svgBackground.booleanValue()) {
                overlay.add(StyleProperty.OVERLAY, style.getProperty(StyleProperty.OVERLAY));
            } else {
                overlay.add(StyleProperty.OVERLAY, "none");
            }
            rules.add(overlay);
        }
        return rules;
    }

    protected List<CssRule> processChildren(IComponent component, Boolean isNoEventRule) {
        ArrayList<CssRule> rules = new ArrayList<CssRule>();
        for (IComponent child : component.getApiChildren()) {
            rules.addAll(this.processCssRules(child, child.getApiStyle(), isNoEventRule));
        }
        return rules;
    }

    protected void addRule(List<CssRule> rules, CssRule rule) {
        if (!rule.isEmpty()) {
            rules.add(rule);
        }
    }

    protected String getExtension() {
        return EXTENSION;
    }

    protected Boolean isEventRule(List<CssStyle> eventStyles) {
        if (eventStyles != null && !eventStyles.isEmpty()) {
            return true;
        }
        return false;
    }

    private void setCellRules(ICell cell, CssRule cellContext, IStyle style, List<CssRule> rules) {
        String cellSelector = this.utils.getSelector((IComponent)cell);
        if (cell instanceof ICellContainer) {
            ICellContainer cellContainer = (ICellContainer)cell;
            CssRule cellLayout = new CssRule(String.valueOf(cellSelector) + LAYOUT);
            this.utils.setOverflow(cellLayout, cellContainer.getApiHorizontalOverflow(), cellContainer.getApiVerticalOverflow());
            this.addRule(rules, cellLayout);
            CssRule panelLayout = new CssRule(String.valueOf(cellSelector) + VERTICAL_ALIGN);
            panelLayout.add(StyleProperty.VERTICAL_ALIGN, cellContainer.getApiVerticalAlignment().toString());
            this.addRule(rules, panelLayout);
        }
        if (!this.utils.getIsNoEventRule().booleanValue()) {
            String selector;
            if (cellContext.getExpression(StyleProperty.WIDTH) != null) {
                for (ICell columnCell : cell.getColumnCells()) {
                    if (columnCell.equals(cell)) continue;
                    selector = this.utils.getSelector((IComponent)columnCell);
                    CssRule columnCellContext = new CssRule(selector);
                    columnCellContext.addExpression(StyleProperty.WIDTH, "Math.max(jimEvent.fn.getCurrentStyle('width', '" + selector + "') - (jQuery('" + cellSelector + "').outerWidth() - " + style.getPropertyAsInteger(StyleProperty.WIDTH) + "), 0) + 'px'");
                    this.addRule(rules, columnCellContext);
                }
            }
            if (cellContext.getExpression(StyleProperty.HEIGHT) != null) {
                for (ICell rowCell : cell.getRowCells()) {
                    if (rowCell.equals(cell)) continue;
                    selector = this.utils.getSelector((IComponent)rowCell);
                    CssRule rowCellContext = new CssRule(selector);
                    rowCellContext.addExpression(StyleProperty.HEIGHT, "Math.max(jimEvent.fn.getCurrentStyle('height', '" + selector + "') - (jQuery('" + cellSelector + "').outerHeight() - " + style.getPropertyAsInteger(StyleProperty.HEIGHT) + "), 0) + 'px'");
                    this.addRule(rules, rowCellContext);
                }
            }
        }
    }

    private void addSpacingRule(List<CssRule> rules, int spacing, String selector, String id, StyleProperty prop, boolean vertical) {
        CssRule rule = new CssRule(selector);
        rule.add(prop, String.valueOf(String.valueOf(spacing)) + "px");
        if (vertical) {
            CssRule lastRule = new CssRule(String.valueOf(selector) + ":last-child");
            lastRule.add(prop, "0");
            rules.add(lastRule);
        }
        rules.add(rule);
    }

    private List<CssRule> setLayoutSpacingRules(ILayout layout, String selector, ILayout.ApiOverflowType horizontalOverflow, ILayout.ApiOverflowType verticalOverflow, IComponent c) {
        int vs = layout.getApiVerticalSpacing();
        int hs = layout.getApiHorizontalSpacing();
        String id = c.getApiId();
        ArrayList<CssRule> rules = new ArrayList<CssRule>();
        if (layout.getApiLayoutType().equals((Object)ILayout.ApiLayoutType.VERTICAL) && (vs != 0 || hs != 0)) {
            if (hs != 0 && verticalOverflow.equals((Object)ILayout.ApiOverflowType.WRAP)) {
                this.addSpacingRule(rules, hs, String.valueOf(selector) + " ." + id + " > .verticalWrapper", id, StyleProperty.MARGIN_RIGHT, true);
            }
            if (vs != 0) {
                String vSelector = verticalOverflow.equals((Object)ILayout.ApiOverflowType.WRAP) ? String.valueOf(selector) + " ." + c.getApiId() + " > .verticalWrapper > *" : String.valueOf(selector) + " ." + c.getApiId() + " > *";
                this.addSpacingRule(rules, vs, vSelector, id, StyleProperty.MARGIN_BOTTOM, true);
            }
        } else if (layout.getApiLayoutType().equals((Object)ILayout.ApiLayoutType.HORIZONTAL) && (vs != 0 || hs != 0)) {
            if (hs != 0) {
                boolean isRight = layout.getApiHorizontalAlignment().equals((Object)ILayout.ApiAlignmentType.RIGHT);
                boolean isCenter = layout.getApiHorizontalAlignment().equals((Object)ILayout.ApiAlignmentType.CENTER);
                if (isRight || layout.getApiHorizontalAlignment().equals((Object)ILayout.ApiAlignmentType.LEFT)) {
                    StyleProperty prop = isRight ? StyleProperty.MARGIN_LEFT : StyleProperty.MARGIN_RIGHT;
                    this.addSpacingRule(rules, hs, String.valueOf(selector) + " ." + c.getApiId() + " > *", id, prop, false);
                } else if (isCenter) {
                    float newSpacing = (float)hs / 2.0f;
                    CssRule rule = new CssRule(String.valueOf(selector) + " ." + c.getApiId() + " > *");
                    rule.add(StyleProperty.MARGIN_LEFT, String.valueOf(String.valueOf(newSpacing)) + "px");
                    rule.add(StyleProperty.MARGIN_RIGHT, String.valueOf(String.valueOf(newSpacing)) + "px");
                    rules.add(rule);
                }
                CssRule ghost = new CssRule(String.valueOf(selector) + " .ghostHLayout");
                ghost.add(StyleProperty.WIDTH, "calc(" + String.valueOf(c.getApiWidth() + hs) + "px)");
                if (isRight || isCenter) {
                    float value = 0.0f;
                    if (isRight) {
                        ghost.add(StyleProperty.MARGIN_LEFT, String.valueOf(String.valueOf(-hs)) + "px");
                    } else if (isCenter) {
                        ghost.add(StyleProperty.MARGIN_LEFT, String.valueOf(String.valueOf(-((float)hs) / 2.0f)) + "px");
                    }
                }
                rules.add(ghost);
            }
            if (vs != 0 && horizontalOverflow.equals((Object)ILayout.ApiOverflowType.WRAP)) {
                this.addSpacingRule(rules, vs, String.valueOf(selector) + " ." + c.getApiId() + " > *", id, StyleProperty.MARGIN_BOTTOM, false);
            }
        }
        return rules;
    }

    private void setGridCellRules(IDataGridCell cell, CssRule cellContext, IStyle style, List<CssRule> rules) {
        String cellSelector = this.utils.getSelector((IComponent)cell);
        IDataGridCell cellContainer = cell;
        CssRule cellLayout = new CssRule(String.valueOf(cellSelector) + LAYOUT);
        this.utils.setOverflow(cellLayout, cellContainer.getApiHorizontalOverflow(), cellContainer.getApiVerticalOverflow());
        this.addRule(rules, cellLayout);
        CssRule panelLayout = new CssRule(String.valueOf(cellSelector) + VERTICAL_ALIGN);
        panelLayout.add(StyleProperty.VERTICAL_ALIGN, cellContainer.getApiVerticalAlignment().toString());
        this.addRule(rules, panelLayout);
        rules.addAll(this.setLayoutSpacingRules(cell.getApiLayout(), cellSelector, cell.getApiHorizontalOverflow(), cell.getApiVerticalOverflow(), (IComponent)cell));
    }

    private void clearCache() {
        this.cellCache.clear();
    }
}

