/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.css;

import com.justinmind.evc.model.customComponents.CustomComponent;
import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ControllerUtils;
import com.justinmind.generator.context.css.CssController;
import com.justinmind.generator.context.css.CssControllerIEUtils;
import com.justinmind.generator.context.css.CssControllerUtils;
import com.justinmind.generator.context.css.CssRule;
import com.justinmind.generator.engine.modeladaptor.TypeAdaptor;
import com.justinmind.prototyper.api.ui.IStyle;
import com.justinmind.prototyper.api.ui.StyleProperty;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import com.justinmind.prototyper.api.ui.canvas.IMaster;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.component.IDataList;
import com.justinmind.prototyper.api.ui.component.ILayout;
import com.justinmind.prototyper.api.ui.component.IMasterInstance;
import com.justinmind.prototyper.api.ui.component.IMenuNode;
import com.justinmind.prototyper.api.ui.component.IRootComponent;
import com.justinmind.prototyper.api.ui.event.ITarget;
import com.justinmind.util.datamanage.Utils;
import java.util.ArrayList;
import java.util.List;

public final class CssControllerIE
extends CssController {
    static final String VALIGN_IE = " > .valign";
    private static final String EXTENSION = "-ie.css";

    public CssControllerIE(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    protected CssControllerUtils createCssControllerUtils(ApplicationContext applicationContext) {
        return new CssControllerIEUtils(applicationContext);
    }

    @Override
    protected CssControllerIEUtils getControllerUtils() {
        return (CssControllerIEUtils)super.getControllerUtils();
    }

    @Override
    public List<CssRule> processCssRules(IComponent component, IStyle style, Boolean isNoEventRule) {
        CssControllerIEUtils utils = this.getControllerUtils();
        utils.setIsNoEventRule(isNoEventRule);
        ArrayList<CssRule> rules = new ArrayList<CssRule>();
        String identity = ControllerUtils.getID(component);
        String selector = utils.getSelector(component);
        TypeAdaptor.ComponentType type = TypeAdaptor.getComponentType((ITarget)component);
        CssRule itemCon = new CssRule(utils.getSelector(component));
        switch (type) {
            case ROOTCOMPONENT: {
                IRootComponent root = (IRootComponent)component;
                ICanvas canvas = root.getApiCanvas();
                switch (TypeAdaptor.getComponentType((ITarget)canvas)) {
                    case SCREEN: 
                    case TEMPLATE: 
                    case MASTER: {
                        utils.setBackground(itemCon, style, component);
                        utils.setOpacity(itemCon, style);
                        this.addRule(rules, itemCon);
                        if (!isNoEventRule.booleanValue()) break;
                        rules.addAll(this.processChildren(component, isNoEventRule));
                        break;
                    }
                }
                this.createAlignment(selector, root.getApiLayout(), rules);
                break;
            }
            case PANEL: 
            case CELLCONTAINER: {
                utils.setBorder(itemCon, style, component);
                utils.setBackground(itemCon, style, component);
                utils.setOpacity(itemCon, style);
                this.addRule(rules, itemCon);
                this.createAlignment(selector, (ILayout)component, rules);
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case GROUP: 
            case DYNAMICPANEL: {
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case MASTERINSTANCE: {
                IMaster master = ((IMasterInstance)component).getApiSource();
                IStyle styleMaster = master.getApiRoot().getApiStyle();
                utils.setBackground(itemCon, styleMaster, component);
                utils.setOpacity(itemCon, styleMaster);
                this.addRule(rules, itemCon);
                break;
            }
            case TABLE: {
                utils.setTable(itemCon, style);
                utils.setBackground(itemCon, style, component);
                utils.setOpacity(itemCon, style);
                this.addRule(rules, itemCon);
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case DATALIST: {
                utils.setBackground(itemCon, style, component);
                utils.setOpacity(itemCon, style);
                this.addRule(rules, itemCon);
                IDataList dataList = (IDataList)component;
                CssRule oddRowTd = new CssRule(String.valueOf(selector) + " tr.odd" + " td");
                utils.setBackground(oddRowTd, isNoEventRule != false ? ((IDataList)component).getApiOddItemStyle() : style.getOddPijama(), component);
                if (oddRowTd.getAttributes().size() > 0) {
                    oddRowTd.add(StyleProperty.POSITION, "relative");
                    this.addRule(rules, oddRowTd);
                    CssRule oddRow = new CssRule(String.valueOf(selector) + " tr.odd");
                    oddRow.add(StyleProperty.BACKGROUND_COLOR, "transparent");
                    this.addRule(rules, oddRow);
                }
                CssRule evenRowTd = new CssRule(String.valueOf(selector) + " tr.even" + " td");
                utils.setBackground(evenRowTd, isNoEventRule != false ? ((IDataList)component).getApiEvenItemStyle() : style.getEvenPijama(), component);
                if (evenRowTd.getAttributes().size() > 0) {
                    evenRowTd.add(StyleProperty.POSITION, "relative");
                    this.addRule(rules, evenRowTd);
                    CssRule evenRow = new CssRule(String.valueOf(selector) + " tr.even");
                    evenRow.add(StyleProperty.BACKGROUND_COLOR, "transparent");
                    this.addRule(rules, evenRow);
                }
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case DROPDOWN: 
            case NATIVEDROPDOWN: {
                utils.setOpacity(itemCon, style);
                this.addRule(rules, itemCon);
                CssRule optionsCon = new CssRule(String.valueOf(selector) + "-options");
                utils.setBackground(optionsCon, style, component);
                String optionsBgColor = style.getProperty(StyleProperty.BACKGROUND_COLOR);
                if (optionsBgColor != null) {
                    optionsCon.add(StyleProperty.BACKGROUND_COLOR, optionsBgColor);
                }
                this.addRule(rules, optionsCon);
                break;
            }
            case DATE: 
            case TIME: 
            case DATETIME: 
            case FILE: {
                utils.setBackground(itemCon, style, component);
                utils.setOpacity(itemCon, style);
                this.addRule(rules, itemCon);
                this.addRule(rules, itemCon);
                break;
            }
            case IMAGE: {
                utils.setRotation(itemCon, style, component);
                utils.setOpacity(itemCon, style);
                this.addRule(rules, itemCon);
                break;
            }
            case LINE: {
                utils.setBorder(itemCon, style, component);
                utils.setOpacity(itemCon, style);
                utils.setRotation(itemCon, style, component);
                this.addRule(rules, itemCon);
            }
            case INDEX: 
            case SUMMARY: 
            case RICHTEXT: 
            case BUTTON: 
            case LABEL: 
            case RECTANGLE: 
            case ELLIPSE: 
            case TRIANGLE: 
            case CALLOUT: {
                utils.setBorder(itemCon, style, component);
                utils.setBackground(itemCon, style, component);
                utils.setOpacity(itemCon, style);
                utils.setRotation(itemCon, style, component);
                this.addRule(rules, itemCon);
                break;
            }
            case MENUNODE: {
                if (Utils.hasParent((IComponent)component, CustomComponent.class).booleanValue() && Utils.hasParent((IComponent)component, IMenuNode.class).booleanValue()) {
                    itemCon.setSelector("[masteritem=" + ControllerUtils.getID((IComponent)component.getApiCanvas().getApiRoot()) + "] " + "#" + identity);
                }
                utils.setDimension(itemCon, style, component);
                itemCon.remove(StyleProperty.WIDTH);
                itemCon.removeExpression(StyleProperty.WIDTH);
                utils.setBackground(itemCon, style, component);
                utils.setOpacity(itemCon, style);
                this.addRule(rules, itemCon);
                if (this.applicationContext.isMobile().booleanValue() || !isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            case DATACELL: {
                utils.setBackground(itemCon, style, component);
                itemCon.add(StyleProperty.POSITION, "relative");
                utils.setOpacity(itemCon, style);
                this.addRule(rules, itemCon);
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
                break;
            }
            default: {
                utils.setBackground(itemCon, style, component);
                utils.setOpacity(itemCon, style);
                this.addRule(rules, itemCon);
                if (!isNoEventRule.booleanValue()) break;
                rules.addAll(this.processChildren(component, isNoEventRule));
            }
        }
        return rules;
    }

    @Override
    protected String getExtension() {
        return EXTENSION;
    }

    private void createAlignment(String selector, ILayout layout, List<CssRule> rules) {
        if (selector != null && layout != null && rules != null && !layout.getApiLayoutType().equals((Object)ILayout.ApiLayoutType.FREE)) {
            CssRule alignCon = new CssRule(String.valueOf(selector) + VALIGN_IE);
            alignCon.add(StyleProperty.VERTICAL_ALIGN, layout.getApiVerticalAlignment().toString());
            this.addRule(rules, alignCon);
        }
    }
}

