/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.css;

import com.justinmind.evc.model.EVCPoint;
import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.css.CssControllerIEUtils;
import com.justinmind.generator.context.css.CssRule;
import com.justinmind.prototyper.api.ui.IStyle;
import com.justinmind.prototyper.api.ui.StyleProperty;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.component.ILine;
import com.justinmind.prototyper.api.ui.component.IRectangle;
import com.justinmind.prototyper.api.ui.component.IShape;

public class CssControllerIE8Utils
extends CssControllerIEUtils {
    protected CssControllerIE8Utils(ApplicationContext applicationContext) {
        this(false, applicationContext);
    }

    protected CssControllerIE8Utils(Boolean isNoEventRule, ApplicationContext applicationContext) {
        super(isNoEventRule, applicationContext);
    }

    @Override
    protected <S extends IStyle> void setRotation(CssRule con, S style, IComponent component) {
        if (con != null && style != null && CssControllerIE8Utils.isRotated(style).booleanValue()) {
            Float rotationAngle = Float.valueOf(style.getProperty(StyleProperty.IE_ROTATION_ANGLE));
            double deg2radians = Math.PI / 180;
            double rad = (double)rotationAngle.floatValue() * deg2radians;
            double costheta = Math.cos(rad);
            double sintheta = Math.sin(rad);
            String matrixTransformValue = "";
            if ((double)rotationAngle.floatValue() != 0.0) {
                matrixTransformValue = " progid:DXImageTransform.Microsoft.Matrix(SizingMethod = 'auto expand',M11=" + costheta + ",M12=" + -sintheta + ",M21=" + sintheta + ",M22=" + costheta + ")";
            }
            if (this.isNoEventRule.booleanValue()) {
                if (component instanceof IShape && !(component instanceof IRectangle)) {
                    con.addAppending(StyleProperty.VML_ROTATION_DEGREES, rotationAngle.toString());
                } else {
                    con.addAppending(StyleProperty.IE8_FILTER, matrixTransformValue);
                    con.addAppending(StyleProperty.IE7_FILTER, matrixTransformValue);
                }
                EVCPoint newPos = this.getRotatedPos(style.getPropertyAsInteger(StyleProperty.LEFT), style.getPropertyAsInteger(StyleProperty.TOP), style.getPropertyAsInteger(StyleProperty.WIDTH), style.getPropertyAsInteger(StyleProperty.HEIGHT), rotationAngle.floatValue());
                con.add(StyleProperty.MARGIN_LEFT, String.valueOf(newPos.x - style.getPropertyAsInteger(StyleProperty.LEFT)) + "px");
                con.add(StyleProperty.MARGIN_TOP, String.valueOf(newPos.y - style.getPropertyAsInteger(StyleProperty.TOP)) + "px");
            } else {
                String identity = this.getSelector(component);
                if (component instanceof IShape || component instanceof ILine) {
                    con.addAppending(StyleProperty.VML_ROTATION_DEGREES, rotationAngle.toString());
                } else {
                    con.addAppending(StyleProperty.IE8_FILTER, matrixTransformValue);
                    con.addAppending(StyleProperty.IE7_FILTER, matrixTransformValue);
                }
                con.addExpression(StyleProperty.MARGIN_LEFT, String.valueOf(this.getMarginLeftExpression(String.valueOf(rotationAngle), identity)) + " + 'px'");
                con.addExpression(StyleProperty.MARGIN_TOP, String.valueOf(this.getMarginTopExpression(String.valueOf(rotationAngle), identity)) + " + 'px'");
            }
        }
    }

    protected String getMarginLeftExpression(String rotationAngle, String identity) {
        return "jimUtil.calculateRotationShift(" + rotationAngle + ",$target).x";
    }

    protected String getMarginTopExpression(String rotationAngle, String identity) {
        return "jimUtil.calculateRotationShift(" + rotationAngle + ",$target).y";
    }

    private EVCPoint getRotatedPos(int x, int y, int width, int height, float rotationAngle) {
        double angle = (double)rotationAngle * (Math.PI / 180);
        int centerX = x + width / 2;
        int centerY = y + height / 2;
        EVCPoint topLeft = this.rotatedPoint(angle, x, y, centerX, centerY);
        EVCPoint topRight = this.rotatedPoint(angle, x + width, y, centerX, centerY);
        EVCPoint bottomLeft = this.rotatedPoint(angle, x, y + height, centerX, centerY);
        EVCPoint bottomRight = this.rotatedPoint(angle, x + width, y + height, centerX, centerY);
        x = Math.min(Math.min(Math.min(topLeft.x, topRight.x), bottomLeft.x), bottomRight.x);
        y = Math.min(Math.min(Math.min(topLeft.y, topRight.y), bottomLeft.y), bottomRight.y);
        return new EVCPoint(x, y);
    }

    private EVCPoint rotatedPoint(double angle, int x, int y, int centerX, int centerY) {
        double rotatedX = (double)centerX + (double)(x - centerX) * Math.cos(angle) - (double)(y - centerY) * Math.sin(angle);
        double rotatedY = (double)centerY + (double)(x - centerX) * Math.sin(angle) + (double)(y - centerY) * Math.cos(angle);
        return new EVCPoint((int)rotatedX, (int)rotatedY);
    }
}

