/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.css;

import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.css.CssControllerUtils;
import com.justinmind.generator.context.css.CssRule;
import com.justinmind.generator.engine.Paths;
import com.justinmind.prototyper.api.ui.IStyle;
import com.justinmind.prototyper.api.ui.StyleProperty;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.component.IDataList;
import com.justinmind.prototyper.api.ui.component.ILayout;
import com.justinmind.util.datamanage.Utils;

public class CssControllerIEUtils
extends CssControllerUtils {
    protected CssControllerIEUtils(ApplicationContext applicationContext) {
        this(false, applicationContext);
    }

    protected CssControllerIEUtils(Boolean isNoEventRule, ApplicationContext applicationContext) {
        super(isNoEventRule, applicationContext);
    }

    @Override
    protected <S extends IStyle> void setBackground(CssRule con, S style, IComponent component) {
        if (con != null && style != null) {
            String bgImage = style.getProperty(StyleProperty.BACKGROUND_IMAGE);
            String backgroundImageRule = null;
            if (bgImage != null) {
                backgroundImageRule = String.valueOf(this.getBackgroundImageRule(Paths.getImagePath("./", bgImage))) + " " + style.getProperty(StyleProperty.BACKGROUND_REPEAT) + " " + style.getProperty(StyleProperty.BACKGROUND_POSITION) + " " + style.getProperty(StyleProperty.BACKGROUND_ATTACHMENT);
            }
            if (CssControllerIEUtils.hasGradient(style).booleanValue()) {
                String firstPartOfRule = backgroundImageRule != null ? String.valueOf(backgroundImageRule) + ", " : "";
                con.add(StyleProperty.PIE_BACKGROUND_GRADIENT, String.valueOf(firstPartOfRule) + style.getProperty(StyleProperty.PIE_BACKGROUND_GRADIENT));
                con.add(StyleProperty.PIE_POLL, "false");
            } else if (!this.isNoEventRule.booleanValue()) {
                String bgColor = style.getProperty(StyleProperty.BACKGROUND_COLOR);
                if (backgroundImageRule != null) {
                    con.add(StyleProperty.PIE_BACKGROUND_GRADIENT, bgColor != null ? String.valueOf(backgroundImageRule) + " " + bgColor : backgroundImageRule);
                    con.add(StyleProperty.PIE_POLL, "false");
                } else if (bgColor != null) {
                    con.add(StyleProperty.PIE_BACKGROUND_GRADIENT, bgColor);
                    con.add(StyleProperty.PIE_POLL, "false");
                }
            }
            if (con.getAttributes().containsKey(StyleProperty.PIE_BACKGROUND_GRADIENT) && component.getApiLayout() != null && !component.getApiLayout().getApiLayoutType().equals((Object)ILayout.ApiLayoutType.FREE) && Utils.getParent((IComponent)component, IDataList.class) != null) {
                con.add(StyleProperty.POSITION, "relative");
            }
        }
    }

    @Override
    protected <S extends IStyle> void setOpacity(CssRule con, S style) {
        if (con != null && style != null && style.getProperty(StyleProperty.OPACITY) != null) {
            Integer transparency = style.getPropertyAsInteger(StyleProperty.OPACITY);
            if (!this.isNoEventRule.booleanValue() || transparency != 0) {
                transparency = 100 - transparency;
                con.addAppending(StyleProperty.IE8_FILTER, "progid:DXImageTransform.Microsoft.Alpha(Opacity=" + transparency + ")");
                con.addAppending(StyleProperty.IE7_FILTER, "alpha(opacity=" + transparency + ")");
            }
        }
    }

    protected <S extends IStyle> void setTable(CssRule con, S style) {
        if (this.isNoEventRule.booleanValue() && con != null && style != null) {
            con.add(StyleProperty.BORDER_COLLAPSE, "separate");
        }
    }

    @Override
    protected <S extends IStyle> void setRotation(CssRule con, S style, IComponent component) {
        if (con != null && style != null && CssControllerIEUtils.isRotated(style).booleanValue()) {
            Float rotationAngle = Float.valueOf(style.getProperty(StyleProperty.IE_ROTATION_ANGLE));
            con.add(StyleProperty.IE_ROTATION_ANGLE, "rotate(" + rotationAngle + "deg)");
        }
    }
}

