/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.css;

import com.justinmind.evc.model.actions.RootComponent;
import com.justinmind.evc.model.lookAndFeel.EVCColor;
import com.justinmind.evc.model.lookAndFeel.Style;
import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ControllerUtils;
import com.justinmind.generator.context.css.CssRule;
import com.justinmind.generator.engine.Paths;
import com.justinmind.generator.engine.modeladaptor.TypeAdaptor;
import com.justinmind.prototyper.api.ui.IStyle;
import com.justinmind.prototyper.api.ui.StyleProperty;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import com.justinmind.prototyper.api.ui.canvas.IMaster;
import com.justinmind.prototyper.api.ui.component.ICallout;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.component.IDataGridCell;
import com.justinmind.prototyper.api.ui.component.IDataRow;
import com.justinmind.prototyper.api.ui.component.IDataView;
import com.justinmind.prototyper.api.ui.component.IHeaderRow;
import com.justinmind.prototyper.api.ui.component.ILayout;
import com.justinmind.prototyper.api.ui.component.IRectangle;
import com.justinmind.prototyper.api.ui.component.IRichText;
import com.justinmind.prototyper.api.ui.component.IShape;
import com.justinmind.prototyper.api.ui.component.ITable;
import com.justinmind.prototyper.api.ui.component.ITextComponent;
import com.justinmind.prototyper.api.ui.event.IEvent;
import com.justinmind.prototyper.api.ui.event.ITarget;
import com.justinmind.prototyper.api.ui.simulation.SimulationDevice;
import com.justinmind.util.datamanage.Utils;

public class CssControllerUtils {
    private static final Integer FILE_ICON_MARGIN = 71;
    protected transient Boolean isNoEventRule;
    protected final transient ApplicationContext applicationContext;
    protected transient String imagePathPrefix;

    public CssControllerUtils(ApplicationContext applicationContext) {
        this(false, applicationContext);
    }

    protected CssControllerUtils(Boolean isNoEventRule, ApplicationContext applicationContext) {
        this.isNoEventRule = isNoEventRule;
        this.applicationContext = applicationContext;
        this.setImagePathPrefix();
    }

    protected Boolean getIsNoEventRule() {
        return this.isNoEventRule;
    }

    protected void setIsNoEventRule(Boolean isNoEventRule) {
        this.isNoEventRule = isNoEventRule;
        this.setImagePathPrefix();
    }

    protected String getImagePathPrefix() {
        return this.applicationContext.getPaths().getImagePathPrefix(this.isNoEventRule);
    }

    private final void setImagePathPrefix() {
        this.imagePathPrefix = this.getImagePathPrefix();
    }

    protected <S extends IStyle> void setGeneralAttributes(CssRule con, S style, IComponent component, String selector) {
        if (con != null && style != null && component != null) {
            this.setPosition(con, style, component);
            this.setPadding(con, style, selector);
            this.setDimension(con, style, component);
            this.setBackground(con, style, component);
            this.setBorder(con, style, component);
            this.setOpacity(con, style);
            this.setRotation(con, style, component);
            this.setShadow(con, style);
            this.setSpacing(con, style);
            this.setHidden(con, component);
            this.setCursor(con, component);
            this.setZIndex(con, component);
        }
    }

    public <S extends IStyle> void setPosition(CssRule con, S style, IComponent component) {
        if (this.isNoEventRule.booleanValue()) {
            ILayout layout = component.getApiLayout();
            if (layout != null && layout.getApiLayoutType().equals((Object)ILayout.ApiLayoutType.FREE)) {
                this.setFreePosition(con, style, "absolute");
            } else if (layout != null && component instanceof IShape && !(component instanceof IRectangle)) {
                con.add(StyleProperty.POSITION, "relative");
            }
        }
    }

    protected <S extends IStyle> void setFreePosition(CssRule con, S style, String position) {
        if (con != null && style != null) {
            String top = style.getProperty(StyleProperty.TOP);
            String left = style.getProperty(StyleProperty.LEFT);
            if (top != null && left != null) {
                con.add(StyleProperty.POSITION, position);
                con.add(StyleProperty.TOP, top);
                con.add(StyleProperty.LEFT, left);
            }
        }
    }

    protected void removePositionAttributes(CssRule con) {
        if (con != null) {
            con.remove(StyleProperty.POSITION);
            con.remove(StyleProperty.TOP);
            con.remove(StyleProperty.LEFT);
            con.remove(StyleProperty.MARGIN_LEFT);
            con.remove(StyleProperty.MARGIN_RIGHT);
        }
    }

    protected void removeDimensionAttributes(CssRule con) {
        if (con != null) {
            con.remove(StyleProperty.WIDTH);
            con.remove(StyleProperty.HEIGHT);
            con.removeExpression(StyleProperty.WIDTH);
            con.removeExpression(StyleProperty.HEIGHT);
        }
    }

    protected <S extends IStyle> void setOpacity(CssRule con, S style) {
        if (con != null && style != null && style.getProperty(StyleProperty.OPACITY) != null) {
            Integer transparency = style.getPropertyAsInteger(StyleProperty.OPACITY);
            if (!this.isNoEventRule.booleanValue() || transparency != 0) {
                con.add(StyleProperty.OPACITY, Float.toString((float)(100 - transparency) / 100.0f));
            }
        }
    }

    protected <S extends IStyle> void setBackground(CssRule con, S style, IComponent component) {
        if (con != null && style != null && CssControllerUtils.hasBackground(style).booleanValue()) {
            con.add(StyleProperty.BACKGROUND_COLOR, style.getProperty(StyleProperty.BACKGROUND_COLOR));
            String bgImage = style.getProperty(StyleProperty.BACKGROUND_IMAGE);
            String backgroundImageRule = null;
            if (bgImage != null) {
                backgroundImageRule = this.getBackgroundImageRule(Paths.getImagePath(this.imagePathPrefix, bgImage));
                con.add(StyleProperty.BACKGROUND_REPEAT, style.getProperty(StyleProperty.BACKGROUND_REPEAT));
                con.add(StyleProperty.BACKGROUND_POSITION, style.getProperty(StyleProperty.BACKGROUND_POSITION));
                con.add(StyleProperty.BACKGROUND_ATTACHMENT, style.getProperty(StyleProperty.BACKGROUND_ATTACHMENT));
            }
            if (CssControllerUtils.hasGradient(style).booleanValue()) {
                String firstPartOfRule;
                String string = firstPartOfRule = backgroundImageRule != null ? String.valueOf(backgroundImageRule) + ", " : "";
                if (this.isNoEventRule.booleanValue()) {
                    con.add(StyleProperty.MOZILLA_BACKGROUND_GRADIENT, String.valueOf(firstPartOfRule) + style.getProperty(StyleProperty.MOZILLA_BACKGROUND_GRADIENT));
                    con.add(StyleProperty.WEBKIT_BACKGROUND_GRADIENT, String.valueOf(firstPartOfRule) + style.getProperty(StyleProperty.WEBKIT_BACKGROUND_GRADIENT));
                    con.add(StyleProperty.WEBKIT_OLD_BACKGROUND_GRADIENT, String.valueOf(firstPartOfRule) + style.getProperty(StyleProperty.WEBKIT_OLD_BACKGROUND_GRADIENT));
                    con.add(StyleProperty.OPERA_BACKGROUND_GRADIENT, String.valueOf(firstPartOfRule) + style.getProperty(StyleProperty.OPERA_BACKGROUND_GRADIENT));
                    con.add(StyleProperty.BACKGROUND_GRADIENT, String.valueOf(firstPartOfRule) + style.getProperty(StyleProperty.BACKGROUND_GRADIENT));
                } else {
                    con.add(StyleProperty.MOZILLA_BACKGROUND_GRADIENT_SUFFIXED, String.valueOf(firstPartOfRule) + style.getProperty(StyleProperty.MOZILLA_BACKGROUND_GRADIENT));
                    con.add(StyleProperty.WEBKIT_BACKGROUND_GRADIENT_SUFFIXED, String.valueOf(firstPartOfRule) + style.getProperty(StyleProperty.WEBKIT_BACKGROUND_GRADIENT));
                    con.add(StyleProperty.WEBKIT_OLD_BACKGROUND_GRADIENT_SUFFIXED, String.valueOf(firstPartOfRule) + style.getProperty(StyleProperty.WEBKIT_OLD_BACKGROUND_GRADIENT));
                    con.add(StyleProperty.OPERA_BACKGROUND_GRADIENT_SUFFIXED, String.valueOf(firstPartOfRule) + style.getProperty(StyleProperty.OPERA_BACKGROUND_GRADIENT));
                    con.add(StyleProperty.BACKGROUND_GRADIENT_SUFFIXED, String.valueOf(firstPartOfRule) + style.getProperty(StyleProperty.BACKGROUND_GRADIENT));
                }
            } else if (backgroundImageRule != null) {
                con.add(StyleProperty.BACKGROUND_IMAGE, backgroundImageRule);
            } else {
                con.add(StyleProperty.BACKGROUND_IMAGE, "none");
            }
        }
    }

    public String getBackgroundImageRule(String imgPath) {
        StringBuilder rule = new StringBuilder();
        rule.append("url('");
        rule.append(imgPath);
        rule.append("')");
        return rule.toString();
    }

    protected <S extends IStyle> void setBorder(CssRule con, S style, IComponent component) {
        if (con != null && style != null) {
            this.setNormalBorder(con, style);
            if (CssControllerUtils.hasBorder(style).booleanValue() && !this.isNoEventRule.booleanValue() && !CssControllerUtils.hasRoundedBorder(style).booleanValue()) {
                style.add(StyleProperty.BORDER_TOP_LEFT_RADIUS, "0");
                style.add(StyleProperty.BORDER_TOP_RIGHT_RADIUS, "0");
                style.add(StyleProperty.BORDER_BOTTOM_LEFT_RADIUS, "0");
                style.add(StyleProperty.BORDER_BOTTOM_RIGHT_RADIUS, "0");
            }
            if (CssControllerUtils.hasRoundedBorder(style).booleanValue()) {
                if (this.isNoEventRule.booleanValue()) {
                    this.setRoundedBorder(con, style);
                    this.adapt(con, style, component);
                } else {
                    IStyle mergeStyle = component.getApiStyle();
                    mergeStyle.getProperties().putAll(style.getProperties());
                    this.setRoundedBorder(con, mergeStyle);
                    this.adapt(con, mergeStyle, component);
                }
            }
        }
    }

    private <S extends IStyle> void setNormalBorder(CssRule con, S style) {
        if (con != null && style != null) {
            if (this.isNoEventRule.booleanValue()) {
                if (CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_TOP_STYLE).booleanValue()) {
                    con.add(StyleProperty.BORDER_TOP_WIDTH, style.getProperty(StyleProperty.BORDER_TOP_WIDTH));
                    con.add(StyleProperty.BORDER_TOP_STYLE, style.getProperty(StyleProperty.BORDER_TOP_STYLE));
                    con.add(StyleProperty.BORDER_TOP_COLOR, style.getProperty(StyleProperty.BORDER_TOP_COLOR));
                }
                if (CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_RIGHT_STYLE).booleanValue()) {
                    con.add(StyleProperty.BORDER_RIGHT_WIDTH, style.getProperty(StyleProperty.BORDER_RIGHT_WIDTH));
                    con.add(StyleProperty.BORDER_RIGHT_STYLE, style.getProperty(StyleProperty.BORDER_RIGHT_STYLE));
                    con.add(StyleProperty.BORDER_RIGHT_COLOR, style.getProperty(StyleProperty.BORDER_RIGHT_COLOR));
                }
                if (CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_BOTTOM_STYLE).booleanValue()) {
                    con.add(StyleProperty.BORDER_BOTTOM_WIDTH, style.getProperty(StyleProperty.BORDER_BOTTOM_WIDTH));
                    con.add(StyleProperty.BORDER_BOTTOM_STYLE, style.getProperty(StyleProperty.BORDER_BOTTOM_STYLE));
                    con.add(StyleProperty.BORDER_BOTTOM_COLOR, style.getProperty(StyleProperty.BORDER_BOTTOM_COLOR));
                }
                if (CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_LEFT_STYLE).booleanValue()) {
                    con.add(StyleProperty.BORDER_LEFT_WIDTH, style.getProperty(StyleProperty.BORDER_LEFT_WIDTH));
                    con.add(StyleProperty.BORDER_LEFT_STYLE, style.getProperty(StyleProperty.BORDER_LEFT_STYLE));
                    con.add(StyleProperty.BORDER_LEFT_COLOR, style.getProperty(StyleProperty.BORDER_LEFT_COLOR));
                }
            } else {
                con.add(StyleProperty.BORDER_TOP_WIDTH, style.getProperty(StyleProperty.BORDER_TOP_WIDTH));
                con.add(StyleProperty.BORDER_TOP_STYLE, style.getProperty(StyleProperty.BORDER_TOP_STYLE));
                con.add(StyleProperty.BORDER_TOP_COLOR, style.getProperty(StyleProperty.BORDER_TOP_COLOR));
                con.add(StyleProperty.BORDER_RIGHT_WIDTH, style.getProperty(StyleProperty.BORDER_RIGHT_WIDTH));
                con.add(StyleProperty.BORDER_RIGHT_STYLE, style.getProperty(StyleProperty.BORDER_RIGHT_STYLE));
                con.add(StyleProperty.BORDER_RIGHT_COLOR, style.getProperty(StyleProperty.BORDER_RIGHT_COLOR));
                con.add(StyleProperty.BORDER_BOTTOM_WIDTH, style.getProperty(StyleProperty.BORDER_BOTTOM_WIDTH));
                con.add(StyleProperty.BORDER_BOTTOM_STYLE, style.getProperty(StyleProperty.BORDER_BOTTOM_STYLE));
                con.add(StyleProperty.BORDER_BOTTOM_COLOR, style.getProperty(StyleProperty.BORDER_BOTTOM_COLOR));
                con.add(StyleProperty.BORDER_LEFT_WIDTH, style.getProperty(StyleProperty.BORDER_LEFT_WIDTH));
                con.add(StyleProperty.BORDER_LEFT_STYLE, style.getProperty(StyleProperty.BORDER_LEFT_STYLE));
                con.add(StyleProperty.BORDER_LEFT_COLOR, style.getProperty(StyleProperty.BORDER_LEFT_COLOR));
            }
        }
    }

    private <S extends IStyle> void setRoundedBorder(CssRule con, S style) {
        long radius;
        if (!(con == null || style == null || (radius = CssControllerUtils.calculateBorderRadius(style)) == 0L && this.isNoEventRule.booleanValue())) {
            String borderRadius = String.valueOf(radius) + "px";
            String shortHandProperty = "";
            shortHandProperty = style.getProperty(StyleProperty.BORDER_TOP_LEFT_RADIUS) != null ? String.valueOf(shortHandProperty) + borderRadius : String.valueOf(shortHandProperty) + "0px";
            shortHandProperty = style.getProperty(StyleProperty.BORDER_TOP_RIGHT_RADIUS) != null ? String.valueOf(shortHandProperty) + " " + borderRadius : String.valueOf(shortHandProperty) + " 0px";
            shortHandProperty = style.getProperty(StyleProperty.BORDER_BOTTOM_RIGHT_RADIUS) != null ? String.valueOf(shortHandProperty) + " " + borderRadius : String.valueOf(shortHandProperty) + " 0px";
            shortHandProperty = style.getProperty(StyleProperty.BORDER_BOTTOM_LEFT_RADIUS) != null ? String.valueOf(shortHandProperty) + " " + borderRadius : String.valueOf(shortHandProperty) + " 0px";
            con.add(StyleProperty.BORDER_RADIUS, shortHandProperty);
        }
    }

    protected <S extends IStyle> void adapt(CssRule con, S style, IComponent component) {
        long radius;
        if (TypeAdaptor.getComponentType((ITarget)component) == TypeAdaptor.ComponentType.RECTANGLE || TypeAdaptor.getComponentType((ITarget)component) == TypeAdaptor.ComponentType.IMAGE) {
            return;
        }
        if (con != null && style != null && (radius = CssControllerUtils.calculateBorderRadius(style)) != 0L) {
            long radiusPadding = Math.round((double)radius / 2.0);
            long topPadding = style.getPropertyAsInteger(StyleProperty.PADDING_TOP).intValue();
            long rightPadding = style.getPropertyAsInteger(StyleProperty.PADDING_RIGHT).intValue();
            long bottomPadding = style.getPropertyAsInteger(StyleProperty.PADDING_BOTTOM).intValue();
            long leftPadding = style.getPropertyAsInteger(StyleProperty.PADDING_LEFT).intValue();
            long topBorder = 0L;
            long bottomBorder = 0L;
            long leftBorder = 0L;
            long rightBorder = 0L;
            if (CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_TOP_STYLE).booleanValue() && (CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_LEFT_STYLE).booleanValue() || CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_RIGHT_STYLE).booleanValue())) {
                topPadding += radiusPadding;
                topBorder = style.getPropertyAsInteger(StyleProperty.BORDER_TOP_WIDTH).intValue();
            }
            if (CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_RIGHT_STYLE).booleanValue() && (CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_TOP_STYLE).booleanValue() || CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_BOTTOM_STYLE).booleanValue())) {
                rightPadding += radiusPadding;
                rightBorder = style.getPropertyAsInteger(StyleProperty.BORDER_RIGHT_WIDTH).intValue();
            }
            if (CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_BOTTOM_STYLE).booleanValue() && (CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_LEFT_STYLE).booleanValue() || CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_RIGHT_STYLE).booleanValue())) {
                bottomPadding += radiusPadding;
                bottomBorder = style.getPropertyAsInteger(StyleProperty.BORDER_BOTTOM_WIDTH).intValue();
            }
            if (CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_LEFT_STYLE).booleanValue() && (CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_TOP_STYLE).booleanValue() || CssControllerUtils.isBorderVisible(style, StyleProperty.BORDER_BOTTOM_STYLE).booleanValue())) {
                leftPadding += radiusPadding;
                leftBorder = style.getPropertyAsInteger(StyleProperty.BORDER_LEFT_WIDTH).intValue();
            }
            con.add(StyleProperty.PADDING_TOP, String.valueOf(topPadding) + "px");
            con.add(StyleProperty.PADDING_RIGHT, String.valueOf(rightPadding) + "px");
            con.add(StyleProperty.PADDING_BOTTOM, String.valueOf(bottomPadding) + "px");
            con.add(StyleProperty.PADDING_LEFT, String.valueOf(leftPadding) + "px");
            if (this.isNoEventRule.booleanValue()) {
                boolean auto = false;
                boolean autoWidth = false;
                boolean autoHeight = false;
                if (component instanceof ITextComponent) {
                    auto = ((ITextComponent)component).getApiAutoFit();
                }
                if (auto) {
                    if (component instanceof ITextComponent && ((ITextComponent)component).isApiSingleLine()) {
                        autoWidth = true;
                    }
                    if (!(component instanceof ICallout)) {
                        autoHeight = true;
                    }
                }
                if (!autoWidth) {
                    con.add(StyleProperty.WIDTH, String.valueOf(Math.max((long)style.getPropertyAsInteger(StyleProperty.WIDTH).intValue() - leftBorder - rightBorder - leftPadding - rightPadding, 0L)) + "px");
                }
                if (!autoHeight) {
                    con.add(StyleProperty.HEIGHT, String.valueOf(Math.max((long)style.getPropertyAsInteger(StyleProperty.HEIGHT).intValue() - topBorder - bottomBorder - topPadding - bottomPadding, 0L)) + "px");
                }
            } else {
                con.addExpression(StyleProperty.WIDTH, "Math.max(" + style.getPropertyAsInteger(StyleProperty.WIDTH) + " - " + leftBorder + " - " + rightBorder + " - " + leftPadding + " - " + rightPadding + ", 0) + '" + "px" + "'");
                con.addExpression(StyleProperty.HEIGHT, "Math.max(" + style.getPropertyAsInteger(StyleProperty.HEIGHT) + " - " + topBorder + " - " + bottomBorder + " - " + topPadding + " - " + bottomPadding + ", 0) + '" + "px" + "'");
            }
        }
    }

    public String getBorderRule(Integer width, int style, EVCColor color) {
        StringBuilder rule = new StringBuilder();
        rule.append(width);
        rule.append("px ");
        rule.append(Style.getBorderStyleAttribute((int)style));
        rule.append(" ");
        rule.append(color.toHex());
        return rule.toString();
    }

    protected <S extends IStyle> void setDimension(CssRule con, S style, IComponent component) {
        if (style != null && (style.getProperty(StyleProperty.WIDTH) != null || style.getProperty(StyleProperty.HEIGHT) != null)) {
            Integer height = style.getPropertyAsInteger(StyleProperty.HEIGHT);
            Integer width = style.getPropertyAsInteger(StyleProperty.WIDTH);
            switch (TypeAdaptor.getComponentType((ITarget)component)) {
                case FILE: {
                    width = width - FILE_ICON_MARGIN;
                    break;
                }
            }
            if (this.isNoEventRule.booleanValue()) {
                int newHeight;
                int newWidth;
                Integer boTop = style.getPropertyAsInteger(StyleProperty.BORDER_TOP_WIDTH);
                Integer boBottom = style.getPropertyAsInteger(StyleProperty.BORDER_BOTTOM_WIDTH);
                Integer boLeft = style.getPropertyAsInteger(StyleProperty.BORDER_LEFT_WIDTH);
                Integer boRight = style.getPropertyAsInteger(StyleProperty.BORDER_RIGHT_WIDTH);
                Integer pTop = style.getPropertyAsInteger(StyleProperty.PADDING_TOP);
                Integer pBottom = style.getPropertyAsInteger(StyleProperty.PADDING_BOTTOM);
                Integer pLeft = style.getPropertyAsInteger(StyleProperty.PADDING_LEFT);
                Integer pRight = style.getPropertyAsInteger(StyleProperty.PADDING_RIGHT);
                if (component instanceof IShape && !(component instanceof IRectangle) || component instanceof ITable) {
                    newWidth = width;
                    newHeight = height;
                } else {
                    newWidth = Math.max(width - boLeft - boRight - pLeft - pRight, 0);
                    newHeight = Math.max(height - boTop - boBottom - pTop - pBottom, 0);
                }
                boolean auto = false;
                if (component instanceof ITextComponent) {
                    auto = ((ITextComponent)component).getApiAutoFit();
                }
                if (auto) {
                    if (component instanceof IRichText && !((ITextComponent)component).isApiSingleLine()) {
                        con.add(StyleProperty.WIDTH, String.valueOf(newWidth) + "px");
                    } else {
                        con.add(StyleProperty.WIDTH, "auto");
                    }
                    if (component instanceof ICallout) {
                        con.add(StyleProperty.HEIGHT, String.valueOf(newHeight) + "px");
                    } else {
                        con.add(StyleProperty.HEIGHT, "auto");
                    }
                } else {
                    con.add(StyleProperty.WIDTH, String.valueOf(newWidth) + "px");
                    con.add(StyleProperty.HEIGHT, String.valueOf(newHeight) + "px");
                }
            } else {
                String identity = this.getSelector(component);
                con.addExpression(StyleProperty.WIDTH, String.valueOf(this.getWidthExpression(String.valueOf(width), identity)) + " + 'px'");
                con.addExpression(StyleProperty.HEIGHT, String.valueOf(this.getHeightExpression(String.valueOf(height), identity)) + " + 'px'");
            }
        }
    }

    protected String getWidthExpression(String width, String identity) {
        return "Math.max(" + width + " - jimEvent.fn.getCurrentStyle('border-left-width', '" + identity + "') - jimEvent.fn.getCurrentStyle('border-right-width', '" + identity + "') - jimEvent.fn.getCurrentStyle('padding-left', '" + identity + "') - jimEvent.fn.getCurrentStyle('padding-right', '" + identity + "'),0)";
    }

    protected String getHeightExpression(String height, String identity) {
        return "Math.max(" + height + " - jimEvent.fn.getCurrentStyle('border-top-width', '" + identity + "') - jimEvent.fn.getCurrentStyle('border-bottom-width', '" + identity + "') - jimEvent.fn.getCurrentStyle('padding-top', '" + identity + "') - jimEvent.fn.getCurrentStyle('padding-bottom', '" + identity + "'),0)";
    }

    protected <S extends IStyle> void setVerticalAlignment(CssRule con, S style) {
        if (con != null && style != null) {
            con.add(StyleProperty.VERTICAL_ALIGN, style.getProperty(StyleProperty.VERTICAL_ALIGN));
        }
    }

    public <S extends IStyle> void setText(CssRule con, S style) {
        if (con != null && style != null) {
            con.add(StyleProperty.COLOR, style.getProperty(StyleProperty.COLOR));
            con.add(StyleProperty.TEXT_ALIGN, style.getProperty(StyleProperty.TEXT_ALIGN));
            con.add(StyleProperty.TEXT_DECORATION, style.getProperty(StyleProperty.TEXT_DECORATION));
            if (style.getProperty(StyleProperty.FONT_FAMILY) != null) {
                con.add(StyleProperty.FONT_FAMILY, String.valueOf(style.getProperty(StyleProperty.FONT_FAMILY)) + ",Arial");
            }
            con.add(StyleProperty.FONT_SIZE, style.getProperty(StyleProperty.FONT_SIZE));
            con.add(StyleProperty.FONT_STYLE, style.getProperty(StyleProperty.FONT_STYLE));
            con.add(StyleProperty.FONT_WEIGHT, style.getProperty(StyleProperty.FONT_WEIGHT));
        }
    }

    protected void setOverflow(CssRule con, Integer overflow) {
        if (this.isNoEventRule.booleanValue() && con != null) {
            con.add(StyleProperty.OVERFLOW, Style.getOverflowAttribute((int)overflow));
        }
    }

    protected void setOverflow(CssRule con, ILayout.ApiOverflowType overflowX, ILayout.ApiOverflowType overflowY) {
        if (this.isNoEventRule.booleanValue() && con != null) {
            String overflow = overflowX.toString();
            con.add(StyleProperty.OVERFLOW_X, overflow.equals("wrap") ? "hidden" : overflow);
            overflow = overflowY.toString();
            con.add(StyleProperty.OVERFLOW_Y, overflow.equals("wrap") ? "hidden" : overflow);
        }
    }

    protected CssRule setHidden(CssRule con, IComponent component) {
        if (this.isNoEventRule.booleanValue() && con != null && component != null && component.isApiHidden().booleanValue()) {
            con.add(StyleProperty.DISPLAY, "none");
        }
        return con;
    }

    protected void setCursor(CssRule con, IComponent component) {
        if (component.getApiCanvas().getApiPrototype().getApiSimulationSettings().getApiSimulationDevice().equals((Object)SimulationDevice.WEB) && this.isNoEventRule.booleanValue() && con != null && component != null) {
            if (this.showCursorForEvent(component).booleanValue()) {
                con.add(StyleProperty.CURSOR, "pointer");
            } else {
                switch (TypeAdaptor.getComponentType((ITarget)component)) {
                    case DATE: 
                    case FILE: 
                    case TEXT: 
                    case PASSWORD: 
                    case TEXTAREA: {
                        con.add(StyleProperty.CURSOR, "text");
                        break;
                    }
                    case TREENODE: {
                        con.add(StyleProperty.CURSOR, "pointer");
                        break;
                    }
                }
            }
        }
    }

    protected <S extends IStyle> void setPadding(CssRule con, S style, String selector) {
        if (con != null && style != null) {
            if (this.isNoEventRule.booleanValue()) {
                if (CssControllerUtils.hasPadding(style, StyleProperty.PADDING_TOP).booleanValue()) {
                    con.add(StyleProperty.PADDING_TOP, style.getProperty(StyleProperty.PADDING_TOP));
                }
                if (CssControllerUtils.hasPadding(style, StyleProperty.PADDING_RIGHT).booleanValue()) {
                    con.add(StyleProperty.PADDING_RIGHT, style.getProperty(StyleProperty.PADDING_RIGHT));
                }
                if (CssControllerUtils.hasPadding(style, StyleProperty.PADDING_BOTTOM).booleanValue()) {
                    con.add(StyleProperty.PADDING_BOTTOM, style.getProperty(StyleProperty.PADDING_BOTTOM));
                }
                if (CssControllerUtils.hasPadding(style, StyleProperty.PADDING_LEFT).booleanValue()) {
                    con.add(StyleProperty.PADDING_LEFT, style.getProperty(StyleProperty.PADDING_LEFT));
                }
            } else {
                if (CssControllerUtils.hasPadding(style, StyleProperty.PADDING_RIGHT).booleanValue() || CssControllerUtils.hasPadding(style, StyleProperty.PADDING_LEFT).booleanValue() || CssControllerUtils.hasPadding(style, StyleProperty.PADDING_TOP).booleanValue() || CssControllerUtils.hasPadding(style, StyleProperty.PADDING_BOTTOM).booleanValue()) {
                    con.add(StyleProperty.WIDTH, "jimEvent.fn.getCurrentStyle('width', '" + selector + "') + jimEvent.fn.getCurrentStyle('padding-left', '" + selector + "') + jimEvent.fn.getCurrentStyle('padding-right', '" + selector + "') - " + style.getPropertyAsInteger(StyleProperty.PADDING_LEFT) + " - " + style.getPropertyAsInteger(StyleProperty.PADDING_RIGHT));
                    con.add(StyleProperty.HEIGHT, "jimEvent.fn.getCurrentStyle('height', '" + selector + "') + jimEvent.fn.getCurrentStyle('padding-top', '" + selector + "') + jimEvent.fn.getCurrentStyle('padding-bottom', '" + selector + "') - " + style.getPropertyAsInteger(StyleProperty.PADDING_TOP) + " - " + style.getPropertyAsInteger(StyleProperty.PADDING_BOTTOM));
                }
                con.add(StyleProperty.PADDING_TOP, style.getProperty(StyleProperty.PADDING_TOP));
                con.add(StyleProperty.PADDING_RIGHT, style.getProperty(StyleProperty.PADDING_RIGHT));
                con.add(StyleProperty.PADDING_BOTTOM, style.getProperty(StyleProperty.PADDING_BOTTOM));
                con.add(StyleProperty.PADDING_LEFT, style.getProperty(StyleProperty.PADDING_LEFT));
            }
        }
    }

    protected <S extends IStyle> void setRotation(CssRule con, S style, IComponent component) {
        if (con != null && style != null) {
            if (this.isNoEventRule.booleanValue()) {
                if (CssControllerUtils.isRotated(style).booleanValue()) {
                    con.add(StyleProperty.WEBKIT_ROTATION_ANGLE, style.getProperty(StyleProperty.WEBKIT_ROTATION_ANGLE));
                    con.add(StyleProperty.MOZ_ROTATION_ANGLE, style.getProperty(StyleProperty.MOZ_ROTATION_ANGLE));
                    con.add(StyleProperty.ROTATION_ANGLE, style.getProperty(StyleProperty.ROTATION_ANGLE));
                }
            } else {
                con.add(StyleProperty.WEBKIT_ROTATION_ANGLE, style.getProperty(StyleProperty.WEBKIT_ROTATION_ANGLE));
                con.add(StyleProperty.MOZ_ROTATION_ANGLE, style.getProperty(StyleProperty.MOZ_ROTATION_ANGLE));
                con.add(StyleProperty.ROTATION_ANGLE, style.getProperty(StyleProperty.ROTATION_ANGLE));
            }
        }
    }

    protected String getMarginLeft(Integer align) {
        return align == 1 ? "0px" : "auto";
    }

    protected String getMarginRight(Integer align) {
        return align == 3 ? "0px" : "auto";
    }

    protected <S extends IStyle> void setShadow(CssRule con, S style) {
        this.setBoxShadow(con, style);
        this.setTextShadow(con, style);
    }

    protected <S extends IStyle> void setBoxShadow(CssRule con, S style) {
        String boxShadowProperty;
        if (con != null && style != null && (boxShadowProperty = style.getProperty(StyleProperty.BOX_SHADOW)) != null) {
            if (this.isNoEventRule.booleanValue()) {
                if (!boxShadowProperty.equals("")) {
                    con.add(StyleProperty.BOX_SHADOW, boxShadowProperty);
                }
            } else {
                con.add(StyleProperty.BOX_SHADOW, boxShadowProperty);
            }
        }
    }

    protected <S extends IStyle> void setTextShadow(CssRule con, S style) {
        String textShadowProperty;
        if (con != null && style != null && (textShadowProperty = style.getProperty(StyleProperty.TEXT_SHADOW)) != null) {
            if (this.isNoEventRule.booleanValue()) {
                if (!textShadowProperty.equals("")) {
                    con.add(StyleProperty.TEXT_SHADOW, textShadowProperty);
                }
            } else {
                con.add(StyleProperty.TEXT_SHADOW, textShadowProperty);
            }
        }
    }

    protected <S extends IStyle> void setSpacing(CssRule con, S style) {
        if (con != null && style != null && !this.isNoEventRule.booleanValue()) {
            con.add(StyleProperty.PADDING_LEFT, style.getProperty(StyleProperty.SPACING_HORIZONTAL));
            con.add(StyleProperty.PADDING_TOP, style.getProperty(StyleProperty.SPACING_VERTICAL));
        }
    }

    protected Boolean showCursorForEvent(IComponent component) {
        if (component != null) {
            for (IEvent event : component.getApiEvents()) {
                switch (event.getApiEventType()) {
                    case ON_CLICK: 
                    case ON_MOUSE_DOWN: 
                    case ON_MOUSE_UP: 
                    case ON_DOUBLE_CLICK: 
                    case ON_RIGHT_CLICK: 
                    case ON_TOGGLE: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected void shortenFontStyle(CssRule con) {
        if (con != null) {
            String style = con.get(StyleProperty.FONT_STYLE);
            String weight = con.get(StyleProperty.FONT_WEIGHT);
            String size = con.get(StyleProperty.FONT_SIZE);
            String family = con.get(StyleProperty.FONT_FAMILY);
            String lineHeight = con.get(StyleProperty.LINE_HEIGHT);
            if (size != null) {
                StringBuilder fontCss = new StringBuilder();
                if (!"normal".equals(style)) {
                    fontCss.append(style);
                    fontCss.append(" ");
                }
                if (!"normal".equals(weight)) {
                    fontCss.append(weight);
                    fontCss.append(" ");
                }
                fontCss.append(size);
                if (lineHeight != null) {
                    fontCss.append("/");
                    fontCss.append(lineHeight);
                }
                fontCss.append(" ");
                fontCss.append(family);
                con.add(StyleProperty.FONT, fontCss.toString());
                con.remove(StyleProperty.FONT_STYLE);
                con.remove(StyleProperty.FONT_WEIGHT);
                con.remove(StyleProperty.FONT_SIZE);
                con.remove(StyleProperty.FONT_FAMILY);
                con.remove(StyleProperty.LINE_HEIGHT);
            }
        }
    }

    protected String getSelector(IComponent component) {
        StringBuilder selector = new StringBuilder();
        ICanvas canvas = component.getApiCanvas();
        String identity = ControllerUtils.getID(component);
        if (component instanceof RootComponent) {
            selector.append("#");
            selector.append(ControllerUtils.getID(component));
            if (canvas instanceof IMaster) {
                selector.append(".master");
            }
        } else {
            selector.append("#");
            selector.append(ControllerUtils.getID((IComponent)canvas.getApiRoot()));
            selector.append(" ");
            if (Utils.isComponentIntoDataView((IComponent)component)) {
                IDataView dataView = Utils.getClosestFreeDataView((IComponent)component);
                String listID = ControllerUtils.getID((IComponent)dataView);
                selector.append("#");
                selector.append(listID);
                selector.append(" ");
                selector.append(".");
            } else {
                selector.append("#");
            }
            selector.append(identity);
        }
        return selector.toString();
    }

    protected String getSVGTextSelector(IComponent component) {
        StringBuilder selector = new StringBuilder();
        ICanvas canvas = component.getApiCanvas();
        String identity = "shapewrapper-" + ControllerUtils.getID(component);
        selector.append("#");
        selector.append(ControllerUtils.getID((IComponent)canvas.getApiRoot()));
        selector.append(" ");
        selector.append(Utils.isComponentIntoDataView((IComponent)component) ? "." : "#");
        selector.append(identity);
        return selector.toString();
    }

    protected static <S extends IStyle> Boolean isBorderVisible(S style, StyleProperty borderSegment) {
        if (style.getProperty(borderSegment) != null && !style.getProperty(borderSegment).equals("none")) {
            return true;
        }
        return false;
    }

    protected static <S extends IStyle> Boolean hasBackground(S style) {
        if (style.getProperty(StyleProperty.BACKGROUND_COLOR) == null && !CssControllerUtils.hasGradient(style).booleanValue()) {
            return false;
        }
        return true;
    }

    public static <S extends IStyle> Boolean hasRoundedBorder(S style) {
        if (style.getProperty(StyleProperty.BORDER_TOP_LEFT_RADIUS) == null && style.getProperty(StyleProperty.BORDER_TOP_RIGHT_RADIUS) == null && style.getProperty(StyleProperty.BORDER_BOTTOM_LEFT_RADIUS) == null && style.getProperty(StyleProperty.BORDER_BOTTOM_RIGHT_RADIUS) == null) {
            return false;
        }
        return true;
    }

    public static <S extends IStyle> Boolean hasBorder(S style) {
        if (style.getProperty(StyleProperty.BORDER_BOTTOM_WIDTH) == null && style.getProperty(StyleProperty.BORDER_TOP_WIDTH) == null && style.getProperty(StyleProperty.BORDER_LEFT_WIDTH) == null && style.getProperty(StyleProperty.BORDER_RIGHT_WIDTH) == null) {
            return false;
        }
        return true;
    }

    public static <S extends IStyle> Boolean hasGradient(S style) {
        if (style.getProperty(StyleProperty.PIE_BACKGROUND_GRADIENT) == null && style.getProperty(StyleProperty.WEBKIT_BACKGROUND_GRADIENT) == null && style.getProperty(StyleProperty.WEBKIT_OLD_BACKGROUND_GRADIENT) == null && style.getProperty(StyleProperty.MOZILLA_BACKGROUND_GRADIENT) == null && style.getProperty(StyleProperty.OPERA_BACKGROUND_GRADIENT) == null && style.getProperty(StyleProperty.IE7_FILTER) == null) {
            return false;
        }
        return true;
    }

    public static <S extends IStyle> Boolean hasShadow(S style) {
        if ((style.getProperty(StyleProperty.BOX_SHADOW) == null || style.getProperty(StyleProperty.BOX_SHADOW).equals("none")) && (style.getProperty(StyleProperty.TEXT_SHADOW) == null || style.getProperty(StyleProperty.TEXT_SHADOW).equals("none"))) {
            return false;
        }
        return true;
    }

    protected static <S extends IStyle> Boolean hasPadding(S style, StyleProperty paddingSegment) {
        if (style.getPropertyAsInteger(paddingSegment) != 0) {
            return true;
        }
        return false;
    }

    protected static <S extends IStyle> Boolean hasSpacing(S style, StyleProperty spacingProperty) {
        if (style.getPropertyAsInteger(spacingProperty) != 0) {
            return true;
        }
        return false;
    }

    public static <S extends IStyle> Boolean isRotated(S style) {
        if (style.getProperty(StyleProperty.WEBKIT_ROTATION_ANGLE) == null && style.getProperty(StyleProperty.MOZ_ROTATION_ANGLE) == null && style.getProperty(StyleProperty.IE_ROTATION_ANGLE) == null && style.getProperty(StyleProperty.ROTATION_ANGLE) == null) {
            return false;
        }
        return true;
    }

    protected static <S extends IStyle> long calculateBorderRadius(S style) {
        Integer radius = style.getPropertyAsInteger(StyleProperty.BORDER_TOP_LEFT_RADIUS) | style.getPropertyAsInteger(StyleProperty.BORDER_TOP_RIGHT_RADIUS) | style.getPropertyAsInteger(StyleProperty.BORDER_BOTTOM_LEFT_RADIUS) | style.getPropertyAsInteger(StyleProperty.BORDER_BOTTOM_RIGHT_RADIUS);
        return Math.round((double)(Math.min(style.getPropertyAsInteger(StyleProperty.WIDTH), style.getPropertyAsInteger(StyleProperty.HEIGHT)) * radius) / 200.0);
    }

    protected void setCanvasAlignment(CssRule con, ICanvas canvas) {
        ICanvas.ApiCanvasAlignmentType align = canvas.getApiCanvasAlignment();
        boolean isWebPrototype = canvas.getApiPrototype().getApiDevice().equals((Object)SimulationDevice.WEB);
        if (con != null && align != null) {
            con.add(StyleProperty.POSITION, "relative");
            if (isWebPrototype && align.equals((Object)ICanvas.ApiCanvasAlignmentType.CENTER)) {
                con.add(StyleProperty.MARGIN, "0 auto");
                con.add(StyleProperty.WIDTH, canvas.getApiCanvasWidth() + "px");
                con.add(StyleProperty.MIN_WIDTH, canvas.getApiCanvasWidth() + "px");
                con.add(StyleProperty.MIN_HEIGHT, canvas.getApiCanvasHeight() + "px");
            } else {
                con.add(StyleProperty.WIDTH, "100%");
                con.add(StyleProperty.HEIGHT, "100%");
            }
        }
    }

    protected void setZIndex(CssRule con, IComponent component) {
        if (this.isNoEventRule.booleanValue() && con != null && component != null && component.isApiOnTop().booleanValue()) {
            con.add(StyleProperty.Z_INDEX, "100");
        }
    }

    protected Boolean inDataView(IComponent component) {
        IHeaderRow header;
        Boolean inDataRow = false;
        IDataRow row = (IDataRow)Utils.getParent((IComponent)component, IDataRow.class);
        if (row != null && (header = row.getApiParent().getApiHeader()) != null) {
            inDataRow = !header.equals(row);
        }
        if (inDataRow.booleanValue()) {
            return inDataRow;
        }
        IDataGridCell gridCell = (IDataGridCell)Utils.getParent((IComponent)component, IDataGridCell.class);
        if (gridCell != null) {
            return true;
        }
        return false;
    }
}

