/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.css;

import com.justinmind.prototyper.api.ui.StyleProperty;
import java.util.LinkedHashMap;
import java.util.Map;

public class CssRule {
    private static final String TEMPLATE_CSSRULE = "CssRule";
    private final transient String template;
    private transient String selector;
    private final transient Map<StyleProperty, String> attributes;
    private final transient Map<StyleProperty, String> expressions;

    public CssRule() {
        this.template = TEMPLATE_CSSRULE;
        this.attributes = new LinkedHashMap<StyleProperty, String>();
        this.expressions = new LinkedHashMap<StyleProperty, String>();
    }

    public CssRule(String selector) {
        this.selector = selector;
        this.template = TEMPLATE_CSSRULE;
        this.attributes = new LinkedHashMap<StyleProperty, String>();
        this.expressions = new LinkedHashMap<StyleProperty, String>();
    }

    public CssRule(CssRule original, String selector) {
        this.selector = selector;
        this.template = original.getTemplate();
        this.attributes = new LinkedHashMap<StyleProperty, String>(original.getAttributes());
        this.expressions = new LinkedHashMap<StyleProperty, String>(original.getExpressions());
    }

    public String get(StyleProperty key) {
        return this.attributes.get(key);
    }

    public String getExpression(StyleProperty key) {
        return this.expressions.get(key);
    }

    public void add(StyleProperty key, String value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
    }

    public void addAppending(StyleProperty key, String value) {
        if (value != null) {
            if (this.attributes.containsKey(key)) {
                String appended = String.valueOf(this.attributes.get(key)) + " " + value;
                this.attributes.put(key, appended);
            } else {
                this.attributes.put(key, value);
            }
        }
    }

    public void addExpression(StyleProperty key, String expression) {
        if (expression != null) {
            this.expressions.put(key, expression);
        }
    }

    public void remove(StyleProperty key) {
        if (key != null) {
            this.attributes.remove(key);
        }
    }

    public void removeExpression(StyleProperty key) {
        if (key != null) {
            this.expressions.remove(key);
        }
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty() && this.expressions.isEmpty();
    }

    public String getTemplate() {
        return this.template;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public Map<StyleProperty, String> getAttributes() {
        return this.attributes;
    }

    public Map<StyleProperty, String> getExpressions() {
        return this.expressions;
    }
}

