/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.css;

import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ContextController;
import com.justinmind.generator.context.css.CssControllerUtils;
import com.justinmind.generator.context.css.CssRule;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.Paths;
import com.justinmind.prototyper.api.ui.StyleProperty;
import java.util.List;
import org.stringtemplate.v4.ST;

public class CssScaleController
extends ContextController {
    private static final String GROUP_URL = "com/justinmind/generator/context/css/CssView.stg";
    private static final String TEMPLATE = "Css";
    private static final String EXTENSION = ".css";
    protected static final String RULES = "rules";
    public static final String ID_SELECTOR = "#";
    public static final String CLASS_SELECTOR = ".";
    public static final String SCALED_DIV = "zoomDiv";
    protected final transient CssControllerUtils utils;

    public CssScaleController(ApplicationContext applicationContext) {
        super(applicationContext);
        this.utils = this.createCssControllerUtils(applicationContext);
    }

    protected CssControllerUtils createCssControllerUtils(ApplicationContext applicationContext) {
        return new CssControllerUtils(applicationContext);
    }

    protected CssControllerUtils getControllerUtils() {
        return this.utils;
    }

    @Override
    protected String getGroupURL() {
        return GROUP_URL;
    }

    @Override
    public void generate() throws GeneratorException {
        String fileName = Paths.getScaleStyleOutput(this.paths.output, this.applicationContext.getTime());
        ST context = this.group.getInstanceOf(TEMPLATE);
        boolean fitToScreen = this.prototype.getApiSimulationSettings().hasApiFitScreen();
        double scale = fitToScreen ? 100 : this.prototype.getApiSimulationSettings().getApiScale();
        if (scale != 100.0 & scale != 0.0 || fitToScreen) {
            CssRule scaleRule = new CssRule("#zoomDiv");
            scaleRule.add(StyleProperty.WIDTH, "100%");
            scaleRule.add(StyleProperty.HEIGHT, "100%");
            scaleRule.add(StyleProperty.POSITION, "absolute");
            scaleRule.add(StyleProperty.DISPLAY, "block");
            double scale12 = scale / 100.0;
            String value = "scale(" + scale12 + ")";
            scaleRule.add(StyleProperty.TRANSFORM, value);
            scaleRule.add(StyleProperty.WEBKIT_TRANSFORM, value);
            scaleRule.add(StyleProperty.MOZ_TRANSFORM, value);
            scaleRule.add(StyleProperty.IE_TRANSFORM, value);
            String originValue = "top left";
            scaleRule.add(StyleProperty.TRANSFORM_ORIGIN, originValue);
            scaleRule.add(StyleProperty.WEBKIT_TRANSFORM_ORIGIN, originValue);
            scaleRule.add(StyleProperty.MOZ_TRANSFORM_ORIGIN, originValue);
            scaleRule.add(StyleProperty.IE_TRANSFORM_ORIGIN, originValue);
            context.add(RULES, (Object)scaleRule);
            double invScale = 100.0 / scale * 100.0;
            CssRule canvasRule = new CssRule("#zoomDiv > .template, #zoomDiv > .screen");
            canvasRule.add(StyleProperty.WIDTH, String.valueOf(invScale) + "%");
            canvasRule.add(StyleProperty.HEIGHT, String.valueOf(invScale) + "%");
            context.add(RULES, (Object)canvasRule);
            this.outputEngine.write(fileName, context, this.strategy);
        }
    }

    protected void addRule(List<CssRule> rules, CssRule rule) {
        if (!rule.isEmpty()) {
            rules.add(rule);
        }
    }

    protected String getExtension() {
        return EXTENSION;
    }
}

