/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.css;

import com.justinmind.evc.model.actions.AttributeForm;
import com.justinmind.evc.model.actions.EVCFont;
import com.justinmind.evc.model.actions.RichText;
import com.justinmind.evc.model.actions.RootComponent;
import com.justinmind.evc.model.actions.TextBox;
import com.justinmind.evc.model.actions.TextRange;
import com.justinmind.evc.model.actions.navigationComponents.NavigationItem;
import com.justinmind.evc.model.events.StyleElementActionEvent;
import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.css.CssController;
import com.justinmind.generator.context.css.FontRule;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.Paths;
import com.justinmind.generator.engine.modeladaptor.TypeAdaptor;
import com.justinmind.prototyper.api.ui.IStyle;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.component.IRootComponent;
import com.justinmind.prototyper.api.ui.event.IBlock;
import com.justinmind.prototyper.api.ui.event.ICase;
import com.justinmind.prototyper.api.ui.event.IEvent;
import com.justinmind.prototyper.api.ui.event.ITarget;
import com.justinmind.prototyper.api.ui.event.action.IAction;
import java.util.ArrayList;
import java.util.List;
import org.stringtemplate.v4.ST;

public class FontController
extends CssController {
    private static final String GROUP_URL = "com/justinmind/generator/context/css/CssView.stg";
    private static final String TEMPLATE = "FontRules";
    private List<String> generatedFontList;

    public FontController(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    protected String getGroupURL() {
        return GROUP_URL;
    }

    @Override
    public void generate() throws GeneratorException {
        this.generatedFontList = new ArrayList<String>();
        ArrayList<FontRule> cssRules = new ArrayList<FontRule>();
        for (ICanvas canvas : this.prototype.getApiCanvases()) {
            IRootComponent root = canvas.getApiRoot();
            cssRules.addAll(this.processCssFontRules((IComponent)root, root.getApiStyle()));
            cssRules.addAll(this.processCssEventFontRules((IComponent)root, root.getApiStyle()));
        }
        String fileName = Paths.getFontFaceOutput(this.paths.output, this.applicationContext.getTime());
        ST context = this.group.getInstanceOf(TEMPLATE);
        if (!cssRules.isEmpty()) {
            context.add("rules", cssRules);
        }
        this.generatedFontList.clear();
        this.outputEngine.write(fileName, context, this.strategy);
    }

    private List<FontRule> processCssFontRules(IComponent component, IStyle style) {
        ArrayList<FontRule> rules = new ArrayList<FontRule>();
        TypeAdaptor.ComponentType type = TypeAdaptor.getComponentType((ITarget)component);
        ArrayList<EVCFont> fontList = new ArrayList<EVCFont>();
        block0 : switch (type) {
            case ROOTCOMPONENT: {
                ICanvas canvas = ((IRootComponent)component).getApiCanvas();
                switch (TypeAdaptor.getComponentType((ITarget)canvas)) {
                    case SCREEN: 
                    case TEMPLATE: 
                    case MASTER: {
                        rules.addAll(this.processChildrenFont(component));
                        break block0;
                    }
                }
                break;
            }
            case MASTERINSTANCE: 
            case GROUP: 
            case DYNAMICPANEL: 
            case PANEL: 
            case TABLE: 
            case ROW: 
            case CELLCONTAINER: 
            case DATAGRID: 
            case DATALIST: 
            case DATAROW: 
            case DATACELL: {
                rules.addAll(this.processChildrenFont(component));
                break;
            }
            case TEXTCELL: 
            case RICHTEXT: 
            case BUTTON: 
            case LABEL: 
            case RECTANGLE: 
            case ELLIPSE: 
            case TRIANGLE: 
            case CALLOUT: {
                RichText richText = (RichText)component;
                if (richText.getLookNFeel().getFontStyle().getEVCFont() != null) {
                    fontList.add(richText.getLookNFeel().getFontStyle().getEVCFont());
                }
                for (TextRange range : richText.getRanges()) {
                    if (range.getLookNFeel().getFontStyle().getEVCFont() == null) continue;
                    fontList.add(range.getLookNFeel().getFontStyle().getEVCFont());
                }
                break;
            }
            case MENUNODE: 
            case TREENODE: {
                NavigationItem nodes = (NavigationItem)component;
                if (nodes.getLookNFeel().getFontStyle().getEVCFont() == null) break;
                fontList.add(nodes.getLookNFeel().getFontStyle().getEVCFont());
                break;
            }
            case INDEX: 
            case SUMMARY: {
                TextBox textBox = (TextBox)component;
                if (textBox.getLookNFeel().getFontStyle().getEVCFont() == null) break;
                fontList.add(textBox.getLookNFeel().getFontStyle().getEVCFont());
                break;
            }
            case DATE: 
            case TIME: 
            case DATETIME: 
            case FILE: 
            case TEXT: 
            case PASSWORD: 
            case TEXTAREA: 
            case SELECTIONLIST: 
            case MULTISELECTIONLIST: 
            case DROPDOWN: 
            case CHECKBOXLIST: 
            case RADIOBUTTONLIST: {
                AttributeForm attForm = (AttributeForm)component;
                if (attForm.getLookNFeel().getFontStyle().getEVCFont() == null) break;
                fontList.add(attForm.getLookNFeel().getFontStyle().getEVCFont());
                break;
            }
        }
        if (fontList.size() >= 0) {
            for (EVCFont font : fontList) {
                FontRule fontCon = new FontRule();
                fontCon.setFamilyName(font.getNameOriginal());
                String url = "../fonts/" + fontCon.getFamilyName();
                fontCon.addEOT(url);
                fontCon.addWOFF(url);
                fontCon.addTTF(url);
                fontCon.addSVG(url);
                if (this.generatedFontList.contains(font.getNameOriginal())) continue;
                this.generatedFontList.add(font.getNameOriginal());
                this.addRule(rules, fontCon);
            }
        }
        return rules;
    }

    protected List<FontRule> processChildrenFont(IComponent component) {
        ArrayList<FontRule> rules = new ArrayList<FontRule>();
        for (IComponent child : component.getApiChildren()) {
            rules.addAll(this.processCssFontRules(child, child.getApiStyle()));
        }
        return rules;
    }

    private List<FontRule> processCssEventFontRules(IComponent component, IStyle style) {
        ArrayList<FontRule> rules = new ArrayList<FontRule>();
        ArrayList<EVCFont> fontList = new ArrayList<EVCFont>();
        List events = ((RootComponent)component).getApiCanvas().getApiAllEvents();
        if (!events.isEmpty()) {
            for (IEvent event : events) {
                for (ICase eventCase : event.getApiCases()) {
                    for (IBlock block : eventCase.getApiBlocks()) {
                        block6: for (IAction action : block.getApiActions()) {
                            TypeAdaptor.ActionType type = TypeAdaptor.getActionType(action);
                            switch (type) {
                                case CHANGESTYLE: {
                                    StyleElementActionEvent s = (StyleElementActionEvent)action;
                                    if (s.getLookNFeel() == null || s.getLookNFeel().getFontStyle() == null || s.getLookNFeel().getFontStyle().getEVCFont() == null) continue block6;
                                    fontList.add(s.getLookNFeel().getFontStyle().getEVCFont());
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (fontList.size() >= 0) {
            for (EVCFont font : fontList) {
                FontRule fontCon = new FontRule();
                fontCon.setFamilyName(font.getNameOriginal());
                String url = "../fonts/" + fontCon.getFamilyName();
                fontCon.addEOT(url);
                fontCon.addWOFF(url);
                fontCon.addTTF(url);
                fontCon.addSVG(url);
                if (this.generatedFontList.contains(font.getNameOriginal())) continue;
                this.generatedFontList.add(font.getNameOriginal());
                this.addRule(rules, fontCon);
            }
        }
        return rules;
    }

    protected void addRule(List<FontRule> rules, FontRule rule) {
        rules.add(rule);
    }
}

